<?php

#
#   FILE:  SPT--EditAnnouncementComplete.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       F_Id
#           - record ID of existing announcement (if any)
#       F_Heading
#       F_Text
#           - headline and text of new or modified announcement
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function SaveAnnouncementChanges($Id, $Heading, $Text)
{
    global $DB;
    global $User;

    # if announcement ID already determined
    if (isset($Id))
    {
        # update existing announcment entry
        $DB->Query(sprintf("UPDATE Announcements SET "
                ."AnnouncementHeading='%s', "
                ."AnnouncementText='%s' "
                ."WHERE AnnouncementId=%d",
                addslashes($Heading),
                addslashes($Text),
                $Id));
    }
    else
    {
        # add announcement to database
        $DB->Query(sprintf("INSERT INTO Announcements "
                ."(AnnouncementHeading, AnnouncementText, DatePosted, PosterId) VALUES "
                ."('%s', '%s', NOW(), %d)",
                addslashes($Heading),
                addslashes($Text),
                $User->Get("UserId")));
    }
}

function DeleteAnnouncement($Id)
{
    global $DB;

    # if announcement ID is available
    if (isset($Id))
    {
        # delete announcement
        $DB->Query("DELETE FROM Announcements WHERE AnnouncementId=${Id}");
    }
}


# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_NEWSADMIN);

# load vars from arrays
$SubmitResult = $HTTP_POST_VARS["SubmitResult"];
$F_Heading = $HTTP_POST_VARS["F_Heading"];
$F_Text = $HTTP_POST_VARS["F_Text"];

if (isset($HTTP_GET_VARS["F_Id"]))
    $F_Id = $HTTP_GET_VARS["F_Id"];
else
    $F_Id = $Session->Get("F_Id");

if (isset($HTTP_GET_VARS["F_Editing"]))
    $F_Editing = $HTTP_GET_VARS["F_Editing"];
else
    $F_Editing = $Session->Get("F_Editing");

# copy over any new values from form
if (isset($F_Heading)) {  $AnnouncementHeading = trim($F_Heading);  }
if (isset($F_Text))    {  $AnnouncementText = trim($F_Text);  }

# if submission was requested
if (($SubmitResult == "Submit") && 
    ((strlen($AnnouncementHeading) > 0) ||
    (strlen($AnnouncementText) > 0)))
{
    # save new or changed announcement
    SaveAnnouncementChanges($F_Id, $AnnouncementHeading, $AnnouncementText);

    # head to home page
    PrintAutoRefreshPage("Announcement or News Item Added/Edited",
        "SPT--Home.php");
}
# else if deletion was requested or announcement text was erased
elseif (($SubmitResult == "Delete") || 
        (($SubmitResult == "Submit") && 
        (strlen($AnnouncementHeading) == 0) && 
        (strlen($AnnouncementText) == 0)))
{
    # delete announcement
    DeleteAnnouncement($F_Id);

    # head to home page
    PrintAutoRefreshPage("Announcement or News Item Removed", "SPT--Home.php");
}
# else if cancellation requested
elseif ($SubmitResult == "Cancel")
{
    # head to home page
    PrintAutoRefreshPage("Announcement or News Item Editing Cancelled",
        "SPT--Home.php");
}
else
{
    # preserve headline and story values
    $Session->PassVariable("AnnouncementHeading", $AnnouncementHeading);
    $Session->PassVariable("AnnouncementText", $AnnouncementText);
    $Session->PassVariable("F_Id", $F_Id);
    if (isset($F_Editing))
    {
        $Session->PassVariable("F_Editing", $F_Editing);
    }

    # go back to announcement editing page
    PrintAutoRefreshPage("Previewing Announcement or News Item",
        "SPT--EditAnnouncement.php");
}

?>
