<?php

#
#   FILE:  SPT--ExportUsersExecute.php
#
#   FUNCTIONS PROVIDED:
#       ExportComplete()
#       PrintResourceCount()
#       PrintExportLink()
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# see if export is complete
function ExportComplete()
{
    global $Session;

    $ExportComplete = $Session->Get("ExportComplete");

    return ($ExportComplete == 1) ? true : false;
}

# print Resource Count
function PrintUserCount()
{
    global $Session;

    print $Session->Get("UserCount");
}

# print link to downloadable exported file
function PrintExportLink()
{
    global $Session;

    print "<a href=\"".$Session->Get("FileName")."\">";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# init variables -- first time thru they will be null
function InitExportVars()
{
    global $DB, $ExportComplete, $UserCount;

    if (is_null($ExportComplete))
        $ExportComplete = 0;
    if (is_null($UserCount))
        $UserCount = 0;

    $DB->Query("Select * from APUsers Limit $UserCount, 50");
    if ($DB->NumRowsSelected() == 0)
        $ExportComplete = 1;
}

# do/while loop, this is the main event
function DoWhileLoop()
{
    global $DB, $DB1, $FP, $Session, $ExportComplete;
    global $UserCount, $FSeek, $TotalLineCount;
    global $PrivDescriptions;

    $Schema = & new MetadataSchema();

    while ($Entry = $DB->FetchNextRowArray())
    {
        if ($Entry["BrowsingFieldId"] > 0)
        {
            $Field = $Schema->GetField($Entry["BrowsingFieldId"]);
            if (is_object($Field))
                $BrowsingField = $Field->Name();    
            else
                $BrowsingField = NULL;
        }
        else
            $BrowsingField = NULL;

        $Output = $Entry["UserName"]."\t".
                  $Entry["UserPassword"]."\t".
                  $Entry["EMail"]."\t".
                  $Entry["WebSite"]."\t".
                  $Entry["RealName"]."\t".
                  $Entry["AddressLineOne"]."\t".
                  $Entry["AddressLineTwo"]."\t".
                  $Entry["City"]."\t".
                  $Entry["State"]."\t".
                  $Entry["Country"]."\t".
                  $Entry["ZipCode"]."\t".
                  $Entry["ActiveUI"]."\t".
                  $BrowsingField."\t\n";

        fwrite($FP, $Output);
        $UserCount++;

        # now export privileges for this user
        $UserName = $Entry["UserName"];
        $NewUser = & new User($DB1, $UserName);
        $PrivList = $NewUser->GetPrivList();

        foreach ($PrivList as $Privilege)
        {
            if (is_numeric($Privilege))
            {
                $Privilege = $PrivDescriptions[$Privilege];
                $Output = $UserName."\t\t\t\t\t\t\t\t\t\t\t\t\t".
                            $Privilege."\n";
                fwrite($FP, $Output);
            }
        }
    }
    if ($UserCount % 50 != 0)
        $ExportComplete = 1;
}

# function to get list of matching files
function ListDir($DirPath, $Pattern)
{
    static $ResultArray = array();  

    $Handle = opendir($DirPath);
    while ($File = readdir($Handle))
    {
        if ($File == '.' || $File == '..')
            continue;
        if (is_dir($DirPath.$File))
            continue;
        else if (preg_match($Pattern, $File))
            $ResultArray[]=$DirPath.$File;
    }
    closedir($Handle);
    return $ResultArray;
}

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$DB =& new SPTDatabase();
$DB1 =& new SPTDatabase();

if (isset($HTTP_POST_VARS["Submit"]) && $HTTP_POST_VARS["Submit"] == "Cancel")
{
    PrintAutoRefreshPage("System Administration", "SPT--SysAdmin.php");
    exit;
}

InitExportVars();

# open export path
$ExportPath = $Session->Get("ExportPath");
if (is_null($ExportPath))
{
    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];
    $FileName = "TempStorage/Users_".date("YmdHis").".txt";
    $ExportPath = dirname($ScriptFileName)."/".$FileName;

    # remove any old exported files
    $OldExportFiles = ListDir(dirname($ScriptFileName)."/".
        "TempStorage/", "/^Users_.*\.txt$/");

    if (is_array($OldExportFiles))
    {
        foreach ($OldExportFiles as $OldFile)
        {
            unlink($OldFile);
        }
    }
}

$FP = fopen($ExportPath, "a");
if ($FP == FALSE)
{
    $ErrorMessage = "Cannot open Export Filename: $ExportPath<br>";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("ErrorMessage", "SPT--DisplayError.php");
    exit;
}

# the main work happenes here
DoWhileLoop();

$Session->PassVariable("ExportComplete", $ExportComplete);
$Session->PassVariable("UserCount", $UserCount);
$Session->PassVariable("FileName", $FileName);
$Session->PassVariable("TotalLineCount", $TotalLineCount);
$Session->PassVariable("ExportPath", $ExportPath);

#  Time to auto-refresh?
if ($ExportComplete == 0)
{
    $AutoRefreshToPage = "SPT--ExportUsersExecute.php";
}

PageTitle("Export Users");
include("include/SPT--StandardHtmlPageLoad.php");

if ($ExportComplete == 1)
{
    fclose($FP);
}

?>
