<?php
#
#   FILE:  SPT--PostMessage.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Forum.php");
require_once("include/SPT--Topic.php");
require_once("include/SPT--Message.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function CheckForEdit()
{
    global $MessageId, $User, $ModeratorId, $PosterId;

    if (!empty($MessageId) && ($User->Get("UserId") == $ModeratorId ||
        $User->Get("UserId") == $PosterId || $User->HasPriv(PRIV_SYSADMIN)))
        return true;
    else
        return false;
}

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumName()
{
    global $ForumName;

    print stripslashes($ForumName);
}

function PrintParentId()
{
    global $ParentId;

    print $ParentId;
}

function PrintTopic()
{
    global $F_TopicName;

    print stripslashes($F_TopicName);
}

function PrintMessageId()
{
    global $MessageId;

    print stripslashes($MessageId);
}

function PrintSubject()
{
    global $F_Subject;

    print GetHtmlEscapedString($F_Subject);
}

function PrintBody()
{
    global $F_Body;

    # filter out "Edited by:" text
    $loc = strpos($F_Body, "<br><br><small>This message edited by");
    if ($loc === false)
        print GetHtmlEscapedString($F_Body);
    else
        print GetHtmlEscapedString(substr($F_Body, 0, $loc - 2));  
} 

# print out any error messages
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed 
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if (isset($HTTP_GET_VARS["topicid"]))
{
    $ParentId = $HTTP_GET_VARS["topicid"];
    $TopicId = $HTTP_GET_VARS["topicid"];
}
else
{
    $TopicId = $Session->Get("topicid");
    $ParentId = $Session->Get("topicid");
}

$Topic =& new Topic($TopicId);
$F_TopicName = $Topic->TopicName();

if (isset($HTTP_GET_VARS["forumid"]))
    $ForumId = $HTTP_GET_VARS["forumid"];
else
    $ForumId = $Session->Get("forumid");

$Forum =& new Forum($ForumId);
$ForumName = $Forum->ForumName();
$ModeratorId = $Forum->ModeratorId();

if (!empty($HTTP_GET_VARS["messageid"]))
{
    $MessageId = $messageid;
    $Message =& new Message($MessageId);
    $F_Subject = $Message->Subject();
    $F_Body = $Message->Body();
    $PosterId = $Message->PosterId();
}
else
{
    if (isset($HTTP_POST_VARS["F_Subject"]))
        $F_Subject = $HTTP_POST_VARS["F_Subject"];
    else
        $F_Subject = $Session->Get("F_Subject");
    if (isset($HTTP_POST_VARS["F_Body"]))
        $F_Body = $HTTP_POST_VARS["F_Body"];
    else
        $F_Body = $Session->Get("F_Body");
}

$Session->PassVariable("forumid", $ForumId);
$Session->PassVariable("topicid", $TopicId);

PageTitle("Post Message");
CheckAuthorization( PRIV_POSTTOFORUMS );
include("include/SPT--StandardHtmlPageLoad.php");

?>
