ALTER TABLE SystemConfiguration ADD COLUMN NumAnnounceOnHomePage INT DEFAULT 5;

CREATE TABLE MetadataFields (
    FieldId                 INT NOT NULL AUTO_INCREMENT,
    FieldName               TEXT NOT NULL,
    FieldType               ENUM("Text", "Number", "Date", "TimeStamp", "Paragraph", "Flag", "Tree", "ControlledName", "Option", "User"),
    Description             TEXT,
    RequiredBySPT           INT DEFAULT 0,
    Enabled                 INT DEFAULT 1,
    Optional                INT DEFAULT 1,
    AllowMultiple           INT DEFAULT 0,
    IncludeInKeywordSearch  INT DEFAULT 0,
    IncludeInAdvancedSearch INT DEFAULT 0,
    TextFieldSize           INT,
    MaxLength               INT,
    ParagraphRows           INT,
    ParagraphCols           INT,
    DefaultValue            TEXT,
    MinValue                INT,
    MaxValue                INT,
    FlagOnLabel             TEXT,
    FlagOffLabel            TEXT,
    DateFormat              TEXT,
    DateFormatIsPerRecord   INT,
    SearchWeight            INT,
    INDEX                   (FieldId)
);

-- set up initial metadata field definitions (must match Resources table)
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Title',                  'Text',             1,1,0,NULL,1,1,30,  100, NULL,NULL,NULL,NULL,NULL,   '','','',5, "Name by which the resource is formally known. Title is used and displayed as a headline in the SPT. This field is a required field. Required fields may not be customized as to the field type or disabled. Required fields must be completed in each resource record.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Alternate Title',        'Text',             0,1,1,NULL,1,0,30,  100, NULL,NULL,NULL,NULL,NULL,   '','',NULL,3, "This is a variant name by which resources may be known. It allows access when the exact title may impede retrieval and includes complete names/words abbreviated in the Title, commonly known name, or an associated text.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Description',            'Paragraph',        1,1,0,NULL,1,1,NULL,NULL,12,  38,  NULL,NULL,NULL,   '','',NULL,1, "Text describing the scope, subject matter, and usefulness of the resource. Sometimes this field is also referred to as account of the content of the resource or an annotation. Description may include but is not limited to: an abstract, table of contents, reference to a graphical representation of content or a free-text account of the content. This is a required field. Required fields may not be customized as to the field type or disabled. Required fields must be completed in each resource record.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Url',                    'Text',             1,1,0,NULL,1,1,30,  100, NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "The complete, current location of the resource. Because of the functionality of the domain limit, remember to always add the trialing slash after the domain. This is a required field. Required fields may not be customized as to the field type or disabled. Required fields must be completed in each resource record.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Release Flag',           'Flag',             1,1,0,NULL,0,0,NULL,NULL,NULL,NULL,0,NULL,NULL,   'OK for Viewing','Not OK for Viewing',NULL,NULL, "This internal administrative feature allows resource administrators to withhold record from public view and searching. Intended to provide a method for internal review and editing. The record will only be available for view by authorized resource editors and site administrator and is not available in the Advanced search. This is a required field. Required fields may not be customized as to the field type or disabled. In the Administration database editor feature, portal administrators may set the default value for this field.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Source',                 'Text',             0,1,1,NULL,0,1,30,  100, NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "A Reference to a resource from which the present resource is derived. The present resource may be derived from the Source resource in whole or in part. Dublin Core Metadata Initiative recommended best practice is to reference the resource by means of a string or number conforming to a formal identification system.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Relation',               'Text',             0,1,1,NULL,0,1,30,  100, NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "A reference to a related resource. Dublin Core Metadata Initiative recommended best practice is to reference the resource by means of a string or number conforming to a formal identification system.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Coverage',               'Text',             0,1,1,NULL,0,1,30,  100, NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "The extent or scope of the content of the resource. Coverage will typically include spatial location (a place name or geographic coordinates), temporal period (a period label, date, or date range) or jurisdiction (such as a named administrative entity). Dublin Core Metadata Initiative recommended best practice is to select a value from a controlled vocabulary (for example, the Getty Thesaurus of Geographic Names) and that, where appropriate, named places or time periods be used in preference to numeric identifiers such as sets of coordinates or date ranges.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Rights',                 'Text',             0,1,1,NULL,0,1,30,  100, NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "Information about rights held in and over the resource. Typically, a Rights element will contain a rights management statement for the resource, or reference a service providing such information. Rights information often encompasses Intellectual Property Rights, Copyright, and various Property Rights.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Email Address',          'Text',             0,1,1,NULL,0,1,30,  100, NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "The email address for contact of the creator, editor, site administrator, manager, information desk, user support agent, etc. or other entity responsible for answering questions and correspondence regarding the resource.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Date Issued',            'Date',             1,1,0,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','','YYYY-MM-DD',NULL, "The year the resource being described was created, published, or otherwise made available. Records a date in a standard format.  Users do not need to enter the date in this format. The software will translate a provided date into the standard format (YYYY-MM-DD).  It is also possible to enter a partial date or an open ended (continuing) date or qualify the date in the case of uncertainty. Examples of some possible additional date forms are below:");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Date Of Record Creation','TimeStamp',        0,1,0,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','','YYYY-MM-DD HH:MM:SS',NULL, "Date the resource being described was entered into the database collection. This date may be entered in the same manner as described above in Date Issued definition. The software automatically enters the current date if this field is left uncompleted.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Date Record Checked',    'Date',             1,1,0,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','','YYYY-MM-DD HH:MM:SS',NULL, "Date the URL of the resource being described was determined to be accurate and adequately addressed by the cataloging record.  This date may be entered in the same manner as described above in Date Issued definition.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Date Last Modified',     'TimeStamp',        1,1,0,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,NULL, "This is a time stamp recording the last time anything in a given resource record was altered. This date cannot be manually edited.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Verification Attempts',  'Number',           0,0,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0,   999,    '','',NULL,NULL, "This field records the number of attempts a URL checking software has made to confirm the current the accuracy of the URL of the resource. By default this when the portal software is shipped, this field is disabled and does not appear visible anywhere throughout the portal. Administrators may at any time enable this field in the database editor in the portal Administration.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Added By Id',            'User',             1,1,0,NULL,1,0,NULL,NULL,NULL,NULL,NULL,0,   9999999,'','',NULL,1, "System supplied field which records the account name of the person creating the resource record. This field cannot be directly edited. All resource editors login name with automatically appear as an option in the Metadata Tool search limits and on the full record display.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Last Modified By Id',    'User',             1,1,0,NULL,1,0,NULL,NULL,NULL,NULL,NULL,0,   9999999,'','',NULL,1, "System supplied field which records the account name of the person who last modified the resource record. This field cannot be directly edited. All resource editors login name with automatically appear as an option in the Metadata Tool search limits and on the full record display.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Cumulative Rating',      'Number',           1,0,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0,   5,      '','',NULL,NULL, "This field records the evaluative ratings given to a particular resource by portal users.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Publisher',              'ControlledName',   0,1,1,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,3, "An entity responsible for making the resource available. Examples of a publisher include a person, an organization, or a service. Publishers are not necessarily the creators of the intellectual content of the resource, but they do claim some responsibility for the content. As with the Creator field (above), SPT Metadata Tool allows for a Controlled Name and a Variant Name.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Creator',                'ControlledName',   0,1,1,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,3, "The personal, corporate, meeting/conference, etc. name(s) of the party(s) responsible for creation of resource content. Any work can have single, multiple, corporate, or personal creators. Personal creators are people. Some typical examples of corporate creators are associations, institutions, business firms, non-profit enterprises, governments, government agencies, projects, programs, religious bodies, church groups, and conferences.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Contributor',            'ControlledName',   0,1,1,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,3, "An entity responsible for making contributions to the content of the resource. Examples of a Contributor include a person, an organization, or a service. This field also employs Controlled Names as described above in the definition for Creator.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Subject',                'ControlledName',   0,1,1,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,3, "Terms or a nonhierarchical string of terms relating the resource's content. Recommended best practice is to select from a controlled vocabulary, Library of Congress Subject Headings, etc.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Resource Type',          'Option',           0,1,1,1,   0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "The nature or genre of the content of the resource. Type includes terms describing general categories, functions, genres, or aggregation levels for content. When entering a resource record, the software allows for multiple values to be selected from this field. This field is used in the Advanced Search as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission. NOTE: The default values come from the working draft list of Dublin Core Types. Further, to describe the physical or digital manifestation of the resource, use the FORMAT element per Dublin Core definitions.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Language',               'Option',           0,1,1,1,   0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "A language of the intellectual content of the resource. The default values are selected from several commonly used major languages. The software allows for multiple values to be selected from this field. This field is used by the Advanced Search Engine as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Audience',               'Option',           0,1,1,1,   0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "A category of user for whom the resource is intended. Frequently, creators and publishers of resources in education explicitly state the category of user for whom the resource is intended. In like fashion, end-users in the education/training domain frequently search using audience characteristics as search terms. The default values are drawn from the broadest educational category levels. The software allows for multiple values to be selected from this field. This field is used by the Advanced Search Engine as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Format',                 'Option',           0,1,1,1,   0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,1, "The physical or digital manifestation of the resource. Typically, Format may include the media-type or dimensions of the resource. Format may be used to determine the software, hardware or other equipment needed to display or operate the resource. Examples of dimensions include size and duration. The default values are selections from the list of Internet Media Types (MIME) defining computer media formats.  When entering a resource record, the software allows for multiple values to be selected from this field. This field is used by the Advanced Search Engine as a Limiter. The portal software allows for modifications and edits to these default values through the Edit Option Lists feature on the Metadata Tool navigation bar. This feature will not be visible to anyone without adequate permission.");
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description) VALUES ('Classification',         'Tree',             1,1,1,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,3, "The Metadata Tool allows the use an existing standard classification schema or your organization's homegrown taxonomy. Classification in the portal provides users with a way of browsing through the resources in hierarchical tiers. This approach guides users unfamiliar with terminology to appropriate resources descending in specificity from broadly defined to more precise.  Privilege to to build or edit the vocabulary or taxonomy of assifications requires authorization from the portal administrator.");

ALTER TABLE Resources change DateLastModified DateLastModified DATETIME;
ALTER TABLE Resources change DateIssued DateIssuedBegin DATE;
ALTER TABLE Resources change DateIssuedAlternate DateIssuedEnd DATE;
ALTER TABLE Resources change DateRecordChecked DateRecordCheckedBegin DATE;
ALTER TABLE Resources ADD COLUMN DateIssuedPrecision INT;
ALTER TABLE Resources ADD COLUMN DateRecordCheckedPrecision INT;
ALTER TABLE Resources ADD COLUMN DateRecordCheckedEnd DATE;

-- Fix up DateIssuePrecision based on old DateIssuedFormat
UPDATE Resources SET DateIssuedPrecision = (1 + 2 + 4)       where DateIssuedFormat = "YYYY-MM-DD" OR DateIssuedFormat IS NULL OR DateIssuedFormat = "";
UPDATE Resources SET DateIssuedPrecision = (1 + 2)           where DateIssuedFormat = "YYYY-MM";
UPDATE Resources SET DateIssuedPrecision = (1)               where DateIssuedFormat = "YYYY";
UPDATE Resources SET DateIssuedPrecision = (1 + 2048)        where DateIssuedFormat = "cYYYY";
UPDATE Resources SET DateIssuedPrecision = (1 + 1024)        where DateIssuedFormat = "[YYYY]";
UPDATE Resources SET DateIssuedPrecision = (8 + 1024 + 4096) where DateIssuedFormat = "[YYY-]";
UPDATE Resources SET DateIssuedPrecision = (1 + 4096)        where DateIssuedFormat = "YYYY-";
UPDATE Resources SET DateIssuedPrecision = (1 + 1024 + 4096) where DateIssuedFormat = "[YYYY]-";
UPDATE Resources SET DateIssuedPrecision = (1 + 32 + 4096)   where DateIssuedFormat = "YYYY-YYYY";
UPDATE Resources SET DateIssuedPrecision = (1 + 32 + 8192)   where DateIssuedFormat = "YYYY,YYYY";
UPDATE Resources SET DateIssuedPrecision = (1 + 16384)       where DateIssuedFormat = "YYYY?";
UPDATE Resources SET DateIssuedPrecision = (8 + 16384)       where DateIssuedFormat = "YYY?";
UPDATE Resources SET DateIssuedPrecision = (8)               where DateIssuedFormat = "YYYu";
UPDATE Resources SET DateIssuedPrecision = (16)              where DateIssuedFormat = "YYuu";

-- Now drop the old DateIssuedFormat field
ALTER TABLE Resources DROP COLUMN DateIssuedFormat;

-- DateRecordCheckedPrecision is always YYYY-MM-DD format
UPDATE Resources SET DateRecordCheckedPrecision = 7;

UPDATE ControlledNameTypes SET ControlledNameTypeName = "Resource Type" where ControlledNameTypeName = "ResourceType";
