<?PHP

#
#   FILE:  SPT--SPTUser.php
#
#   METHODS PROVIDED:
#       SPTUser()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/../Axis--User.php");
require_once(dirname(__FILE__)."/../Axis--Session.php");
require_once(dirname(__FILE__)."/SPT--SPTDatabase.php");


class SPTUser extends User {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function SPTUser($UserInfo = NULL)
    {
        global $Session;

        # create database handle for parent and local use
        $DB =& new SPTDatabase();
        $this->DB = $DB;

        # if no user info supplied
        if ($UserInfo == NULL)
        {
            # if session is available in global context
            if (isset($Session))
            {
                # call parent constructor with global session
                $this->User($Session);
            }
            else
            {
                # call parent constructor with our own session
                $OurSession =& new Session($this->DB);
                $this->User($OurSession);
            }
        }
        else
        {
            # call parent constructor with our DB handle
            $this->User($this->DB, $UserInfo);
        }
        
        # if user is logged in
        if ($this->IsLoggedIn())
        {
            # if user already has a UI preferences record in DB
            $DB->Query("SELECT * FROM UserUIPreferences WHERE UserId = '".$this->Id()."'");
            if ($DB->NumRowsSelected())
            {
                # load in UI preferences
                $this->UserUIPreferencesCache = $DB->FetchRow();
            }
            else
            {
                # add UI preferences record to DB for user
                $DB->Query("INSERT INTO UserUIPreferences (UserId) VALUES (".$this->Id().")");
            }
        }
    }
    
    # user interface / accessibility preferences
    function PrefFontSize($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "FontSize", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefFontTypeFace($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "FontTypeFace", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefFontColor($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "FontColor", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefBackgroundColor($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "BackgroundColor", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefColorAvoidanceFlags($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "ColorAvoidanceFlags", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefContentDensity($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "ContentDensity", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefContentView($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "ContentView", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefAudioDescriptionLevel($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "AudioDescriptionLevel", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefAudioDescriptionLanguage($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "AudioDescriptionLanguage", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefVisualDescriptionLanguage($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "VisualDescriptionLanguage", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefImageDescriptionLanguage($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "ImageDescriptionLanguage", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefUseGraphicAlternatives($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "UseGraphicAlternatives", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefSignLanguage($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "SignLanguage", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefCaptionType($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "CaptionType", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }
    function PrefCaptionRate($NewValue = DB_NOVALUE) {  return $this->DB->UpdateValue("UserUIPreferences", "CaptionRate", $NewValue, "UserId = '".$this->Id()."'", $this->UserUIPreferencesCache);  }


    # ---- PRIVATE INTERFACE -------------------------------------------------
    
    var $DB;
    var $UserUIPreferencesCache;

}

# ---- user interface preference mnemonics

# color avoidance flags
define("UIPREF_AVOID_RED",          1);
define("UIPREF_AVOID_REDGREEN",     2);
define("UIPREF_AVOID_BLUEYELLOW",   4);
define("UIPREF_AVOID_GREENYELLOW",  8);
define("UIPREF_AVOID_ORANGE",       16);
define("UIPREF_AVOID_REDBLACK",     32);
define("UIPREF_AVOID_PURPLEGREY",   64);
define("UIPREF_AVOID_USEMAXMONOCHR",128);



# content display options
define("UIPREF_CONTENTDENSITY_NOPREFERENCE", 0);
define("UIPREF_CONTENTDENSITY_DETAILED", 1);
define("UIPREF_CONTENTDENSITY_OVERVIEW", 2);

# content view options
define("UIPREF_CONTENTVIEW_NOPREFERENCE", 0);
define("UIPREF_CONTENTVIEW_TEXTINTENSIVE", 1);
define("UIPREF_CONTENTVIEW_IMAGEINTENSIVE", 2);

# audio description options
define("UIPREF_AUDIODESCRIPTION_NONE", 0);
define("UIPREF_AUDIODESCRIPTION_STANDARD", 1);
define("UIPREF_AUDIODESCRIPTION_EXPANDED", 2);

# caption type options
define("UIPREF_CAPTIONTYPE_NONE", 0);
define("UIPREF_CAPTIONTYPE_VERBATIM", 1);
define("UIPREF_CAPTIONTYPE_REDUCEDREADINGLEVEL", 2);

?>
