<?PHP

#
#   FILE:  SPT--AddClassificationComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   FORM FIELDS EXPECTED:
#       F_NewSegmentName
#           - segment name for new classification
#       F_ParentId
#           - classification ID of classification under which to place new 
#                   classification
#       F_FieldId
#           - FieldId of new classification
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Classification.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------


# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------


# check if current user is authorized
CheckAuthorization(PRIV_CLASSADMIN);

# clear any old error info
if (isset($ErrorMessages))
{
    unset($ErrorMessages);
    $Session->UnregisterVariable("ErrorMessages");
}

$F_FieldId = $HTTP_POST_VARS["F_FieldId"];
$F_ParentId = $HTTP_POST_VARS["F_ParentId"];
$F_NewSegmentName = $HTTP_POST_VARS["F_NewSegmentName"];

if (isset($HTTP_POST_VARS["F_QualifierId"]))
    $F_QualifierId = $HTTP_POST_VARS["F_QualifierId"];
else
    $F_QualifierId = NULL;

if (is_null($F_QualifierId) || $F_QualifierId == "--")
    $F_QualifierId = "NULL";

# if add classification was requested
if ($Submit != "Cancel")
{
    # if new classification segment name is valid
    $F_NewSegmentName = trim($F_NewSegmentName);
    if (strlen($F_NewSegmentName) > 0)
    {
        $F_NewSegmentName = addslashes($F_NewSegmentName);
        # add new classification
        $DB->Query("INSERT INTO Classifications "
                ."(FieldId, "
                        ."ParentId, "
                        ."ResourceCount, "
                        ."QualifierId, "
                        ."SegmentName) VALUES "
                ."($F_FieldId, "
                        ."$F_ParentId, "
                        ."0, "
                        ."$F_QualifierId, "
                        ."'".$F_NewSegmentName."')");

        # fill in rest of values for new classification
        $DB->Query("SELECT LAST_INSERT_ID() AS NewClassId FROM Classifications");
        $Record = $DB->FetchNextRowArray();
        $Class =& new Classification($Record["NewClassId"]);
        $Class->RecalcDepthAndFullName();
    }
    else
    {
        # add message to error list
        $ErrorMessages =& new ErrorList();
        $ErrorMessages->AddMessage(
                "No classification segment name was supplied.");
    }
}

# if errors were found
if (isset($ErrorMessages))
{
    # return to editing page with error messages
    $Session->RegisterVariable("ErrorMessages");
    PrintAutoRefreshPage("Errors Found", 
            "SPT--AddClassification.php?ParentId=".$F_ParentId
                    ."&FieldId=".$F_FieldId);
}
else
{
    # go to classification selection page for parent of edited classification
    PrintAutoRefreshPage("Classification Added", 
            "../SPT--BrowseResources.php?Editing=1&ParentId=".$F_ParentId);
}

?>
