<?php
#
#   FILE:  SPT--AddNewControlledNameComplete.php
#
#   FUNCTIONS PROVIDED:
#       PrintAddedControlledNames()
#           - displays added controlled names and variants 
#
#   FUNCTIONS EXPECTED:
#           - none
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--ControlledName.php");
require_once("include/SPT--Resource.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintAddedControlledName()
{
    global $HTTP_POST_VARS;

    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_Variant = $HTTP_POST_VARS["F_Variant"];

    print $F_ControlledName;
    if (!empty($F_Variant))
        print ", Variant (".$F_Variant.")";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function AddControlledName()
{
    global $Session;
    global $DisplayString;
    global $HTTP_POST_VARS;
    global $ResourceId;
    global $AddedNames;
    global $Variants;
    global $Submit;

    $DB =& new SPTDatabase();
    $Schema = & new MetadataSchema();

    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_FieldId = $HTTP_POST_VARS["F_FieldId"];
    $F_Variant = $HTTP_POST_VARS["F_Variant"];
    if ( isset($HTTP_POST_VARS["F_Qualifier"]) )
        $F_Qualifier = $HTTP_POST_VARS["F_Qualifier"];

    # set "--" to NULL
    if (!isset($F_Qualifier) || is_null($F_Qualifier) || $F_Qualifier == "--")
        $F_Qualifier = "NULL";

    if ((is_null($F_ControlledName) || empty($F_ControlledName)))
    {
        $Session->PassVariable("ErrorMessage",
            "Error: Controlled Name is a required field.");
        if (isset($ResourceId))
            PrintAutoRefreshPage("Error Message", 
                            "SPT--SearchControlledName.php");
        else
            PrintAutoRefreshPage("Error Message", "SPT--AddControlledName.php");
        exit;
    }
    else
    {
        $F_ControlledName = addslashes(trim($F_ControlledName));
        $F_Variant = addslashes(trim($F_Variant));
        if (!empty($F_ControlledName))
        {
            # check to see if it already exists
            $CN = & new ControlledName(NULL, $F_ControlledName, 
                    $F_FieldId, $F_Qualifier, $F_Variant);

            # controlled name found, error        
            if ($CN->Status() == CNSTAT_EXISTS)
            {
                $Session->PassVariable("ErrorMessage",
                    "Error: Controlled Name '".$F_ControlledName.
                    "' already exists.");
                if (isset($ResourceId))    
                    PrintAutoRefreshPage("Error Message", 
                            "SPT--SearchControlledName.php");                  
                else
                    PrintAutoRefreshPage("Error Message",
                            "SPT--AddControlledName.php");     
                exit;
            }

            if (!empty($ResourceId) && strstr($Submit, "Assign to Resource"))
            {
                $Resource = & new Resource($ResourceId);
                $Field = $Schema->GetField($CN->FieldId());
                $Resource->Set($Field->Name(), $CN->Id());
            }
        }
    }
}    

# ----- MAIN -----------------------------------------------------------------

$NavDirCorrection = "../";
CheckAuthorization(PRIV_NAMEADMIN);

# get currently edited resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

# get and pass through default type id
$F_FieldId = $Session->Get("F_FieldId");
$Session->PassVariable("F_FieldId", $F_FieldId);

if (isset($Submit) && substr($Submit, 0, 7) == "Add New")
    AddControlledName();
else
{
    $F_Variant = $HTTP_POST_VARS["F_Variant"];
    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_FieldId = $HTTP_POST_VARS["F_FieldId"];
    $Session->PassVariable("F_Variant", $F_Variant);
    $Session->PassVariable("F_ControlledName", $F_ControlledName);
    $Session->PassVariable("F_FieldId", $F_FieldId);
    PrintAutoRefreshPage("Add Controlled Names", "SPT--AddControlledName.php");
    exit;
}

#  <0 = temporary resource, >0 = existing resource
if ($ResourceId != 0 && strstr($Submit, "Assign to Resource"))
{
    PrintAutoRefreshPage("Add New Resource", "SPT--DBEntry.php");
    exit;
}
# just added new controlled name
else
{
    PageTitle("Add Controlled Name Complete");
    include("include/SPT--StandardHtmlPageLoad.php");
}

?>
