<?php
#
#   FILE:  SPT--DBEntry.php
#
#   FUNCTIONS PROVIDED:
#       DisplayControlledNames()
#           - Displays list of controllednames associated with a record
#             and buttons for adding and deleting them
#
#       GetClassification()
#           - Displays list of classifications associated with the record
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--SPTDate.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--ControlledName.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--ControlledNameFactory.php");
require_once("include/SPT--ClassificationFactory.php");

PageTitle("Add/Edit Resource Record");
# provide relative path to base SPT directory
$NavDirCorrection = "../";

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print the heading
function PrintHeading()
{
    global $ResourceId;

    if ($ResourceId > 0)
        print "Edit Resource";
    else
        print "Add New Resource";
}

# print DBFieldName
function PrintDBFieldName()
{
    global $Field;

    print $Field->DBFieldName();
}

# print FieldId
function PrintFieldId()
{
    global $Field;

    print $Field->Id();
}

# print FieldId
function PrintDefinition()
{
    global $Field;

    print $Field->Description();
}

# print FieldName
function PrintFieldName()
{
    global $Field;

    print $Field->Name();
}

# print FieldName
function PrintTextFieldSize()
{
    global $Field;

    print $Field->TextFieldSize();
}

# print MaxLength
function PrintMaxLength()
{
    global $Field;

    print $Field->MaxLength();
}

# print FlagOnLabel 
function PrintFlagOnLabel()
{
    global $Field;

    print $Field->FlagOnLabel();
}

# print FlagOffLabel 
function PrintFlagOffLabel()
{
    global $Field;

    print $Field->FlagOffLabel();
}

# print ParagraphCols 
function PrintParagraphCols()
{
    global $Field;

    print $Field->ParagraphCols();
}

# print ParagraphRows
function PrintParagraphRows()
{
    global $Field;

    print $Field->ParagraphRows();
}

# print LabelSuffix 
function PrintLabelSuffix()
{
    global $LabelSuffix;

    print $LabelSuffix;
}

# print Field value
function PrintValue()
{
    global $Value;

    print(GetHtmlTranslatedString($Value));
}

# print the Link value
function PrintLink()
{
    global $Link;

    print $Link;
}

# display the buttons
function DisplayButtons()
{
    global $ResourceId;

    if ($ResourceId > 0)
        DisplayUpdateButtons();
    else
        DisplayAddButton();

    # display cancel button
    DisplayOtherButtons();
}

# print out ResourceId
function PrintResourceId()
{
    global $ResourceId;

    print $ResourceId;
}

# function Process Qualifiers
function ProcessQualifiers()
{
    global $Field;
    global $Result;
    global $QualifierId;

    # display qualifier if item level allowed
    if ($Field->UsesQualifiers() && $Field->HasItemLevelQualifiers())
    {
        if (is_object($Result[$Field->Name()." Qualifier"]))
        {
            $Qualifier = $Result[$Field->Name()." Qualifier"]; 
            $QualifierId = $Qualifier->Id();
        }
        else
            $QualifierId = $Field->DefaultQualifier();

        DisplayQualifier();
    }
}

# display all fields
function DisplayAllFields()
{
    global $Result;
    global $LabelSuffix;
    global $Field;
    global $Value;
    global $QualifierId;
    global $User;
    global $ResourceId;
    global $SPTImage;
    global $LastType;

    $Resource = & new Resource($ResourceId);

    # Get the schema
    $Schema = & new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(NULL, MDFORDER_EDITING);

    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            # end the row if last type was OPTION, and current type
            # is not an OPTION
            if ($LastType != $Field->Type() && $LastType == MDFTYPE_OPTION)
                EndRowTag();

            if (!$Field->Optional())
                $LabelSuffix = "<span style=\"color:#CC0000\">*</span>";
            else
                $LabelSuffix = NULL;
            # get value if updating record
            $Default = $Field->DefaultValue(); 
            if (!empty($Result[$Field->Name()]))
                $Value = $Result[$Field->Name()];
            else if (isset($Default))
                $Value = $Default;
            else
                $Value = NULL;

            # suppress display of empty readonly fields
            if(FieldIsReadOnly() && empty($Value) && 
                $Field->Type() != MDFTYPE_FLAG)
                continue;

            switch($Field->Type())
            {
                case MDFTYPE_NUMBER:
                    if ($Field->Name() != "Cumulative Rating")
                    {
                        if(FieldIsReadOnly())
                            DisplayTextFieldReadOnly();
                        else
                            DisplayTextField();
                    }
                    break;

                case MDFTYPE_TEXT:
                    if(FieldIsReadOnly())
                        DisplayTextFieldReadOnly();
                    else
                        DisplayTextField();
                    break;

                case MDFTYPE_PARAGRAPH:
                    if(FieldIsReadOnly())
                        DisplayParagraphFieldReadOnly();
                    else    
                        DisplayParagraph();
                    break;

                case MDFTYPE_DATE:
                    # get value if updating record
                    if (!empty($Result[$Field->Name()]))
                    {
                        $Date = $Result[$Field->Name()];
                        $Value = $Date->Formatted();
                    }
                    # use current date/time if not set and required
                    if (empty($Value) && !$Field->Optional()) 
                        $Value = date("Y-m-d");

                    # suppress empty date fields when read only
                    if(FieldIsReadOnly())
                    {
                        if(!empty($Value))
                            DisplayTextFieldReadOnly();
                    }
                    else
                        DisplayTextField();
                    break;

                case MDFTYPE_TIMESTAMP:
                    if (!empty($Result[$Field->Name()]) && 
                        $Result[$Field->Name()] != "0000-00-00 00:00:00")
                        $Value = $Result[$Field->Name()];
                    # use current date/time if not set
                    else
                        $Value = date("Y-m-d H:i:s");

                    # Don't display Date Last Modified    
                    if ($Field->Name() != "Date Last Modified")
                    {
                        if(FieldIsReadOnly())
                            DisplayTextFieldReadOnly();
                        else
                            DisplayTextField();
                    }
                    break;

                case MDFTYPE_FLAG:
                    # special case for release flag    
                    if($Field->Name() == "Release Flag" && 
                        $User->HasPriv(PRIV_RELEASEADMIN))
                        DisplayFlagField();
                    # Read only field
                    else if(FieldIsReadOnly())
                    {
                        if($Value > 0)
                            $LabelSuffix = $Field->FlagOnLabel();
                        else
                            $LabelSuffix = $Field->FlagOffLabel();
                        DisplayFlagFieldReadOnly();
                    }
                    # normal modifiable field
                    else
                        DisplayFlagField();
				    break;

                case MDFTYPE_TREE:
                    if(FieldIsReadOnly())
                        DisplayTreesReadOnly();
                    else
                    {
                        $ClassFactory = & new ClassificationFactory();
                        if ($ClassFactory->GetItemCount(
                                "FieldId=".$Field->Id()) <= 250)
                        {
                            DisplaySmallNameBegin( $Field->Type() );
                            DisplayClassificationAndJavascript();
                            DisplaySmallNameEnd();
                        }
                        else
                            DisplayTrees();
                    }
                    break;

                case MDFTYPE_OPTION:
                    if(FieldIsReadOnly())
                    {
                        DisplayCNStartReadOnly();
                        DisplayControlledNamesReadOnly();
                        DisplayCNEndReadOnly();
                    }
                    else
                        DisplayOptionField();
                    break;

                case MDFTYPE_CONTROLLEDNAME:
                   if(FieldIsReadOnly())
                    {
                        DisplayCNStartReadOnly();
                        DisplayControlledNamesReadOnly();
                        DisplayCNEndReadOnly();
                    }
                    else
                    {
                        $CNFactory = & new ControlledNameFactory();
                        if ($CNFactory->GetItemCount("FieldId=".$Field->Id())
                            <= 250)
                        {
                            DisplaySmallNameBegin( $Field->Type() );
                            DisplayControlledNameAndJavascript();
                            DisplaySmallNameEnd();
                        }
                        else
                        {
                            DisplayNameBegin();
                            DisplayControlledNames();
                            DisplayNameEnd();
                        }
                    }
                    break;

                case MDFTYPE_USER:
                    $UserObj = $Value;
                    if (is_object($UserObj))
                    {
                        $UserId = $UserObj->Get("UserId");
                        $UserName = $UserObj->Get("UserName");
                        $UserEmail = $UserObj->Get("Email");     
                    }
                    # unknown UserId
                    if (is_null($UserId)) 
                    {
                        $UserName = "Unknown";
                        $UserEmail = "";
                    }
                    DisplayUserField($Field, $UserName, $UserEmail,
                            $Result["Title"]);

                    break;

                case MDFTYPE_IMAGE:
                    $SPTImage = $Resource->GetByField($Field, TRUE);
                    if(FieldIsReadOnly())
                    {
                        $SPTImage = $Resource->GetByField($Field, TRUE);
                        $ResourceId = $Resource->Id();
                        $FieldName = $Field->Name();
                        if ($SPTImage && (is_readable($SPTImage->PreviewUrl())))
                        {
                            DisplayImageFieldReadOnly($FieldName, 
                                "SPT--FullImage.php?ResourceId=${ResourceId}&FieldName=${FieldName}&edit=0",
                                $SPTImage->Height(),
                                $SPTImage->Width(),
                                $SPTImage->PreviewUrl(),
                                $SPTImage->PreviewHeight(),
                                $SPTImage->PreviewWidth(),
                                $SPTImage->AltText());
                        }
                    }
                    else
                    {
                        DisplayImageBegin();
                        DisplayImageEnd();
                    }
                    break;
            }
            # suppress qualifiers for options and controlled names 
            if (!($Field->Type() & MDFTYPE_OPTION|MDFTYPE_CONTROLLEDNAME))
                ProcessQualifiers();

            # save type of last processed field
            $LastType = $Field->Type();
        }
    }
}

# print Qualifier option list
function PrintQualifierList()
{
    global $Field;
    global $QualifierId;

    $QualifierFieldName = $Field->DBFieldName()."Qualifier";

    # first entry is "--"
    $Items = $Field->AssociatedQualifierList();
    $Items["--"] = "--";
    ksort($Items);

    PrintOptionList($QualifierFieldName, $Items, $QualifierId,
        0, 1, NULL, false);
}

# print selected for flag label if flag is set
function PrintSelectedIfFlagSet()
{
    global $Value;

    # Must accomodate negative ReleaseFlag used for temp records
    if ($Value > 0)
        print " selected";
}

# print selected for flag label if flag not set
function PrintSelectedIfFlagNotSet()
{
    global $Value;

    # Must accomodate negative ReleaseFlag used for temp records
    if ($Value <= 0)
        print " selected";
}

# display controlled names or options for this record read only
function DisplayControlledNamesReadOnly()
{
    global $Schema;
    global $Field;
    global $Link;
    global $Value;
    global $ResourceId;    
    global $GenericId;
    global $NavDirCorrection;
    
    # retrieve list of entries for field
    $Resource = & new Resource($ResourceId);
    $Names = $Resource->GetByField($Field);
            
    # print field name
    DisplayNameTypeReadOnly();
                
    # for each entry
    foreach ($Names as $GenericId => $Value)
    {
        # build link to controlled name search
        $Link = $NavDirCorrection."SPT--AdvancedSearch.php?".
                    "FieldName=".urlencode($Field->Name()).
                    "&FieldValue=".urlencode("\"".$Value."\"");

         # print entry
         DisplayLinkedValueReadOnly();
    }
}

# display controlled names and buttons
function DisplayControlledNames()
{
    global $ResourceId;
    global $RowsPerName;
    global $LabelSuffix;
    global $Index;
    global $Field;
    global $Value;
    global $ControlledNameId;
    global $QualifierId;

    # retrieve list of entries for field
    $Resource = & new Resource($ResourceId);
    if (is_object($Resource))
    {
        $Names = $Resource->GetByField($Field);
    }

    # Get the schema
    $Schema = & new MetadataSchema();

    # get array of qualifiers
    $Qualifiers = $Resource->GetQualifierByField($Field, FALSE);
    
    # for each entry
    $Index = 0;
    $RowsPerName = count($Names);
    foreach ($Names as $ControlledNameId => $Value)
    {
        if ($Value != "")
        {
            if (is_array($Qualifiers))
                $QualifierId = $Qualifiers[$ControlledNameId];
            else
                $QualifierId = $Qualifiers;
             DisplayControlledNameValue();
        }    
        $Index++;
    }
}

# display classifications for this record
function DisplayTreesReadOnly()
{
    global $Schema;
    global $Link;
    global $Field;
    global $ResourceId;
    global $Value;
    global $GenericId;
    global $NavDirCorrection;

    $Resource = & new Resource($ResourceId);
    $Names = $Resource->Classifications();

    if (count($Names) > 0)
        DisplayClassStartReadOnly();
    foreach ($Names as $ClassificationType => $ClassificationTypes)    
    {
        if ($ClassificationType == $Field->Name())
        {
            foreach ($ClassificationTypes as $GenericId => $Classification)
            {
                $Value = stripslashes($Classification);

                if (!empty($Classification) && isset($Field) 
                    && $Field->Enabled() && $Field->Viewable())
                {
                    $Link = $NavDirCorrection."SPT--AdvancedSearch.php?".
                        "FieldName=".urlencode($Field->Name()).
                        "&FieldValue=".urlencode("\"".$Value."\"");
                    DisplayLinkedValueReadOnly();
                }
            }
            if (count($Names) > 0)
                DisplayClassEndReadOnly();
        }
    }
}

# display Trees associated with this resource 
function DisplayTrees()
{
    global $ResourceId;
    global $SubHeading;
    global $QualifierId;
    global $LabelSuffix;
    global $Index;
    global $Field;
    global $GenericId;
    global $RowsPerName;

    $Resource = & new Resource($ResourceId);
    if (is_object($Resource))
        $Classifications = $Resource->Classifications();

    if(FieldIsReadOnly())
        DisplayClassStartReadOnly();
    else
        DisplayNameBegin();

    # Get the schema
    $Schema = & new MetadataSchema();

    # get array of qualifiers
    $Qualifiers = $Resource->GetQualifierByField($Field, FALSE);

    $RowsPerName = 0;
    foreach ($Classifications as $ClassificationType => $ClassificationTypes)    
    {
        if ($ClassificationType == $Field->Name())
        {
            $Index = 0;
            $RowsPerName = count($ClassificationTypes);
            foreach ($ClassificationTypes as $GenericId => $Classification)
            {
                $SubHeading = stripslashes($Classification);
                $ClassificationType = stripslashes($ClassificationType);
                $Field = $Schema->GetFieldByName($Field->Name());
                if (is_array($Qualifiers))
                    $QualifierId = $Qualifiers[$GenericId];
                else
                    $QualifierId = $Qualifiers;

                if (!empty($Classification) && isset($Field)) 
                {
                    if(FieldIsReadOnly())
                        DisplayLinkedValueReadOnly();
                    else
                        DisplayClassificationValue();
                }
                $Index++;
            }
        }
    }    
    if(FieldIsReadOnly())
        DisplayClassEndReadOnly();
    else
        DisplayNameEnd();
} 

# display option fields
function DisplayOptionField()
{
    global $ResourceId;
    global $Field;
    global $Value;
    global $LabelSuffix;
    global $LastType;
    global $HTTP_GET_VARS;

    # Get the schema
    $Schema = & new MetadataSchema();

    $Resource = & new Resource($ResourceId);
    $Names = $Resource->GetByField($Field);

    if ($LastType != MDFTYPE_OPTION)
        StartRowTag();

    if ($Field->AllowMultiple())
        $Rows = 4;
    else
        $Rows = 1;

    DisplayOptionBegin();
    print "<br>";

    $Selected = NULL;
    if (isset($HTTP_GET_VARS["AddNewResource"]))
        $Selected = $Field->DefaultValue();
    else if (isset($ResourceId))
    {
        foreach ($Names as $GenericId => $Value)
        {
            $Selected[] = $GenericId; 
        }
    }
        
    DisplayControlledNameListForName($Field->DBFieldName(), 
        $Field->Name(), "--", $Selected, 4, 
        $Field->AllowMultiple(), FALSE);
    DisplayOptionEnd();    
}

# return if rows exist or not for controllednames, classifications
function RowsExist()
{
    global $RowsPerName;

    return $RowsPerName;
}

# print ControlledNameId
function PrintControlledNameId()
{
    global $ControlledNameId;

    print $ControlledNameId;
}

# get qualifier name
function GetQualifierNameNoLink()
{
    global $Field;
    global $QualifierId;

    # only print if it exists
    if ($Field->UsesQualifiers() && $QualifierId > 0)
    {
        $Qualifier = & new Qualifier($QualifierId);
        return " (".$Qualifier->Name().")";
    }
}

# get qualifier name (as a link in parens)
function GetQualifierName()
{
    global $Field;
    global $QualifierId;

    # only print if it exists
    if ($Field->UsesQualifiers() && $QualifierId > 0)
    {
        $Qualifier = & new Qualifier($QualifierId);
        return " <small>(<a href=\"".$Qualifier->Url()."\">".
            $Qualifier->Name()."</a>)</small>";
    }
}

# print qualifier name (in parens)
function PrintQualifierName()
{
    print GetQualifierName();
}

# print ClassificationId
function PrintClassificationId()
{
    global $GenericId;

    print $GenericId;
}

# print SubHeading 
function PrintSubHeading()
{
    global $SubHeading;

    print $SubHeading;
}

# print Index 
function PrintIndex()
{
    global $Index;

    print $Index;
}

# print Url
function PrintUrl()
{
    global $SPTImage;
    global $NavDirCorrection;
    global $Field;
    global $ResourceId;

    $FieldName = $Field->DBFieldName();
    print $NavDirCorrection.
        "/SPT--FullImage.php?ResourceId=${ResourceId}&FieldName=${FieldName}&edit=1";
}

# print ThumbnailUrl
function PrintThumbnailUrl()
{
    global $SPTImage;

    print $SPTImage->ThumbnailUrl();
}

# print ThumbnailUrl
function PrintAltText()
{
    global $SPTImage;

    if (isset($SPTImage))
    {
        print(GetHtmlTranslatedString($SPTImage->AltText()));
    }
}

# print ThumbnailUrl
function ImageExists()
{
    global $SPTImage;

    if (isset($SPTImage))
        return (is_readable($SPTImage->ThumbnailUrl())) ? true : false;
    else
        return false;
}

# display selected controlled names using java script
function DisplayControlledNameAndJavascript()
{
    global $Field;
    global $ResourceId;
    global $QualifierId;

    # retrieve list of entries for field
    $Resource = & new Resource($ResourceId);
    if (is_object($Resource))
    {
        $SelectedNames = $Resource->GetByField($Field);
    }
    
    $FieldName = $Field->DBFieldName();
    
    # only retrieve controlled names if type found
    if (is_object($Field))
    {
        $CNFactory = & new ControlledNameFactory();
        $CNIds = $CNFactory->GetItemIds("FieldId=".$Field->Id().
                            " ORDER BY ControlledName");
    }

    $ControlledNames["-1"] = "None Selected";

    # print the javascript necessary for this field
    print "    <script language=\"javascript\"> <!-- \n";
    print "        function Print${FieldName}Options( Form, Field )\n";
    print "        {\n";
    print "            with( Form )\n";
    print "            {\n";

    if (count($CNIds))
    {
        print "                Field.options[Field.options.length] = ";
        print "new Option( \"None Selected\", \"-1\");\n";
        foreach ($CNIds as $Id)
        {
            $CN = & new ControlledName($Id);
            $Name = addslashes($CN->Name());
            $QualifierId = $CN->QualifierId();
            $Qualifier = GetQualifierNameNoLink();
            $Name = $Name.$Qualifier;
            $ControlledNames[ $Id ] = $Name;
            if ( $Name )
            {
                print "                Field.options[Field.options.length] = ";
                print "new Option( \"$Name\", \"$Id\");\n";
            }
        }
    }

    print "            }\n";
    print "        }\n";
    print " --></script>\n";

    #Print option lists for selected names
    $CountMenus = 1;
    reset( $SelectedNames );
    while ( $CountMenus <= count($SelectedNames)+1 )
    {
        PrintOptionList( $FieldName.$CountMenus, $ControlledNames,
            key($SelectedNames), "", 1, 0, false,
            "CheckAdd( dbentry, '".$FieldName."', ".$CountMenus." );" );

        next( $SelectedNames );
        $CountMenus++;
    }
    

    # print shells for the remaining menus
    for ( $i = $CountMenus; $i < 21; $i++ )
    {
        print "<select name=\"${FieldName}${i}\" style=\"display: none;\"".
        " onchange=\"CheckAdd( dbentry, '${FieldName}', $i ".
        ");\"></select>&nbsp;\n";
    }
    print "<input type=\"hidden\" name=\"${FieldName}Hidden\"".         
          "value=\"".($CountMenus-1)."\">\n<br>";


}

# display selected classifications using java script
function DisplayClassificationAndJavascript()
{
    global $Field;
    global $ResourceId;
    global $QualifierId;

    # retrieve list of entries for field
    $Resource = & new Resource($ResourceId);
    if (is_object($Resource))
    {
        $SelectedNames = $Resource->GetByField($Field);
    }
    
    $FieldName = $Field->DBFieldName();
    
    # only retrieve controlled names if type found
    if (is_object($Field))
    {
        $ClassFactory = & new ClassificationFactory();
        $ClassIds = $ClassFactory->GetItemIds("FieldId=".$Field->Id().
                        " ORDER BY ClassificationName");
    }

    #Make "None Selected" entry to add to list
    $Classifications["-1"] = "None Selected";

    # print the javascript necessary for this field
    print "    <script language=\"javascript\"> <!-- \n";
    print "        function Print${FieldName}Options( Form, Field )\n";
    print "        {\n";
    print "            with( Form )\n";
    print "            {\n";

    if (count($ClassIds))
    {
        print "                Field.options[Field.options.length] = ";
        print "new Option( \"None Selected\", \"-1\");\n";
        foreach ($ClassIds as $Id)
        {
            $Class = & new Classification($Id);
            $Name = addslashes($Class->FullName());
            $QualifierId = $Class->QualifierId();
            $Qualifier = GetQualifierNameNoLink();
            $Name = $Name.$Qualifier;
            $Classifications[ $Id ] = $Name;
            if ( $Name )
            {
                print "                Field.options[Field.options.length] = ";
                print "new Option( \"$Name\", \"$Id\");\n";
            }
        }
    }

    print "            }\n";
    print "        }\n";
    print " --></script>\n";

    #Print an option list for every selected item
    $CountMenus = 1;
    reset( $SelectedNames );
    while ( $CountMenus <= count($SelectedNames)+1 )
    {

        PrintOptionList( $FieldName.$CountMenus, $Classifications,
            key($SelectedNames), "", 1, 0, false,
            "CheckAdd( dbentry, '".$FieldName."', ".$CountMenus." );" );
        
        next( $SelectedNames );
        $CountMenus++;
    }
    

    # print shells for the remaining menus
    for ( $i = $CountMenus; $i < 21; $i++ )
    {
        print "<select name=\"${FieldName}${i}\" style=\"display: none;\"".
        " onchange=\"CheckAdd( dbentry, '${FieldName}', $i ".
        ");\"></select>&nbsp;\n";
    }
    print "<input type=\"hidden\" name=\"${FieldName}Hidden\"".         
          "value=\"".($CountMenus-1)."\">\n<br>";

}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# process Delete or Duplicate Resource Record
function DeleteDuplicateResourceRecord()
{
    global $HTTP_POST_VARS, $Session, $ResourceId;

    $Session->PassVariable($HTTP_POST_VARS["F_Action"]);
    PrintAutoRefreshPage("Delete/Duplicate Record",
        "SPT--DeleteDuplicateRecord.php");
    exit;
}

# get resource record fields if updating an existing resource
function GetResourceRecord()
{
    global $ResourceId, $Resource, $Result;

    $Resource = & new Resource($ResourceId);
    $Result = $Resource->GetAsArray();
}

# determine if field should be displayed modifiable, or read-only
# eventually, this will be replaced by a more sophisticated function
# that determines on a per user/per field basis if a field should
# be modifiable or viewable
function FieldIsReadOnly()
{
    global $User;

    if($User->HasPriv(PRIV_RELEASEADMIN) && !$User->HasPriv(PRIV_RESOURCEADMIN))
        return true;
    else
        return false;
}

# determine if user has PRIV_RELEASEADMIN privilege only and not RESOURCEADMIN 
function UserIsReleaseAdminOnly()
{
    global $User;

    if($User->HasPriv(PRIV_RELEASEADMIN) && !$User->HasPriv(PRIV_RESOURCEADMIN))
        return true;
    else
        return false;
}

# ----- MAIN -----------------------------------------------------------------


CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN);
$RFactory = & new ResourceFactory();

# see if editing an existing resource
if (isset($HTTP_GET_VARS["ResourceId"]))
{
    $ResourceId = $HTTP_GET_VARS["ResourceId"];
    $RFactory->SetCurrentEditedItemId($ResourceId);
}
# came here from MD side nav "Add New Resource" 
else if (isset($HTTP_GET_VARS["AddNewResource"]))
{
    # clear out any previous old temp resource
    $ResourceId = $RFactory->GetCurrentEditedItemId();
    if (isset($ResourceId))
    {
        $Resource = & new Resource($ResourceId);
        if ($Resource->IsTempResource())
        {
            $Resource->Delete();
        }
        $RFactory->ClearCurrentEditedItemId();
    }
    # force creation of new resource below 
    $ResourceId = NULL;
}
# middle of processing an existing record
else
{
    $ResourceId = $RFactory->GetCurrentEditedItemId();
}

# nothing being edited, so create a new resource
if (is_null($ResourceId))
{
    $Resource = & new Resource();
    $ResourceId = $Resource->Id();
    $RFactory->SetCurrentEditedItemId($ResourceId);
}

if ($ResourceId)
{
    GetResourceRecord();

    # Check if the user can edit this resource
    if ( !CheckEditResource() )
    {
        include("include/SPT--UnauthorizedAccess.php");
        exit();
    }
}


include("include/SPT--StandardHtmlPageLoad.php");

?>
