<?php
#
#   FILE:  SPT--AdvancedSearch.php
#
#   FUNCTIONS PROVIDED:
#       PrintAdvancedSearchEntries()
#           - prints entries found as a result of an advanced search
#
#   FUNCTIONS EXPECTED:
#       PrintSearchResult($Title, $Description, $FullRecordLink, $Url, 
#                   $DateOfRecordCreation, $DateRecordAdded, $Contributor, 
#                   $EditOkay, $EditUrl, $DateLastVerified, $DateLastModified)
#           - used to print entry found as a result of an advanced search
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--SearchEngine.php");
require_once("include/SPT--ControlledName.php");

PageTitle("Advanced Search Results");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# return AllResourcesFlagged flag
function AllResourcesFlagged()
{
    global $Session, $AllResourcesFlagged;

#    return $Session->Get("AllResourcesFlagged");
    return $AllResourcesFlagged;
}

# get count of flagged files
function GetFlaggedFilesCount()
{
    global $HTTP_SERVER_VARS, $NavDirCorrection;
    
    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $InputPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/".$NavDirCorrection."TempStorage/InputData";

    $ResourceCount = 0;

    if (is_readable($InputPath))
    {
        $fpi = fopen($InputPath, "r");
        while (!feof($fpi))
        {
            $ResourceId = fgets($fpi, 4096);
            $ResourceId = trim($ResourceId);

            if (empty($ResourceId))
                break;
        
            $ResourceCount++;
        }
    }
    return $ResourceCount;
}

# print resource entry found as a result of an advanced search 
function PrintSearchResults()
{
    global $SearchResults, $User;

    # for each search result entry up to the limit to be displayed
    foreach ($SearchResults as $ResourceId => $Score)
    {
        $Resource =& new Resource($ResourceId);

        PrintSearchResult($Resource,
            "SPT--FullRecord.php?ResourceId=${ResourceId}",
            CheckEditResource( $Resource ),
            "MetadataTool/SPT--DBEntry.php?ResourceId=${ResourceId}",
            $Resource->ScaledCumulativeRating(), NULL, TRUE, TRUE, 
            $User->HasPriv(PRIV_SYSADMIN)); 
    }
}

function PrintSearchString()
{
    global $SearchCriteria;

    print(str_replace("\"", "&quot;", stripslashes($SearchCriteria)));
}

function PrintTotalNumberOfResults()
{
    global $Engine;

    print($Engine->NumberOfResults());
}

function PrintStartingResultNumber()
{
    global $StartingResult;
    global $Engine;

    if ($Engine->NumberOfResults() == 0)
    {
        print("0");
    }
    else
    {
        print($StartingResult + 1);
    }
}

function PrintEndingResultNumber()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $Engine;

    print(min(($StartingResult + $ResultsPerPage), $Engine->NumberOfResults()));
}

function PreviousResultsAvailable()
{
    global $StartingResult;

    return ($StartingResult > 0) ? TRUE : FALSE;
}

function NextResultsAvailable()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $Engine;

    return (($StartingResult + $ResultsPerPage) < $Engine->NumberOfResults()) ? TRUE : FALSE;
}

function PrintPreviousResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $F_ReleaseFlag;
    global $F_AddedBy;
    global $F_LastModifiedBy;
    global $Editing;

    $NewStartingResult = max(($StartingResult - $ResultsPerPage), 0);
    print("SPT--AdvancedSearch.php?ResultsPerPage=".$ResultsPerPage.
        "&StartingResult=". $NewStartingResult."&Editing=".$Editing);
}

function PrintNextResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $F_ReleaseFlag;
    global $F_AddedBy;
    global $F_LastModifiedBy;
    global $Editing;

    $NewStartingResult = $StartingResult + $ResultsPerPage;
    print("SPT--AdvancedSearch.php?ResultsPerPage=".$ResultsPerPage.
        "&StartingResult=".$NewStartingResult."&Editing=".$Editing);
}

function NoResultsFound()
{
    global $Engine;

    return ($Engine->NumberOfResults() == 0) ? TRUE : FALSE;
}

function PrintSearchTime()
{
    global $Engine;

    printf("%.3f", $Engine->SearchTime());
}

function PrintNumberOfPreviousResults()
{
    global $ResultsPerPage;

    print($ResultsPerPage);
}

function PrintNumberOfNextResults()
{
    global $ResultsPerPage;
    global $StartingResult;
    global $Engine;

    print(min($ResultsPerPage, ($Engine->NumberOfResults() - ($StartingResult + $ResultsPerPage))));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# Peform the Search
function PerformSearch($SearchGroups, $StartingResult, $ResultsPerPage)
{ 
    global $SysConfig;
    global $Engine;

    $SearchResults = NULL;
    
    # bail out if we've already done search
    static $AlreadyPerformedSearch;
    if ($AlreadyPerformedSearch) { return; }
    $AlreadyPerformedSearch = TRUE;

    # create search engine
    $Engine = new SPTSearchEngine;

#    $Engine->DebugLevel(4);

    # set OR/AND terms status
    $Engine->SearchTermsRequiredByDefault(
            $SysConfig->SearchTermsRequired());

    # add filter function if defined in HTML file
    if (function_exists("FilterSearchResults"))
    {
        $Engine->AddResultFilterFunction("FilterSearchResults");
    }

    # if advanced search
    if (isset($SearchGroups))
    {
        # check for no search criteria (other than Release Flag)
        if (!InMetadataTool() && count($SearchGroups) == 1)
        {
            unset($SearchGroups);
            $SearchGroups = array();
        }
            
	    # perform fielded search
        $SearchResults = $Engine->GroupedSearch(
                $SearchGroups, $StartingResult, $ResultsPerPage);
    }
    return $SearchResults;
}

# function to process a search field for the query
function ProcessSearchField($Search, $Field)
{
    global $SearchGroups, $SearchCriteria;

    if (!empty($Field) && isset($Search))
    {
        $SearchGroups["MAIN"]["SearchStrings"]["$Search"][] = $Field;
        $SearchCriteria .= "<br>".$Search." contains ".$Field;
    }
}

# function to process Option lists for the query
function ProcessOptionLists()
{
    global $HTTP_POST_VARS;
    global $SearchGroups;
    global $SearchCriteria;
    global $CumulativeRating;
    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_OPTION); 

    foreach ($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->Name();
        $DBName = $Field->DBFieldName();
        if (isset($HTTP_POST_VARS["$DBName"]))
            $Values = $HTTP_POST_VARS["$DBName"];
        else
            $Values = NULL;

        if (is_array($Values))
        {
            $SearchGroups["$FName"]["Logic"] = SEARCHLOGIC_OR;
            foreach ($Values as $Value)
            {
                # check for enabled fields
                if ($Field->Enabled() && $Value != "No Limit" && !empty($Value))
                {
                    $SearchGroups["$FName"]["SearchStrings"]["$FName"][] = 
                                        "=".$Value;
                    $SearchCriteria .= "<br>$FName equals ".$Value;
                }
            }
        }
    }
    # special case cumulative rating
    $Field = $Schema->GetFieldByName("Cumulative Rating");
    if ($Field->IncludeInAdvancedSearch())
    {
       if (is_array($CumulativeRating))
        {
            foreach ($CumulativeRating as $Value)
            {
                if ($Value != "No Limit" && !empty($Value))
                {
                    switch($Value)
                    {
                        case 0:
                            $Stars = "Not Rated";
                            $Operator = "= ";
                            break;
                        case 20:
                            $Stars = "*";
                            $Operator = ">= ";
                            break;
                        case 40:
                            $Stars = "**";
                            $Operator = ">= ";
                            break;
                        case 60:
                            $Stars = "***";
                            $Operator = ">= ";
                            break;
                        case 80:
                            $Stars = "****";
                            $Operator = ">= ";
                            break;
                        case 100:
                            $Stars = "*****";
                            $Operator = "= ";
                            break;
                        default:
                            $Stars = "No Limit";
                            break;
                    }
                    $SearchGroups[]["SearchStrings"]["Cumulative Rating"] =
                                    $Operator.$Value;
                    $SearchCriteria .= "<br>Cumulative Rating ".
                                    $Operator.$Stars;
                }
            }
        }
    }
}

# function to process flags for the query
function ProcessFlags()
{
    global $HTTP_POST_VARS;
    global $SearchGroups;
    global $SearchCriteria;
    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_FLAG); 

    foreach ($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->Name();
        $DBName = $Field->DBFieldName();
        if (isset($HTTP_POST_VARS["$DBName"]))
            $Value = $HTTP_POST_VARS["$DBName"];
        else
            $Value = FALSE;

        # get on and off labels
        if ($Value)
            $Label = $Field->FlagOnLabel();
        else
            $Label = $Field->FlagOffLabel();

        # check for enabled fields
        if ($Field->Enabled())
        {
            if (is_numeric($Value))
            {
                $SearchGroups[]["SearchStrings"]["$FName"] = $Value;
                $SearchCriteria .= "<br>$FName equals ".$Label;
            }
        }
    }
}

function ProcessReleaseFlagAndUsers()
{
    global $F_ReleaseFlag;
    global $F_AddedBy;
    global $F_LastModifiedBy;
    global $SearchGroups;
    global $SearchCriteria;

    # add release flag to search strings if not set to "all records"
    if ($F_ReleaseFlag != "All") 
    {  
        $SearchGroups[]["SearchStrings"]["Release Flag"] = $F_ReleaseFlag;  
    }

    # add "record added by" to search strings if not set to "ALL"
    if (strlen($F_AddedBy) && ($F_AddedBy != "All"))
    {  
        $SearchGroups["USER"]["SearchStrings"]["Added By Id"] = $F_AddedBy;  
        $SearchCriteria .= "<br>Added By equals ".$F_AddedBy;
    }

    # add "record added by" to search strings if not set to "ALL"
    if (strlen($F_LastModifiedBy) && ($F_LastModifiedBy != "All"))
    {  
        $SearchGroups["USER"]["SearchStrings"]["Last Modified By Id"] = 
                                $F_LastModifiedBy;  
        $SearchCriteria .= "<br>Last Modified By equals ".$F_LastModifiedBy;
    }
}

# build a "|" separated string from an array
function BuildArrayString($Array)
{
    $String = "\"";
    $Count = 0;
    foreach ($Array as $Value)
    {
        if ($Value == "No Limit")
            return "";

        # build string
        if (!empty($Value))
        {
            if ($Count)
                $String .= "|${Value}";
            else
                $String .= "${Value}";
        }
        $Count++;
     }
     $String .= "\", ";
     return $String;
}

# save search for user agents
function SaveUserAgentSearch()
{
    global $HTTP_POST_VARS, $CumulativeRating, $Editing;
    global $Submit, $DB, $User, $Session, $SearchId;
    global $F_SearchCat1, $F_SearchCat2, $F_SearchCat3, $F_SearchCat4;
    global $F_TextField1, $F_TextField2, $F_TextField3, $F_TextField4;
    global $F_MaxRecords, $F_AddedBy, $F_LastModifiedBy, $F_ReleaseFlag;
    global $SearchCriteria;

    $UserId = $User->Get("UserId");
    $UserName = $User->Get("UserName");

    $Options = NULL;
    $Flags = NULL;
    $CumRating = NULL;
    $OptionValues = NULL;
    $FlagValues = NULL;
    $CumRatingValues = NULL;
    $Frequency="Never";

    $Schema = & new MetadataSchema();

    # don't allow saving searches if user no longer logged in
    if ($User->IsLoggedIn() == FALSE)
    {
        $ErrorMessages[] = "ERROR: You must log in before saving searches.";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        if ($Editing == 1)
            $Target = "SPT--Advanced.php?Editing=1";
        else
            $Target = "SPT--Advanced.php";
        PrintAutoRefreshPage("Error Found", $Target);
        exit;
    }

    # see if UserSearch by this SearchId already exists
    if ($SearchId)
    {
        $OldSearch = TRUE;
        
        $Query = "SELECT * FROM UserSearch where UserId=$UserId and ".
            "SearchId = \"".$SearchId."\"";
        $DB->Query($Query);
        $Entry = $DB->FetchNextRowArray();

        if ( isset( $HTTP_POST_VARS["F_SearchName"] ) )
            $SearchName = $HTTP_POST_VARS["F_SearchName"];
        else
            $SearchName = $Entry["SearchName"];
            
        # yes, delete it and add in new user search, but hold on to Frequency
        if ($DB->NumRowsSelected() > 0)
        {
            $Frequency = $Entry["Frequency"];
            $Query = "DELETE FROM UserSearch where UserId=$UserId and ".
                "SearchId = \"".$SearchId."\"";
            $DB->Query($Query);
        }
    }
    # not loading an existing search, so create unique search name
    else
    {
        $OldSearch = FALSE;

        $Query = "Select max(SearchId) as MaxSearchId from UserSearch";
        $DB->Query($Query);
        $Entry = $DB->FetchNextRowArray();
        $SearchId = $Entry["MaxSearchId"] + 1;
        $SearchName = $UserName.$SearchId;
    }

    # the following is used to build up correct SearchCriteria string 
    ProcessSearchField($F_SearchCat1, $F_TextField1);
    ProcessSearchField($F_SearchCat2, $F_TextField2);
    ProcessSearchField($F_SearchCat3, $F_TextField3);
    ProcessSearchField($F_SearchCat4, $F_TextField4);
    ProcessOptionLists();
    ProcessFlags();
    ProcessReleaseFlagAndUsers();

    # process options
    $Fields = $Schema->GetFields(MDFTYPE_OPTION); 

    foreach ($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->Name();
        $DBName = $Field->DBFieldName();
        if (isset($HTTP_POST_VARS["$DBName"]))
            $Value = $HTTP_POST_VARS["$DBName"];
        else
            $Value = NULL;

        if ($Field->Enabled() && is_array($Value))
        {
            $String = BuildArrayString($Value);
            if (!empty($String))
            {
                $Options .= "$DBName, ";
                $OptionValues .= $String;
            }
        }
    }

    # process flags    
    $Fields = $Schema->GetFields(MDFTYPE_FLAG); 

    foreach ($Fields as $Field)
    {
        # declare global form variables
        $DBName = $Field->DBFieldName();
        if (isset($HTTP_POST_VARS["$DBName"]))
            $Value = $HTTP_POST_VARS["$DBName"];
        else
            $Value = NULL;

        # check for enabled fields
        if ($Field->Enabled())
        {
            if (is_numeric($Value))
            {
                $Flags .= "$DBName, ";
                $FlagValues .= "\"".$Value."\", ";
            }
        }
    }

    # process culmulative rating (only one)
    if (is_array($CumulativeRating))
    {
       $String = BuildArrayString($CumulativeRating);
       if (!empty($String))
       {
           $CumRating .= "CumulativeRating, ";
           $CumRatingValues .= $String;
       }
    }

    # ReleaseFlag is an int in saved searches, so store NULL for ALL
    if ($F_ReleaseFlag == "All")
        $F_ReleaseFlag = "NULL";


    # now insert new User Search Parameters
    $Query = "INSERT INTO UserSearch (UserId, SearchId, SearchName, ".
            "SearchCat1, SearchText1, ".
            "SearchCat2, SearchText2, ".
            "SearchCat3, SearchText3, ".
            "SearchCat4, SearchText4, ".
            "AddedBy, LastModifiedBy, ReleaseFlag, ".
            "SearchCriteria, ".
            $Options.$Flags.$CumRating.
            "MaxRecords, Frequency) ".
            "Values (\"$UserId\", NULL, \"".addslashes($SearchName)."\", ".
            "\"$F_SearchCat1\", \"".addslashes($F_TextField1)."\", ".
            "\"$F_SearchCat2\", \"".addslashes($F_TextField2)."\", ".
            "\"$F_SearchCat3\", \"".addslashes($F_TextField3)."\", ".
            "\"$F_SearchCat4\", \"".addslashes($F_TextField4)."\", ".
            "\"$F_AddedBy\", \"$F_LastModifiedBy\", $F_ReleaseFlag, ".
            "\"$SearchCriteria\", ".
            $OptionValues.$FlagValues.$CumRatingValues.
            "\"$F_MaxRecords\", \"$Frequency\")";

#    echo "Query=$Query<br>";
    $DB->Query($Query);

    # extract last insert id to get real SearchId
    $SearchId = $DB->Query(
                    "SELECT LAST_INSERT_ID() AS SearchId FROM UserSearch",
                    "SearchId");

    if ($OldSearch)
        PrintAutoRefreshPage("Saved Searches", "SPT--SavedSearch.php");
    else
    {
        $Session->PassVariable("SearchId", $SearchId);
        PrintAutoRefreshPage("New Saved Search", "SPT--NewSavedSearch.php");
    }
    exit;
}

# load search for user agents
function LoadUserAgentSearch()
{
    global $HTTP_POST_VARS, $CumulativeRating, $Editing;
    global $Submit, $DB, $User, $Session, $SearchName, $SearchId, $EditSearch;
    global $F_SearchCat1, $F_SearchCat2, $F_SearchCat3, $F_SearchCat4;
    global $F_TextField1, $F_TextField2, $F_TextField3, $F_TextField4;
    global $F_MaxRecords, $F_AddedBy, $F_LastModifiedBy, $F_ReleaseFlag;

    $UserId = $User->Get("UserId");

    $ErrorMessages = array();

    $Schema = & new MetadataSchema();

    if ($SearchId)
    {
        $Query = "SELECT * FROM UserSearch where UserId=$UserId and ".
                "SearchId = \"".$SearchId."\"";

        $DB->Query($Query);
        $Entry = $DB->FetchNextRowArray();

        # verify saved search values still available
        for($Index=1; $Index<5; $Index++)
        {
            $SearchCat = "SearchCat".$Index;
            $Field = $Schema->GetFieldByName($Entry["$SearchCat"]);

            if (is_object($Field))
            {
                if (!$Field->Viewable() && !$Editing)
                    $ErrorMessages[] = "ERROR: Saved search value ".
                    "\"".$Entry["$SearchCat"]."\" not viewable to public.";
                        
                if (!$Field->Enabled())
                    $ErrorMessages[] = "ERROR: Saved search value ".
                    "\"".$Entry["$SearchCat"]."\" not enabled.";

                if (count($ErrorMessages))
                    $Session->PassVariable("ErrorMessages", $ErrorMessages);
            }
        }

        $Session->PassVariable("Entry", $Entry);
        if ($EditSearch)
            $Session->PassVariable("SearchId", $SearchId);
        $Session->PassVariable("EditSearch", $EditSearch);
        if ($Editing == 1)
            $Target = "SPT--Advanced.php?Editing=1";
        else
            $Target = "SPT--Advanced.php";
        PrintAutoRefreshPage("Advanced Search", $Target);
        exit;
    }
    else
    {
        $ErrorMessages[] = "ERROR: No Saved Search To Load";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        if ($Editing == 1)
            $Target = "SPT--Advanced.php?Editing=1";
        else
            $Target = "SPT--Advanced.php";
        PrintAutoRefreshPage("Error Found", $Target);
        exit;
    }
}

# function to append ResourceIds to Export File
function CreateExportFile()
{
    global $Session, $HTTP_POST_VARS, $HTTP_SERVER_VARS, $Submit;
    global $SearchGroups, $StartingResult, $ResultsPerPage;
    global $AllResourcesFlagged;

    # preserve old settings
    $OldStartingResult = $StartingResult;
    $OldResultsPerPage = $ResultsPerPage;

    # redo search with no limits
    $StartingResult = 0;
    $ResultsPerPage = 999999999;
    $NewResults = PerformSearch(
                        $SearchGroups, $StartingResult, $ResultsPerPage);

    # check if only exporting checked resources
    if (substr($Submit, 5, 8) == "Selected")
    {
        $AllResourcesFlagged = $Session->Get("AllResourcesFlagged");
        reset($HTTP_POST_VARS);
        unset($NewResults);
        $NewResults = array();
        while (list($Var, $Value) = each ($HTTP_POST_VARS))
        {
            if (ereg("F_OkayForExport_([0-9]+)", $Var, $Regs))
            {
                if ($Value == TRUE)
                {
                    sscanf($Var, "F_OkayForExport_%d", $Id);
                    $NewResults[$Id] = $Id;
                }
            }
        }
    }
    # otherwise flag all resources
    else
    {
        $AllResourcesFlagged = TRUE;
    }

    $ResourceArray = array();

    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $ActualPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
            "/TempStorage/InputData";

    # read exiting file and cache already exported ResourceIds
    if (is_readable($ActualPath))
    {
        $fp = fopen($ActualPath, "r");
        while (!feof($fp))
        {
            $ResourceId = fgets($fp, 4096);
            $ResourceId = trim($ResourceId);
            $ResourceArray[] = $ResourceId;
        }
        fclose($fp);
    }

    $fp = fopen($ActualPath, "aw");

    # only write out if new results available
    foreach ($NewResults as $ResourceId => $Score)
    {
        # don't write out the same ResourceId twice
        if (!in_array($ResourceId, $ResourceArray))
            fwrite($fp, $ResourceId."\n");
    }
    fclose($fp);

    # restore previous results and display parameters
    $ResultsPerPage = $OldResultsPerPage;
    $StartingResult = $OldStartingResult;
    $Session->PassVariable("AllResourcesFlagged");
}

# function to remove export file
function RemoveExportFile()
{
    global $HTTP_SERVER_VARS, $Session, $AllResourcesFlagged; 

    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $ActualPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/TempStorage/InputData";

    unlink($ActualPath);

    $AllResourcesFlagged = FALSE;
#    $Session->PassVariable("AllResourcesFlagged", "0");
}

# ----- MAIN -----------------------------------------------------------------

if (isset($HTTP_POST_VARS["F_ReleaseFlag"]))
    $F_ReleaseFlag = $HTTP_POST_VARS["F_ReleaseFlag"];
if (isset($HTTP_POST_VARS["F_AddedBy"]))
    $F_AddedBy = $HTTP_POST_VARS["F_AddedBy"];
if (isset($HTTP_POST_VARS["F_LastModifiedBy"]))
    $F_LastModifiedBy = $HTTP_POST_VARS["F_LastModifiedBy"];
if (isset($HTTP_POST_VARS["F_MaxRecords"]))
    $F_MaxRecords = $HTTP_POST_VARS["F_MaxRecords"];
if (isset($HTTP_POST_VARS["F_SearchCat1"]))
    $F_SearchCat1 = $HTTP_POST_VARS["F_SearchCat1"];
if (isset($HTTP_POST_VARS["F_SearchCat2"]))
    $F_SearchCat2 = $HTTP_POST_VARS["F_SearchCat2"];
if (isset($HTTP_POST_VARS["F_SearchCat3"]))
    $F_SearchCat3 = $HTTP_POST_VARS["F_SearchCat3"];
if (isset($HTTP_POST_VARS["F_SearchCat4"]))
    $F_SearchCat4 = $HTTP_POST_VARS["F_SearchCat4"];
if (isset($HTTP_POST_VARS["F_TextField1"]))
    $F_TextField1 = stripslashes($HTTP_POST_VARS["F_TextField1"]);
if (isset($HTTP_POST_VARS["F_TextField2"]))
    $F_TextField2 = stripslashes($HTTP_POST_VARS["F_TextField2"]);
if (isset($HTTP_POST_VARS["F_TextField3"]))
    $F_TextField3 = stripslashes($HTTP_POST_VARS["F_TextField3"]);
if (isset($HTTP_POST_VARS["F_TextField4"]))
    $F_TextField4 = stripslashes($HTTP_POST_VARS["F_TextField4"]);

if (isset($HTTP_GET_VARS["FieldName"]))
    $FieldName = $HTTP_GET_VARS["FieldName"];
if (isset($HTTP_GET_VARS["FieldValue"]))
    $FieldValue = $HTTP_GET_VARS["FieldValue"];
    
if (isset($HTTP_POST_VARS["Submit"]))
    $Submit = $HTTP_POST_VARS["Submit"];
else
    $Submit = NULL;

if (isset($HTTP_GET_VARS["Editing"]))
    $Editing = $HTTP_GET_VARS["Editing"];
else
    $Editing = $Session->Get("Editing");
if (isset($HTTP_GET_VARS["ResultsPerPage"]))
    $ResultsPerPage = $HTTP_GET_VARS["ResultsPerPage"];
else
    $ResultsPerPage = $Session->Get("ResultsPerPage");

if (isset($HTTP_GET_VARS["StartingResult"]))
    $StartingResult = $HTTP_GET_VARS["StartingResult"];
else
    $StartingResult = $Session->Get("StartingResult");

if (isset($HTTP_GET_VARS["SearchId"]))
    $SearchId = $HTTP_GET_VARS["SearchId"];
else
    $SearchId = $Session->Get("SearchId");

if (isset($HTTP_GET_VARS["EditSearch"]))
    $EditSearch = $HTTP_GET_VARS["EditSearch"];
else
    $EditSearch = $Session->Get("EditSearch");

# if $F_ReleaseFlag is null, came from advanced search, so force to only
# released records
if (!isset($F_ReleaseFlag))
{
    $F_ReleaseFlag = 1;
}

# normal search initiated from Advanced Search or Edit Resources page
if ($Submit == "Search")
{
    # clear out registered variables
    $Session->UnRegisterVariable("SearchGroups");
    $Session->UnRegisterVariable("SearchCriteria");
    unset($SearchGroups);
    unset($SearchCriteria);
    
    # results per page comes from the form when Search selected
    $ResultsPerPage = $F_MaxRecords;

    # automatically set results per page for the user
    $User->Set("RecordsPerPage", $ResultsPerPage);
    
    # build up search criteria for display purposes
    ProcessSearchField($F_SearchCat1, $F_TextField1);
    ProcessSearchField($F_SearchCat2, $F_TextField2);
    ProcessSearchField($F_SearchCat3, $F_TextField3);
    ProcessSearchField($F_SearchCat4, $F_TextField4);

    # process options, flags, and special case fields
    ProcessOptionLists();
    ProcessFlags();
    ProcessReleaseFlagAndUsers();

    # register these variables for next and previous links
    $Session->RegisterVariable("SearchGroups", $SearchGroups);
    $Session->RegisterVariable("SearchCriteria", $SearchCriteria);
}
# search initiated from full record link of controlled name or tree field
else if (isset($FieldName) && isset($FieldValue))
{
    # clear out registered variables
    $Session->UnRegisterVariable("SearchGroups");
    $Session->UnRegisterVariable("SearchCriteria");
    unset($SearchGroups);
    unset($SearchCriteria);

    # set up search group criteria
    $SearchGroups[]["SearchStrings"][$FieldName] = stripslashes($FieldValue);
    $SearchGroups[]["SearchStrings"]["Release Flag"] = $F_ReleaseFlag;

    # numeric values indicate controlled names
    if (is_numeric($FieldValue))
    {
        $CN = & new ControlledName($FieldValue);
        $FieldValue = $CN->Name();
    }
    $SearchCriteria = $FieldName." equals ".$FieldValue;

    # force starting results and results per page
    $StartingResult = 0;
    $ResultsPerPage = 20;

    # register these variables for next and previous links
    $Session->RegisterVariable("SearchGroups", $SearchGroups);
    $Session->RegisterVariable("SearchCriteria", $SearchCriteria);
}

# strip out slashes from SearchCriteria
if (isset($SearchCriteria))
{
    $SearchCriteria = stripslashes($SearchCriteria);
    $SearchCriteria = str_replace('"', "&quot;", $SearchCriteria);  # ":

    # remove <br> at beginning of $SearchCriteria
    if (substr($SearchCriteria, 0, 4) == "<br>")
        $SearchCriteria = substr($SearchCriteria, 4);
}

# check for export which does it's own search
if (substr($Submit, 0, 4) == "Flag")
{
    CreateExportFile();
}
else if (isset($SearchGroups))    # Submit = "Search" or search by default
{
    $SearchResults = PerformSearch(
                        $SearchGroups, $StartingResult, $ResultsPerPage);
}
# user has not selected any search criteria (SearchGroups not set)
else
{
    $ErrorMessages[] = "Error: No search criteria selected.";
    $Session->PassVariable("ErrorMessages", $ErrorMessages);
    if ($Editing == 1)
        $Target = "SPT--Advanced.php?Editing=1";
    else
        $Target = "SPT--Advanced.php";
    PrintAutoRefreshPage("Error Found", $Target);
    exit;
}

# remove the export file
if (substr($Submit, 0, 5) == "Clear")
{
    RemoveExportFile();
}
# return to Saved Searches screen
else if ($Submit == "Cancel")
{
    PrintAutoRefreshPage("Saved Searches", "SPT--SavedSearch.php");
    exit;
}
# save a user search
else if (substr($Submit, 0, 4) == "Save")
{
    $Session->UnRegisterVariable("SearchCriteria");
    unset($SearchCriteria);
    SaveUserAgentSearch();
}
# load a user search
else if (isset($SearchId))
{
    LoadUserAgentSearch();
}


$Session->PassVariable("SearchResults", $SearchResults);
$Session->PassVariable("StartingResult", $StartingResult);
$Session->PassVariable("ResultsPerPage", $ResultsPerPage);
$Session->PassVariable("Editing", $Editing);

include("include/SPT--StandardHtmlPageLoad.php");

?>
