<?PHP

#
#   FILE:  SPT--PreferencesComplete.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");

# check if user is logged in
if ($User->IsLoggedIn() == FALSE) 
{  
    PrintAutoRefreshPage("Not Logged In", "SPT--Home.php");
}

# if new password was supplied
if (strlen($HTTP_POST_VARS["F_NewPassword"]) > 0)
{
    # attempt to change password
    $Status = $User->ChangePassword(
            $HTTP_POST_VARS["F_OldPassword"],
            $HTTP_POST_VARS["F_NewPassword"],
            $HTTP_POST_VARS["F_NewPasswordAgain"]);

    # if password change was unsuccessful
    if ($Status != U_OKAY)
    {
        # add to error list
        $ErrorMessages[] = $User->StatusMessage();
    }
}

# check for User Agent update
if ($HTTP_POST_VARS["Submit"] == "Save User Agents")
{
    $DB =& new SPTDatabase();
    $DB1 =& new SPTDatabase();
    $UserId = $User->Get("UserId");

    $query = "Select * from UserSearch where UserId = $UserId ".
                "Order by SearchName";
    $DB->Query($query);

    $Count=0;
    while ($Entry = $DB->FetchNextRowArray())
    {
        $Frequency = $HTTP_POST_VARS["F_Frequency_$Count"];
        $query = "Update UserSearch set Frequency = \"$Frequency\" ".
            "WHERE UserId = $UserId AND SearchName = \"$Entry[SearchName]\"";
        $DB1->Query($query);
        $Count++;
    }
    PrintAutoRefreshPage("User Agent Updated", "SPT--Home.php");
    exit;
}
else if ($HTTP_POST_VARS["Submit"] == "Change User Information")
{

    # if record was found
    if ($User->Status() == U_OKAY)
    {
        # save new user settings
        $User->Set("RealName", isset($HTTP_POST_VARS["F_RealName"]) ? $HTTP_POST_VARS["F_RealName"] : "");
        $User->Set("EMail", isset($HTTP_POST_VARS["F_EMail"]) ? $HTTP_POST_VARS["F_EMail"] : "");
        $User->Set("WebSite", isset($HTTP_POST_VARS["F_WebSite"]) ? $HTTP_POST_VARS["F_WebSite"] : "");
        $User->Set("AddressLineOne", isset($HTTP_POST_VARS["F_AddressLineOne"]) ? $HTTP_POST_VARS["F_AddressLineOne"] : "");
        $User->Set("AddressLineTwo", isset($HTTP_POST_VARS["F_AddressLineTwo"]) ? $HTTP_POST_VARS["F_AddressLineTwo"] : "");
        $User->Set("City", isset($HTTP_POST_VARS["F_City"]) ? $HTTP_POST_VARS["F_City"] : "");
        $User->Set("State", isset($HTTP_POST_VARS["F_State"]) ? $HTTP_POST_VARS["F_State"] : "");
        $User->Set("ZipCode", isset($HTTP_POST_VARS["F_ZipCode"]) ? $HTTP_POST_VARS["F_ZipCode"] : "");
        $User->Set("Country", isset($HTTP_POST_VARS["F_Country"]) ? $HTTP_POST_VARS["F_Country"] : "");

        PrintAutoRefreshPage("Home", "SPT--Home.php");

    }
    else
    {
        # put up error message
        ErrorOut("Your information could not be modified. Please contact the webmaster.");
    }
}


# set new active UI
if (isset($HTTP_POST_VARS["F_ActiveUI"]))
{
    $User->Set("ActiveUI", $HTTP_POST_VARS["F_ActiveUI"]);
}

# if errors were found
if (isset($ErrorMessages))
{
    # make error list persistent
    $Session->PassVariable("ErrorMessages");

    # return to editing page
    PrintAutoRefreshPage("Preference Errors Found", "SPT--Preferences.php");
}
else
{
    # return to home page
    PrintAutoRefreshPage("Preferences Updated", "SPT--Home.php");
}

?>
