<?PHP
#
#   FILE:  SPT--RSS.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("Axis--RSS.php");
require_once("Axis--Database.php");
require_once("include/SPT--Common.php");

# create RSS output object and set up channel values
$RSS = new RSS();

$DB =& new SPTDatabase();

$Today = getdate();
$Date = $Today['year']."-".$Today['mon']."-".$Today['mday'];

$Query = "Select * from RSSConfiguration";
$DB->Query($Query);

# only one entry
$Entry = $DB->FetchNextRowArray();

$NumberOfEntriesToPublish = $Entry["EntriesToPublish"];
$RSS->AddChannel($Entry["ChannelTitle"], $Entry["ImageLink"], $Entry["ChannelDescription"]);
$RSS->SetImage($Entry["ImageUrl"], $Entry["ImageTitle"], $Entry["ImageLink"],
        $Entry["ImageHeight"], $Entry["ImageWidth"], $Entry["ImageDescription"]);
$RSS->SetLanguage(isset($Entry["Language"]) ? $Entry["Language"] : NULL);
$RSS->SetCopyright(isset($Entry["CopyRight"]) ? $Entry["CopyRight"] : NULL);
$RSS->SetManagingEditor(isset($Entry["ManagingEditor"]) ? $Entry["ManagingEditor"] : NULL);
$RSS->SetWebmaster(isset($Entry["Webmaster"]) ? $Entry["Webmaster"] : NULL);
$RSS->SetPicsRating(isset($Entry["PicsRating"]) ? $Entry["PicsRating"] : NULL);
$RSS->SetPublicationDate($Date);

# get Last Change Date
$LastChangeDate = $DB->Query("SELECT MAX(DateLastModified) AS LastChangeDate"
        ." FROM Resources WHERE ReleaseFlag = 1", "LastChangeDate");
$LastChangeDate = substr($LastChangeDate, 0, 4)."-".
        substr($LastChangeDate, 4, 2)."-".substr($LastChangeDate, 6, 2);
$RSS->SetLastChangeDate($LastChangeDate);

# grab entries from DB
$DB->Query("SELECT * FROM Resources WHERE ReleaseFlag = 1 ".
        "ORDER BY DateOfRecordCreation DESC LIMIT ".$NumberOfEntriesToPublish);

# for each entry
while ($Row = $DB->FetchNextRowArray())
{
    # add entry to RSS page
    $RSS->AddItem($Row["Title"], 
        "http://".$HTTP_SERVER_VARS["SERVER_NAME"].dirname($HTTP_SERVER_VARS["REQUEST_URI"])
            ."/SPT--FullRecord.php?ResourceId=".$Row["ResourceId"], 
        strip_tags($Row["Description"])); 
}

# publish RSS page
$RSS->PrintRSS();

?>
