<?php
#
#   FILE:  SPT--SelectEditUserList.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("Axis--UserFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print Edit User Link 
function PrintEditUserLink()
{
    global $FoundUserArray;

    $UserName = $FoundUserArray["UserName"];
    print "SPT--EditUser.php?F_UserName=$UserName";
}

# functon to print the User Description 
function PrintUserName()
{
    global $FoundUserArray;

    $UserName = $FoundUserArray["UserName"];
    print GetHtmlEscapedString($UserName);
}

function PrintRealName()
{
    global $FoundUserArray;
    
    $RealName = $FoundUserArray["RealName"];
    print GetHtmlEscapedString($RealName);
}

function PrintEMail()
{
    global $FoundUserArray;
    
    $EMail = $FoundUserArray["EMail"];
    print GetHtmlEscapedString($EMail);
}

function PrintLastLoginDate()
{
    global $FoundUserArray;

    $LastLoginDate = $FoundUserArray["LastLoginDate"];
    print GetHtmlEscapedString($LastLoginDate);
}

function PrintAddress()
{
    global $FoundUserArray;

    $Address = $FoundUserArray["AddressLineOne"];
    print GetHtmlEscapedString($Address);
}

function PrintCity()
{
    global $FoundUserArray;

    $City = $FoundUserArray["City"];
    print GetHtmlEscapedString($City);
}

function PrintState()
{
    global $FoundUserArray;

    $State = $FoundUserArray["State"];
    print GetHtmlEscapedString($State);
}

function PrintZipCode()
{
    global $FoundUserArray;

    $ZipCode = $FoundUserArray["ZipCode"];
    print GetHtmlEscapedString($ZipCode);
}

function PrintCountry()
{
    global $FoundUserArray;

    $Country = $FoundUserArray["Country"];
    print GetHtmlEscapedString($Country);
}

# function to print the UserId 
function PrintUserId()
{
    global $FoundUserArray;

    print $FoundUserArray["UserId"];
}

# function to return if any enabled option list fields exist
function UsersExist()
{
    global $UserArray;

    return count($UserArray);
}

# function to print number of users found 
function PrintUsersFound()
{
    global $UserArray;

    print count($UserArray);
}

# display controlled name lists for editing
function DisplayUserList()
{
    global $Session;
    global $UserArray;
    global $Index;
    global $FoundUserArray;
    global $NumberOfResults;
    global $StartingResult;
    global $ResultsPerPage;
    global $DB;

    PrintBegin();

    $Index = 0;
    $DisplayIndex = 0;
    $NumberOfResults = count($UserArray);

    foreach ($UserArray as $UserId => $FoundUserArray)
    {
        if ($Index++ < $StartingResult)
            continue;
        DisplayUser();
        $DisplayIndex++;
        if ($DisplayIndex == $ResultsPerPage)
            break;
    }
    # pass through UserArray for next/prev links 
    $Session->PassVariable("UserArray", $UserArray);
}

function PreviousResultsAvailable()
{
    global $StartingResult;

    return ($StartingResult > 0) ? TRUE : FALSE;
}

function NextResultsAvailable()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $NumberOfResults;

    return (($StartingResult + $ResultsPerPage) < $NumberOfResults) ? TRUE : FALSE;
}

function PrintPreviousResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;

    $NewStartingResult = max(($StartingResult - $ResultsPerPage), 0);
    print("SPT--SelectEditUserList.php?ResultsPerPage=".$ResultsPerPage.
        "&StartingResult=". $NewStartingResult);
}

function PrintNextResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;

    $NewStartingResult = $StartingResult + $ResultsPerPage;
    print("SPT--SelectEditUserList.php?ResultsPerPage=".$ResultsPerPage.
        "&StartingResult=".$NewStartingResult);
}

function PrintNumberOfPreviousResults()
{
    global $ResultsPerPage;

    print($ResultsPerPage);
}

function PrintNumberOfNextResults()
{
    global $ResultsPerPage;
    global $StartingResult;
    global $NumberOfResults;

    print(min($ResultsPerPage, ($NumberOfResults - ($StartingResult + $ResultsPerPage))));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN);

$UFactory = & new UserFactory($Session);

if (isset($HTTP_GET_VARS["StartingResult"]))
    $StartingResult = $HTTP_GET_VARS["StartingResult"];
else
    $StartingResult = 0;

# hard code results per page for 20 so it is easily changed
if (isset($HTTP_GET_VARS["ResultsPerPage"]))
    $ResultsPerPage = $HTTP_GET_VARS["ResultsPerPage"];
else
    $ResultsPerPage = 20;

if (isset($HTTP_POST_VARS["Submit"]) && 
        $HTTP_POST_VARS["Submit"] == "Search for User(s)")
{
    if (!empty($HTTP_POST_VARS["F_SearchText"]))
    {
        $UserArray = $UFactory->GetMatchingUsers(
            $HTTP_POST_VARS["F_SearchText"],
            $HTTP_POST_VARS["F_SearchField"]);
    }
    else
    {
        PrintAutoRefreshPage("Select User Account to Edit", 
                            "SPT--SelectEditUser.php");
        exit;
    }
}
# return all users
else if (isset($HTTP_POST_VARS["Submit"]) &&
        $HTTP_POST_VARS["Submit"] == "Return All Users")
{
    $UserArray = $UFactory->GetMatchingUsers(".*.");
}
# came here from a next/previous link
else
{
    $UserArray = $Session->Get("UserArray");
}

PageTitle("Edit/Delete Selected User(s)");

include("include/SPT--StandardHtmlPageLoad.php");

?>
