<?php

#
#   FILE:  SPT--UserLogin.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");

# try to log user in
$LoginResult = $User->Login($HTTP_POST_VARS["F_UserName"],
                $HTTP_POST_VARS["F_Password"]);

# if login was successful
if ($LoginResult == U_OKAY)
{
    # is user account disabled?
    if ($User->HasPriv(PRIV_USERDISABLED))
    {
        # log user out
        $User->Logout();
        PrintAutoRefreshPage("Login Error", "SPT--LoginError.php");
        exit;
    }
    else
    {
        # head to home page
        PrintAutoRefreshPage("User Logged In", "SPT--Home.php");
    }
}
else
{
    # go to login error page
    PrintAutoRefreshPage("Login Error", "SPT--LoginError.php");
}

?>
