<?PHP
#
#   FILE:  SPT--Forum.php
#
#   FUNCTIONS PROVIDED:
#       Forum->Forum($ForumId)
#           - constructor
#       Forum->ForumId()
#       Forum->ForumName()
#       Forum->ForumDescription()
#       Forum->TopicCount()
#       Forum->MessageCount()
#       Forum->ModeratorId()
#           - methods to retrieve resource attributes
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once(dirname(__FILE__)."/../Axis--User.php");
require_once(dirname(__FILE__)."/SPT--Common.php");
require_once(dirname(__FILE__)."/SPT--Message.php");

class Forum {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function Forum($ForumId = NULL)
    {
        # locate class in database
        $this->DB =& new SPTDatabase();
        $DB =& $this->DB;
        # if ID supplied
        if ($ForumId !== NULL)
        {
            $this->ForumId = $ForumId;
            $DB->Query("SELECT * FROM Forums WHERE ForumId = ".$ForumId);

            # if row was loaded
            if ($DB->NumRowsSelected() > 0)
            {
                # set attributes to values returned by database
                $this->DBFields = $DB->FetchRow();
            }
        }
        else
        {
            # add record to database with that ID
            $DB->Query("INSERT INTO Forums (ForumId) VALUES (NULL)");
            $this->ForumId = $DB->Query("SELECT LAST_INSERT_ID() AS ForumId FROM Forums", "ForumId");
        }
 
    }

    # remove topic from database
    function Delete()
    {
        $this->DB->Query("Select * from Topics where ForumId = ".
                    $this->ForumId." ORDER BY DateCreated Desc");

        # get list of topics for this forum
        while ($Entry = $this->DB->FetchRow())
        {
            $Topic = & new Topic($Entry["TopicId"]);
            $Topic->Delete();
        }
        # delete record from database
        $this->DB->Query("DELETE FROM Forums WHERE ForumId = ".$this->ForumId);
    }
    
    # get attribute
    function ForumId()          {  return $this->ForumId;  }

    function LastMessageDate()
    {
        $Message = GetLastMessage($this->ForumId());
        if (isset($Message))
            return $Message->DatePosted()." by ";
        else
            return "None";
    }    

    function LastMessagePoster()
    {
        $Message = GetLastMessage($this->ForumId());
        if (isset($Message))
            return $Message->PosterName();
    }   

    function LastMessagePosterEmail()
    {
        $Message = GetLastMessage($this->ForumId());
        if (isset($Message))
            return $Message->PosterEmail();
    }   

    function ModeratorName()
    {
        $ModeratorName =& new User($this->DB, (int)$this->ModeratorId());
        return $ModeratorName->Get("UserName");
    }

    function ModeratorEmail()
    {
        $ModeratorName =& new User($this->DB, (int)$this->ModeratorId());
        return $ModeratorName->Get("Email");
    }

    function GetTopicList()
    {
        $Topics = array();

        $this->DB->Query("Select * from Topics where ForumId = ".
                    $this->ForumId." ORDER BY DateCreated Desc");

        # get list of topics for this forum
        while ($Entry = $this->DB->FetchRow())
        {
            $Topics[$Entry["TopicId"]] = & new Topic($Entry["TopicId"]);
        }
        return $Topics;
    }

    # get/set attributes
   function ForumName($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ForumName", $NewValue);  }
   function ForumDescription($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ForumDescription", $NewValue);  }
   function TopicCount($NewValue = DB_NOVALUE) {  return $this->UpdateValue("TopicCount", $NewValue);  }
   function MessageCount($NewValue = DB_NOVALUE) {  return $this->UpdateValue("MessageCount", $NewValue);  }
   function ModeratorId($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ModeratorId", $NewValue);  }
    
    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $ForumId;
    var $DB;
    var $DBFields;

    # convenience function to supply parameters to Database->UpdateValue()
    function UpdateValue($FieldName, $NewValue)
    {
        return $this->DB->UpdateValue("Forums", $FieldName, $NewValue,
                   "ForumId = '".$this->ForumId."'", $this->DBFields, TRUE);
    }
}

function GetLastMessage($ForumId)
{
    $DB =& new SPTDatabase();
    $Query = "SELECT * FROM Topics WHERE ForumId = ".$ForumId;
    $DB->Query($Query);
    $LastMessage = NULL;

    $MostRecent = "0001/01/01 00:00:00";
    while ($Entry = $DB->FetchNextRowArray())
    {
        $DB1 =& new SPTDatabase();
        $Query = "SELECT * from Messages where ParentId = ".
                $Entry["TopicId"].
                " AND ParentType = 1 ORDER BY DatePosted DESC Limit 1";
        $DB1->Query($Query);
        if ($DB1->NumRowsSelected() > 0)
        {
            $Record = $DB1->FetchNextRowArray();
            $Message =& new Message($Record["MessageId"]);
            if ($Message->DatePosted() > $MostRecent)
            {
                $LastMessage = $Message;
                $MostRecent = $Message->DatePosted();
            }
        }
    }
    return $LastMessage;
}

?>
