<?php
#
#   FILE:  SPT--AddControlledName.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

CheckAuthorization(PRIV_NAMEADMIN);

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print error message
function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if(!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}


# returns true if field uses qualifiers
function FieldUsesQualifiers()
{
    global $HTTP_POST_VARS;
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    return $Field->UsesQualifiers();
}

# function to return if any Controlled Name types exist
function ControlledNamesExist()
{
    global $Schema;

    $Fields = $Schema->GetFields(MDFTYPE_CONTROLLEDNAME);
    return count($Fields);
}

#  display a ControlledName list of values as an option menu
function DisplayControlledNameList()
{
    global $F_FieldId;
    global $Schema;

    $Fields = $Schema->GetFields(MDFTYPE_CONTROLLEDNAME);
    foreach($Fields as $Field)
    {
        $Items[$Field->Id()] =  $Field->Name();
    }
    PrintOptionList("F_FieldId", $Items, $F_FieldId, 1, 1, NULL, false);
}

# function to print selected ControlledName
function PrintDisplayString()
{
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    print $Field->Name();
}

# print ControlledName
function PrintControlledName()
{
    global $F_ControlledName;

    $Value = stripslashes($F_ControlledName);
    $Value = str_replace(array("&", ">", "<", "\"", "'"),
                        array("&amp;", "&gt;", "&lt;", "&quot;", "&#039;"),
                        $Value);
    print $Value;
}

# print Variant 
function PrintVariant()
{
    global $F_Variant;

    $Value = stripslashes($F_Variant);
    $Value = str_replace(array("&", ">", "<", "\"", "'"),
                        array("&amp;", "&gt;", "&lt;", "&quot;", "&#039;"),
                        $Value);
    print $Value;
}

# returns true if field uses item level qualifiers
function FieldHasItemLevelQualifiers()
{
    global $HTTP_POST_VARS;
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    return $Field->HasItemLevelQualifiers();
}

#  display a Qualifier list of values as an option menu
function PrintQualifierOrList()
{
    global $HTTP_POST_VARS;
    global $F_FieldId;
    global $Schema;

    $Field = $Schema->GetField($F_FieldId);
    if($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("F_Qualifier", $Items, 0, 0, 1, NULL, false);
    }
    else
    {
        $Qualifier = & new Qualifier($Field->DefaultQualifier());
        if(is_object($Qualifier))
            print $Qualifier->Name();
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$DB =& new SPTDatabase();
$Schema = & new MetadataSchema();

$F_Variant = $Session->Get("F_Variant");
$F_ControlledName = $Session->Get("F_ControlledName");
$F_FieldId = $Session->Get("F_FieldId");

if(is_null($F_FieldId))
{
    $Fields = $Schema->GetFields(MDFTYPE_CONTROLLEDNAME);
    $Field = array_pop($Fields);
    $F_FieldId = $Field->Id();
}

$Session->PassVariable("F_FieldId", $F_FieldId);

PageTitle("Add Controlled Names");
$NavDirCorrection = "../";

include("include/SPT--StandardHtmlPageLoad.php");


?>
