<?php
#
#   FILE:  SPT--EditControlledNameComplete.php
#
#   FUNCTIONS PROVIDED:
#       DisplayControlledNameInfo()
#           - updates or deletes ControlledName fields from ControlledNames
#             and VariantNames, and updates DateLastModified for affected
#             Resources
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ControlledName.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function DisplayControlledNameInfo()
{
    global $SubmitResult;
    global $F_ControlledName;
    global $HTTP_POST_VARS;

    $SubmitResult = $HTTP_POST_VARS["SubmitResult"];

    $DB =& new SPTDatabase();

    $Check = 0;
    reset($HTTP_POST_VARS);
    # we assume that ControlledNameId comes before ControlledName
    while (list($var, $val) = each ($HTTP_POST_VARS))
    {
#        echo "$var=$val<br>";
        # default QualifierId to NULL
        unset($QualifierId);
        if(ereg("^F_Check_([0-9]+)",$var,$regs))
        {
            $Check = 1;
            continue;
        }
        if(ereg("^F_ControlledNameId_([0-9]+)",$var,$regs))
        {
            $ControlledNameId = $val;
            continue;
        }
        if(ereg("^F_ControlledName_([0-9]+)",$var,$regs))
        {
            $ControlledName = $val;
            $ControlledName = trim($ControlledName);
            continue;
        }
        if(ereg("^F_VariantName_([0-9]+)",$var,$regs))
        {
            $VariantName = $val;
            $VariantName = trim($VariantName);
            continue;
        }
        if(ereg("^F_FieldId_([0-9]+)",$var,$regs))
        {
            $F_FieldId = $val;
            $Schema = & new MetadataSchema();
            $Field = $Schema->GetField($F_FieldId);
            if($Field->HasItemLevelQualifiers())
                continue;
        }
        if(ereg("^F_QualifierName_([0-9]+)",$var,$regs))
        {
            $QualifierId = $val;
            # if "--" selected, set qualifier id = NULL
            if($QualifierId == "--")
                $QualifierId = "NULL";
        }

#        echo "VN=$VariantName, CN=$ControlledName, CNID=$ControlledNameId<br>";
#        echo "FieldId=$F_FieldId, Check=$Check, QID=$QualifierId<br>";

        if(!empty($ControlledName) && 
            $SubmitResult == "Update Checked Records" && $Check)
        {
            $CN = & new ControlledName($ControlledNameId);
            $CN->Name($ControlledName);
            $CN->FieldId($F_FieldId);
            if(isset($QualifierId))
                $CN->QualifierId($QualifierId);
            $CN->Variant($VariantName);
        }
           
        # delete from ControlledNames and VariantNames
        else if($SubmitResult == "Delete Checked Records" && $Check)
        {
            $CN = & new ControlledName($ControlledNameId);
            $CN->Delete(TRUE);    

            $Query = "Delete from VariantNames where ".
                    "ControlledNameId = $ControlledNameId";
            $DB->Query($Query);
        }

        # now update all affected Resources        
        if($Check)
        {
            $Query =
                "Select distinct Resources.ResourceId, Title from ".
                "Resources INNER JOIN ResourceNameInts ON ".
                "ResourceNameInts.ResourceId=Resources.ResourceId ".
                "WHERE ControlledNameId = $ControlledNameId ".
                "ORDER BY Resources.ResourceId";

            $DB->Query($Query);
                
            $Rows=$DB->NumRowsSelected();
            for($i=0; $i<$Rows; $i++)
            {
                $Result = $DB->FetchNextRowArray();
                print "<a href=\"../SPT--FullRecord.php?ResourceId=".
                    "$Result[ResourceId]\" target=\"_blank\">".
                    "$Result[Title]</a><br>\n";
                $UpdateQuery[$i] = "Update Resources set ".
                    "DateLastModified = '".date("Y-m-d H:i:s").
                    "' where ResourceId = $Result[ResourceId]";
            }
            for($i=0;$i<$Rows;$i++)
            {
                $DB->Query($UpdateQuery[$i]);
            }
        }
        $Check = 0;
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_NAMEADMIN);

PageTitle("Edit Controlled Name Complete");
$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");


?>
