<?php
#
#   FILE:  SPT--AddQualifiers.php
#
#   FUNCTIONS PROVIDED:
#       DisplayQualifiers()
#           - Display list of qualifiers from a query 
#
#   FUNCTIONS EXPECTED:
#       DisplayQualifierSelection()
#           - display a controlled name for editing
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--QualifierFactory.php");
require_once("include/SPT--Qualifier.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print the QualifierName
function PrintQualifierName()
{
    global $QualifierName;

    print $QualifierName;
}

# functon to print the QualifierNamespace
function PrintQualifierNamespace()
{
    global $QualifierNamespace;

    print $QualifierNamespace;
}

# functon to print the QualifierUrl
function PrintQualifierUrl()
{
    global $QualifierUrl;

    print $QualifierUrl;
}

# function to print the QualifierId
function PrintQualifierId()
{
    global $QualifierId;

    print $QualifierId;
}

# return count of qualifiers
function QualifiersExist()
{
    global $QualifierFactory;

    return $QualifierFactory->QualifierCount();
}

# print out any error messages
function PrintErrorMessages()
{
    global $Session;

    $ErrorMessages = $Session->Get("ErrorMessages");

    # if error messages were passed 
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# display controlled name lists for editing
function DisplayQualifiers()
{
    global $QualifierFactory;
    global $QualifierName;
    global $QualifierNamespace;
    global $QualifierUrl;
    global $QualifierId;
    global $Index;

    if($QualifierFactory->QualifierCount())
    {
        $Index = 0;
        $QualifierList = $QualifierFactory->QualifierList();
        foreach($QualifierList as $QualifierId => $QualifierName)
        {
            $Qualifier = & new Qualifier($QualifierId);
            $QualifierNamespace = $Qualifier->Namespace();
            $QualifierUrl = $Qualifier->Url();
            DisplayQualifierSelection();
            $Index++;
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$QualifierFactory = & new QualifierFactory();

CheckAuthorization(PRIV_SYSADMIN);

PageTitle("Add/Edit Qualifierss");

include("include/SPT--StandardHtmlPageLoad.php");

?>
