<?php
#
#   FILE:  SPT--AddTopic.php
#
#   FUNCTIONS PROVIDED:
#       PrintForumId()
#       PrintForumName()
#       PrintErrorMessages()
#       DisplayTopics()
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Forum.php");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumName()
{
    global $ForumName;

    print stripslashes($ForumName);
}

# print out any error messages
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed 
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# display list of Topics from a query
function DisplayTopics($ForumId)
{
    global $Session;
    $db =& new SPTDatabase();

    $query = "Select * from Topics WHERE ForumId=$ForumId ".
                "ORDER BY DateCreated desc";
    $db->Query($query);

    $i=0;
    $Items = array();
    reset($Items);
    while($Result = $db->FetchNextRowArray())
    {
        $Items[$Result[TopicId]] = $Result[TopicName];
    }
    PrintOptionList("F_TopicId", $Items, NULL,
            NULL, 4, NULL, false);
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if(isset($HTTP_GET_VARS["forumid"]))
    $ForumId = $HTTP_GET_VARS["forumid"];
else
    $ForumId = $Session->Get("forumid");
$Forum =& new Forum($ForumId);
$ForumName = $Forum->ForumName();

PageTitle("Add Topic");
CheckAuthorization(PRIV_FORUMADMIN);
include("include/SPT--StandardHtmlPageLoad.php");

?>
