<?PHP
#
#   FILE:  SPT--Advanced.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# functions to display text field search strings
function PrintSearchText1()
{
    global $Entry;

    print GetHtmlEscapedString($Entry["SearchText1"]);
}

function PrintSearchText2()
{
    global $Entry;

    print GetHtmlEscapedString($Entry["SearchText2"]);
}

function PrintSearchText3()
{
    global $Entry;

    print GetHtmlEscapedString($Entry["SearchText3"]);
}

function PrintSearchText4()
{
    global $Entry;

    print GetHtmlEscapedString($Entry["SearchText4"]);
}

# functions to return selected option list values
function GetSearchCat1()
{
    global $Entry;

    return $Entry["SearchCat1"];
}

function GetSearchCat2()
{
    global $Entry;

    return $Entry["SearchCat2"];
}

function GetSearchCat3()
{
    global $Entry;

    return $Entry["SearchCat3"];
}

function GetSearchCat4()
{
    global $Entry;

    return $Entry["SearchCat4"];
}

# function to return action string for form tag
function GetAdvancedSearchAction()
{
    global $HTTP_GET_VARS, $Session;

    if(isset($HTTP_GET_VARS["Editing"]))
        $Editing = $HTTP_GET_VARS["Editing"];
    else
        $Editing = $Session->Get("Editing");
    return("SPT--AdvancedSearch.php?Editing=$Editing");
}
# function to print any error messages at top of the page
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed from PreferencesComplete
    if (isset($ErrorMessages) && is_array($ErrorMessages) &&
        count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul><b>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul></b>\n");
    }
}

# print selected if yes
function PrintSelectedIfYes()
{
    global $Entry, $Field;

    $Value = $Entry[$Field->DBFieldName()];

    if($Value == 1)
        print "selected";
}

# print selected if no
function PrintSelectedIfNo()
{
    global $Entry, $Field;

    $Value = $Entry[$Field->DBFieldName()];
    
    if(isset($Value) && $Value == 0)
        print "selected";
}

# display Field DB Name
function PrintDBFieldName()
{
    global $Field;

    print $Field->DBFieldName();
}

# display Field  Name
function PrintFieldName()
{
    global $Field;

    print $Field->Name();
}

# display FlagOnLabel
function PrintFlagOnLabel()
{
    global $Field;

    print $Field->FlagOnLabel();
}

# display FlagOffLabel
function PrintFlagOffLabel()
{
    global $Field;

    print $Field->FlagOffLabel();
}

# display option fields
function DisplayOptionFields()
{
    global $Entry, $Field;

    $Cols = 0;

    # Get the schema
    $Schema = & new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_OPTION);

    foreach($Fields as $Field)
    {
        $FieldDBName = $Field->DBFieldName(); 
        # display only fields that allow single selections first
        if($Field->Enabled() && !$Field->AllowMultiple() &&
            $Field->Viewable() && $Field->IncludeInAdvancedSearch())
        {
            # get value if updating record
            if(isset($Entry))
                $Value = $Entry["$FieldDBName"];
            else
                $Value = "No Limit";

            DisplayTDTag();
            DisplayOptionField();
            DisplayControlledNameListForName($Field->DBFieldName(),
                $Field->Name(), "No Limit", $Value, 6, TRUE, TRUE);
            DisplayTDCloseTag();    
            $Cols++;
        }
        # start a new row after 3 cols
        if($Cols == 3)
        {
            StartNewRow();
            $Cols = 0;
        }
    }
    foreach($Fields as $Field)
    {
        # display only fields that allow multiple selections next
        if($Field->Enabled() && $Field->AllowMultiple() &&
            $Field->Viewable() && $Field->IncludeInAdvancedSearch())
        {
            # get value if updating record
            if(isset($Entry[$Field->DBFieldName()]))
                $Value = explode("|", $Entry[$Field->DBFieldName()]);
            else
                $Value = "No Limit";

            DisplayTDTag();
            DisplayOptionField();
            DisplayControlledNameListForName($Field->DBFieldName(),
                $Field->Name(), "No Limit", $Value, 6, TRUE, TRUE);
            DisplayTDCloseTag();
            $Cols++;
        }

        # start a new row after 3 cols
        if($Cols == 3)
        {
            StartNewRow();
            $Cols = 0;
        }
    }
    # special case for cumulative rating
    $Field = $Schema->GetFieldByName("Cumulative Rating");
    if($Field->IncludeInAdvancedSearch())
    {
        $Items = array();
        $Items["No Limit"] = "No Limit";
        $Items["00"] = "Not Rated";
        $Items["20"] = "*";            
        $Items["40"] = "**";
        $Items["60"] = "***";
        $Items["80"] = "****";
        $Items["100"] = "*****";

        if(isset($Entry["CumulativeRating"]))
            $Selected = explode("|", $Entry["CumulativeRating"]);
        else
            $Selected = "No Limit";
        DisplayTDTag();
        DisplayCumulativeRating();
        PrintOptionList("CumulativeRating[]", $Items, $Selected, "", 6, 1, 0);
        DisplayTDCloseTag();
        $Cols++;    
    }
    
    if($Cols > 0 && $Cols < 3)
    {
        for($Cols; $Cols < 3; $Cols++)
            DisplayDummyCell();
    }
}

# display option fields
function DisplayFlagFields()
{
    global $Entry, $Field;

    $Cols = 0;
    if(isset($Entry["ResourceId"]))
        $ResourceId = $Entry["ResourceId"];
    else
        $ResourceId = NULL;

    # Get the schema
    $Schema = & new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_FLAG);

    foreach($Fields as $Field)
    {
        # display only fields that allow single selections first
        if($Field->Enabled() && $Field->Viewable() &&
            $Field->IncludeInAdvancedSearch())
        {
            DisplayFlagField();
            $Cols++;
        }
        # start a new row after 3 cols
        if($Cols == 3)
        {
            StartNewRow();
            $Cols = 0;
        }
    }
    if($Cols > 0 && $Cols < 3)
    {
        for($Cols; $Cols < 3; $Cols++)
            DisplayDummyCell();
    }
}

# display added by users
function DisplayUsers($FieldName)
{
    global $Entry;
    $db =& new SPTDatabase();

    $DBFieldName = $FieldName."Id";

    $query = "SELECT distinct ".$DBFieldName." FROM Resources";
    $db->Query($query);
    while($Record = $db->FetchNextRowArray())
    {
        $db1 =& new SPTDatabase();
        $User =& new User($db1, (int)$Record[$DBFieldName]);
        $UserName = $User->Get("UserName");
        if(!empty($UserName))
        {
            if($UserName == $Entry[$FieldName])
            {
                $UserSelected = $UserName;
                $UserNames[] = $UserName;
            }
            else
            {
                $UserNames[] = $UserName;
            }   
        }
    }
    # sort the user names
    sort($UserNames);
    foreach($UserNames as $UserName)
    {
        if(isset($UserSelected) && $UserSelected == $UserName)
            $UserValue = "\"".$UserName."\" selected";
        else
            $UserValue = "\"$UserName\"";
        DisplayOptionEntry($UserValue, $UserName);
    }
}

# print selected if Entry for AddedById is empty
function PrintSelectedIfAddedByEmpty()
{
    global $Entry;

    if(empty($Entry["AddedById"])) print " selected";
}

# print selected if Entry for LastModifiedById is empty
function PrintSelectedIfLastModifiedByEmpty()
{
    global $Entry;

    if(empty($Entry["LastModifiedById"])) print " selected";
}

# print selected if Entry for ReleaseFlag is empty
function PrintSelectedIfReleaseFlagEmpty()
{
    global $Entry;

    if(empty($Entry["ReleaseFlag"])) print " selected";
}

# display release flag
function DisplayReleaseFlag()
{
    global $Entry;

    $Selected0 = "0";
    $Selected1 = "1";
    if($Entry["ReleaseFlag"] == "0")
        $Selected0 .= " selected";
    else if($Entry["ReleaseFlag"] == "1")
        $Selected1 .= " selected";
    
    DisplayOptionEntry($Selected0, "Not Approved for Viewing");
    DisplayOptionEntry($Selected1, "Approved for Viewing");
}

#  display a ControlledName list of values as an option menu
function DisplayUserSearchList()
{
    $db =& new SPTDatabase();
    global $User, $Session, $Editing;
    $Items = array();

    $SearchName = $Session->Get("SearchName");
    $UserId = $User->Get("UserId");

    $query = "Select SearchName, SearchId from UserSearch where UserId=$UserId ".
                "ORDER BY SearchName";
    $db->Query($query);

    $Count = 0;
    print "<ul class=\"SPTSavedSearches\">\n";
    while($Entry = $db->FetchNextRowArray())
    {
        # init var if not set (first time on page)
        if(!isset($SearchName))
            $SearchName = $Entry["SearchName"];

        if($Editing)
            print "    <li><a href=\"SPT--AdvancedSearch.php?".
                  "Editing=1&SearchId=".$Entry["SearchId"]."\">".
                  $Entry["SearchName"]."</a></li>\n";
        else
            print "    <li><a href=\"SPT--AdvancedSearch.php?".
                  "Editing=0&SearchId=".$Entry["SearchId"]."\">".
                  $Entry["SearchName"]."</a></li>\n";

        $Count++;
    }
    print "</ul>\n";

    if(!$Count)
        print "<b>No saved searches</b>";        

    return($SearchName);
}

# print selected if F_Response is TitleUrlAnnot 
function PrintSelectedIfTitleUrlAnnot()
{
    global $Entry;

    if($Entry["Display"] == "TitleUrlAnnot")
        echo " selected";
}

# print selected if F_Response is TitleUrl 
function PrintSelectedIfTitleUrl()
{
    global $Entry;

    if($Entry["Display"] == "TitleUrl")
        echo " selected";
}

# print selected if F_Response is TitleUrl 
function PrintSelectedIfTitle()
{
    global $Entry;

    if($Entry["Display"] == "Title")
        echo " selected";
}

# print selected if F_MaxRecords = 5 
function PrintSelectedIf5()
{
    global $Entry, $User;

    if($Entry["MaxRecords"] == 5)
        echo " selected";
    else if($User->Get("RecordsPerPage") == 5)
        echo " selected";
}

# print selected if F_MaxRecords = 10 
function PrintSelectedIf10()
{
    global $Entry, $User;

    if($Entry["MaxRecords"] == 10)
        echo " selected";
    else if($User->Get("RecordsPerPage") == 10)
        echo " selected";
}

# print selected if F_MaxRecords = 20 
function PrintSelectedIf20()
{
    global $Entry, $User;

    if($Entry["MaxRecords"] == 20)
        echo " selected";
    else if($User->Get("RecordsPerPage") == 20)
        echo " selected";
}

# print selected if F_MaxRecords = 30 
function PrintSelectedIf30()
{
    global $Entry, $User;

    if($Entry["MaxRecords"] == 30)
        echo " selected";
    else if($User->Get("RecordsPerPage") == 30)
        echo " selected";
}

# print selected if F_MaxRecords = 50 
function PrintSelectedIf50()
{
    global $Entry, $User;

    if($Entry["MaxRecords"] == 50)
        echo " selected";
    else if($User->Get("RecordsPerPage") == 50)
        echo " selected";
}

# print selected if F_MaxRecords = 100 
function PrintSelectedIf100()
{
    global $Entry, $User;

    if($Entry["MaxRecords"] == 100)
        echo " selected";
    else if($User->Get("RecordsPerPage") == 100)
        echo " selected";
}

function EditingSavedSearch()
{
    global $EditSearch;

    return $EditSearch;
}

function PrintSavedSearchName()
{
    global $SearchId, $User, $DB;
    
    $UserId = $User->Get("UserId");
    $query = "SELECT SearchName FROM UserSearch WHERE UserId=".$UserId.
                " AND SearchId=".$SearchId; 

    $DB->Query($query);
    $Entry = $DB->FetchNextRowArray();
    
    if( isset($Entry["SearchName"]) )
        print $Entry["SearchName"];
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$Entry = $Session->Get("Entry");
$EditSearch = $Session->Get("EditSearch");
$SearchId = $Session->Get("SearchId");
$Session->PassVariable("SearchId", $SearchId);

if(InMetadataTool())
{
    CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN);
    PageTitle("Edit Resource");
}
else
    PageTitle("Advanced Search");

include("include/SPT--StandardHtmlPageLoad.php");

?>
