<?php
#
#   FILE:  SPT--DBAddField.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# if F_FieldType is -1, then came here from DBEditor screen
if(isset($HTTP_GET_VARS["F_FieldType"]) && $HTTP_GET_VARS["F_FieldType"] == -1)
    $ResetFieldType=TRUE;

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

if(isset($F_FieldId))
    PageTitle("Edit Database Field");
else
    PageTitle("Add Database Field");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function LoadVariables()
{
    global $HTTP_GET_VARS, $Session, $Schema;
    global $F_FieldId, $F_FieldName, $F_Description, $F_FieldType, $F_Enabled;
    global $F_Optional, $F_Viewable, $F_DefaultValue, $F_IncludeInKeywordSearch;
    global $F_IncludeInAdvancedSearch, $F_SearchWeight, $F_TextFieldSize;
    global $F_MaxLength, $F_MinValue, $F_MaxValue, $F_DateFormat;
    global $F_ParagraphRows, $F_ParagraphCols, $F_FlagOnLabel;
    global $F_FlagOffLabel, $F_AllowMultiple, $ResetFieldType;
    global $F_DefaultAltText, $F_MaxHeight, $F_MaxWidth;
    global $F_MaxPreviewHeight, $F_MaxPreviewWidth;
    global $F_MaxThumbnailHeight, $F_MaxThumbnailWidth;
    global $F_UsesQualifiers, $F_HasItemLevelQualifiers, $F_DefaultQualifier;

    # reset field type when coming from DBEditor
    if($ResetFieldType)
    {
        $F_FieldType = -1;
    }

    if(isset($HTTP_GET_VARS["F_FieldType"]))
        $F_FieldType = $HTTP_GET_VARS["F_FieldType"];
    else
        $F_FieldType = $Session->Get("F_FieldType");
    
    if(is_numeric($F_FieldId))
    {
        # Get the field
        $Field = $Schema->GetField($F_FieldId);
        
        # load fieldtype if user came from DBEditor page 
        if($F_FieldType == -1)
        {
            $F_FieldType = $Field->Type();
        }
        $F_FieldName = $Field->Name(); 
        $F_Description = $Field->Description(); 
        $F_Enabled = $Field->Enabled();
        $F_Optional = $Field->Optional();
        $F_Viewable = $Field->Viewable();
        $F_DefaultValue = $Field->DefaultValue();
        $F_UsesQualifiers = $Field->UsesQualifiers();
        $F_HasItemLevelQualifiers = $Field->HasItemLevelQualifiers();
        $F_DefaultQualifier = $Field->DefaultQualifier();
        $F_IncludeInKeywordSearch = $Field->IncludeInKeywordSearch();
        $F_IncludeInAdvancedSearch = $Field->IncludeInAdvancedSearch();
        $F_SearchWeight = $Field->SearchWeight();
        $F_TextFieldSize = $Field->TextFieldSize();
        $F_MaxLength = $Field->MaxLength();
        $F_MinValue = $Field->MinValue();
        $F_MaxValue = $Field->MaxValue();
        $F_DateFormat = $Field->DateFormat();
        $F_ParagraphRows = $Field->ParagraphRows();
        $F_ParagraphCols = $Field->ParagraphCols();
        $F_FlagOnLabel = $Field->FlagOnLabel();
        $F_FlagOffLabel = $Field->FlagOffLabel();
        $F_AllowMultiple = $Field->AllowMultiple();
        $F_DefaultAltText = $Field->DefaultAltText();
        $F_MaxHeight = $Field->MaxHeight();
        $F_MaxWidth = $Field->MaxWidth();
        $F_MaxPreviewHeight = $Field->MaxPreviewHeight();
        $F_MaxPreviewWidth = $Field->MaxPreviewWidth();
        $F_MaxThumbnailHeight = $Field->MaxThumbnailHeight();
        $F_MaxThumbnailWidth = $Field->MaxThumbnailWidth();
    }

    # first time in, all vars are NULL
    if(empty($F_FieldType))
        $F_FieldType = MDFTYPE_TEXT;
}

# return true if updating field and field is not required by SPT
function UpdatingField()
{
    global $F_FieldId, $Schema;

    # CHANGE THIS to use IsTempField()
    if($F_FieldId > 0)
    {
        # Get the field
        $Field = $Schema->GetField($F_FieldId);
        if($Field->RequiredBySPT())
            return FALSE;
        else
            return TRUE;
    }
    else
        return FALSE;
}

function PrintHeading()
{
    global $F_FieldId;

    # CHANGE THIS to use IsTempField()
    if($F_FieldId > 0)
    {
        print "Update Database Field";
    }
    else
        print "Add Database Field";
}

function PrintSubmitButton()
{
    global $F_FieldId;

    # CHANGE THIS to use IsTempField()
    if($F_FieldId > 0)
        print "Update Field";
    else
        print "Add New Field";
}

function PrintRawFieldName()
{
    global $F_FieldName;

    if(isset($F_FieldName))
        print $F_FieldName;
}

function PrintFieldName()
{
    global $F_FieldId, $F_FieldType, $F_FieldName, $Session, $Schema;

    if(isset($F_FieldId))
    {
        # Get the field
        $Field = $Schema->GetField($F_FieldId);
        if($Field->RequiredBySPT())
        {
            PrintStaticFieldName();
            $Session->PassVariable("F_FieldName");
        }
        else if(isset($F_FieldName))
            PrintTextFieldName();
    }
    else
        PrintTextFieldName();
}

function GetAllowedFieldTypes()
{
    global $F_FieldId, $F_FieldType, $Schema;

    # CHANGE THIS to use IsTempField() 
    if(isset($F_FieldId) && $F_FieldId > 0)
    {
        # retrieve allowed conversions types from field
        $Field = $Schema->GetField($F_FieldId);
        return $Field->GetAllowedConversionTypes();
    }
    else
        return $Schema->GetAllowedFieldTypes();

}

function PrintEnabledYesNo()
{
    global $F_Enabled;

    print ($F_Enabled ? "Yes" : "No");
}

function PrintEnabled()
{
    global $F_FieldId, $F_FieldType, $F_FieldEnabled, $Session, $Schema;

    if(isset($F_FieldId))
    {
        # Get the field
        $Field = $Schema->GetField($F_FieldId);
        if($Field->RequiredBySPT())
        {
            PrintStaticEnabled();
            $Session->PassVariable("F_Enabled");
        }
        else
            PrintFlagEnabled();
    }
    else
        PrintFlagEnabled();
}

function PrintOptionalYesNo()
{
    global $F_Optional;

    print ($F_Optional ? "Yes" : "No");
}

function PrintOptional()
{
    global $F_FieldId, $F_FieldType, $F_FieldOptional, $Session, $Schema;

    if(isset($F_FieldId))
    {
        # Get the field
        $Field = $Schema->GetField($F_FieldId);
        if($Field->RequiredBySPT())
        {
            PrintStaticOptional();
            $Session->PassVariable("F_Optional");
        }
        else
            PrintFlagOptional();
    }
    else
        PrintFlagOptional();
}

function PrintViewable()
{
    global $F_FieldId, $F_FieldType, $F_FieldViewable, $Session, $Schema;

    if(isset($F_FieldId))
    {
        # Get the field
        $Field = $Schema->GetField($F_FieldId);
        PrintFlagViewable();
    }
    else
        PrintFlagViewable();
}

function PrintFieldTypeAsName()
{
    global $F_FieldTypeAsName;

    print $F_FieldTypeAsName;
}

function PrintFieldType()
{
    global $F_FieldId, $F_FieldType, $F_FieldTypeAsName, $Session, $Schema;

    $Items = GetAllowedFieldTypes(); 
    if(isset($F_FieldId))
    {
        # Get the field
        $Field = $Schema->GetField($F_FieldId);
        if($Field->RequiredBySPT() || count($Items) == 0)
        {
            $F_FieldTypeAsName = $Field->TypeAsName();
            PrintStaticFieldType();
            $Session->PassVariable("F_FieldType");
        }
        else
        {
            PrintFieldTypeBegin();
            PrintOptionList("Submit", $Items, $F_FieldType, 1, 1, NULL, false);
            PrintFieldTypeEnd();
        }
    }
    else
    {
        PrintFieldTypeBegin();
        PrintOptionList("Submit", $Items, $F_FieldType, 1, 1, NULL, false);
        PrintFieldTypeEnd();
    }
}

function PrintDescription()
{
    global $F_Description;

    if(isset($F_Description))
        print $F_Description;
}

function PrintFieldId()
{
    global $F_FieldId;

    if(isset($F_FieldId))
        print $F_FieldId;
}

function SelectIfOptionalYes()
{
    global $F_Optional;

    if(!isset($F_Optional) || $F_Optional == 1)
        print "selected";
}

function SelectIfOptionalNo()
{
    global $F_Optional;

    if(isset($F_Optional) && $F_Optional == 0)
        print "selected";
}

function SelectIfUsesQualifiersYes()
{
    global $F_UsesQualifiers;

    if(!isset($F_UsesQualifiers) || $F_UsesQualifiers == 1)
        print "selected";
}

function SelectIfUsesQualifiersNo()
{
    global $F_UsesQualifiers;

    if(isset($F_UsesQualifiers) && $F_UsesQualifiers == 0)
        print "selected";
}

function SelectIfHasItemLevelQualifiersYes()
{
    global $F_HasItemLevelQualifiers;

    if(!isset($F_HasItemLevelQualifiers) || $F_HasItemLevelQualifiers == 1)
        print "selected";
}

function SelectIfHasItemLevelQualifiersNo()
{
    global $F_HasItemLevelQualifiers;

    if(isset($F_HasItemLevelQualifiers) && $F_HasItemLevelQualifiers == 0)
        print "selected";
}

function PrintDefaultQualifier()
{
    global $F_DefaultQualifier;
    global $F_FieldId;
    global $Schema;

    if(isset($F_FieldId))
    {
        $Field = $Schema->GetField($F_FieldId);
        $Items = $Field->AssociatedQualifierList();
    }
    $Items["--"] = "--";
    ksort($Items);

    PrintOptionList("F_DefaultQualifier", $Items, $F_DefaultQualifier,
        0, 1, NULL, false);
}

function PrintAllowedQualifiers()
{
    global $F_FieldId;
    global $Schema;

    if(isset($F_FieldId))
    {
        $Field = $Schema->GetField($F_FieldId);
        $Items = $Field->AssociatedQualifierList();
    }

    if(count($Items) == 0)
        $Items["--"] = "--";

    PrintOptionList("F_AllowedQualifiers", $Items, NULL, 0, 4, NULL, false);
}

function PrintAvailableQualifiers()
{
    global $F_FieldId;
    global $Schema;

    if(isset($F_FieldId))
    {
        $Field = $Schema->GetField($F_FieldId);
        $Items = $Field->UnassociatedQualifierList();
    }
    else
    {
        $QFactory = & new QualifierFactory();
        $Items = $QFactory->QualifierList();
    }

    if(count($Items) == 0)
        $Items["--"] = "--";

    PrintOptionList("F_AvailableQualifiers", $Items, NULL, 0, 4, NULL, false);
}

function SelectIfKeywordSearchYes()
{
    global $F_IncludeInKeywordSearch;

    if(!isset($F_IncludeInKeywordSearch) || $F_IncludeInKeywordSearch == 1)
        print "selected";
}

function SelectIfKeywordSearchNo()
{
    global $F_IncludeInKeywordSearch;

    if(isset($F_IncludeInKeywordSearch) && $F_IncludeInKeywordSearch == 0)
        print "selected";
}

function SelectIfAdvancedSearchYes()
{
    global $F_IncludeInAdvancedSearch;

    if(!isset($F_IncludeInAdvancedSearch) || $F_IncludeInAdvancedSearch == 1)
        print "selected";
}

function SelectIfAdvancedSearchNo()
{
    global $F_IncludeInAdvancedSearch;

    if(isset($F_IncludeInAdvancedSearch) && $F_IncludeInAdvancedSearch == 0)
        print "selected";
}


function SelectIfAllowMultipleYes()
{
    global $F_AllowMultiple;

    if(!isset($F_AllowMultiple) || $F_AllowMultiple == 1)
        print "selected";
}

function SelectIfAllowMultipleNo()
{
    global $F_AllowMultiple;

    if(isset($F_AllowMultiple) && $F_AllowMultiple == 0)
        print "selected";
}

function SelectIfDefaultValueYes()
{
    global $F_DefaultValue;

    if(!isset($F_DefaultValue) || $F_DefaultValue == 1)
        print "selected";
}

function SelectIfDefaultValueNo()
{
    global $F_DefaultValue;

    if(isset($F_DefaultValue) && $F_DefaultValue == 0)
        print "selected";
}

function SelectIfEnabledYes()
{
    global $F_Enabled;

    if(!isset($F_Enabled) || $F_Enabled == 1)
        print "selected";
}

function SelectIfEnabledNo()
{
    global $F_Enabled;

    if(isset($F_Enabled) && $F_Enabled == 0)
        print "selected";
}

function SelectIfViewableYes()
{
    global $F_Viewable;

    if(!isset($F_Viewable) || $F_Viewable == 1)
        print "selected";
}

function SelectIfViewableNo()
{
    global $F_Viewable;

    if(isset($F_Viewable) && $F_Viewable == 0)
        print "selected";
}

function PrintDefaultValue()
{
    global $F_DefaultValue;

    if(isset($F_DefaultValue))
        print $F_DefaultValue;
}

function PrintErrorMessage()
{
    global $ErrorMessage;

    if(isset($ErrorMessage))
    print $ErrorMessage;
}

function PrintTextFieldSize()
{
    global $F_TextFieldSize, $F_FieldType;

    if(isset($F_TextFieldSize))
        print $F_TextFieldSize;
    else
    {
        switch($F_FieldType)
        {
            case MDFTYPE_TEXT:
                print 50;
                break;

            case MDFTYPE_NUMBER:
                print 4;
                break;

            case MDFTYPE_DATE:
                print 10;
                break;

            default:
                break;
        }
    }
}

function PrintMaxLength()
{
    global $F_MaxLength;

    if(isset($F_MaxLength))
        print $F_MaxLength;
    else
        print 100;
}

function PrintMinValue()
{
    global $F_MinValue;

    if(isset($F_MinValue))
        print $F_MinValue;
    else
        print 1;
}

function PrintMaxValue()
{
    global $F_MaxValue;

    if(isset($F_MaxValue))
        print $F_MaxValue;
    else
        print 50;
}

function PrintSearchWeight()
{
    global $F_SearchWeight;

    if(isset($F_SearchWeight))
        print $F_SearchWeight;
    else
        print 1;
}

function PrintDefaultAltText()
{
    global $F_DefaultAltText;

    if(isset($F_DefaultAltText))
        print $F_DefaultAltText;
}

function PrintMaxHeight()
{
    global $F_MaxHeight;

    if(isset($F_MaxHeight))
        print $F_MaxHeight;
    else
        print 500;
}

function PrintMaxWidth()
{
    global $F_MaxWidth;

    if(isset($F_MaxWidth))
        print $F_MaxWidth;
    else
        print 500;
}

function PrintMaxPreviewHeight()
{
    global $F_MaxPreviewHeight;

    if(isset($F_MaxPreviewHeight))
        print $F_MaxPreviewHeight;
    else
        print 100;
}

function PrintMaxPreviewWidth()
{
    global $F_MaxPreviewWidth;

    if(isset($F_MaxPreviewWidth))
        print $F_MaxPreviewWidth;
    else
        print 100;
}

function PrintMaxThumbnailHeight()
{
    global $F_MaxThumbnailHeight;

    if(isset($F_MaxThumbnailHeight))
        print $F_MaxThumbnailHeight;
    else
        print 50;
}

function PrintMaxThumbnailWidth()
{
    global $F_MaxThumbnailWidth;

    if(isset($F_MaxThumbnailWidth))
        print $F_MaxThumbnailWidth;
    else
        print 50;
}

function PrintParagraphRows()
{
    global $F_ParagraphRows;
    
    if(isset($F_ParagraphRows))
        print $F_ParagraphRows;
    else
        print 4;
}

function PrintParagraphCols()
{
    global $F_ParagraphCols;
    
    if(isset($F_ParagraphCols))
        print $F_ParagraphCols;
    else
        print 50;
}

function PrintFlagOnLabel()
{
    global $F_FlagOnLabel;

    if(isset($F_FlagOnLabel))
        print $F_FlagOnLabel;
    else
        print "On";
}

function PrintFlagOffLabel()
{
    global $F_FlagOffLabel;

    if(isset($F_FlagOffLabel))
        print $F_FlagOffLabel;
    else
        print "Off";
}

function FieldTypeIsText()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_TEXT);
}

function FieldTypeIsNumber()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_NUMBER);
}

function FieldTypeIsDate()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_DATE);
}

function FieldTypeIsTree()
{
    global $F_FieldType, $F_FieldId;

    return ($F_FieldType == MDFTYPE_TREE && $F_FieldId > 0);
}

function FieldTypeIsUser()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_USER);
}

function FieldTypeIsTimestamp()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_TIMESTAMP);
}

function FieldTypeIsParagraph()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_PARAGRAPH);
}

function FieldTypeIsFlag()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_FLAG);
}

function FieldTypeIsOption()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_OPTION);
}

function FieldTypeIsImage()
{
    global $F_FieldType;

    return ($F_FieldType == MDFTYPE_IMAGE);
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN);

$Schema = & new MetadataSchema();

# see if editing an existing field
if(isset($HTTP_GET_VARS["F_FieldId"]))
{
    $F_FieldId = $HTTP_GET_VARS["F_FieldId"];
    $Schema->SetCurrentEditedItemId($F_FieldId);
}
# or get currently edited Field
else
{
    $F_FieldId = $Schema->GetCurrentEditedItemId();
}

if(isset($HTTP_POST_VARS["Submit"]))
    $Submit = $HTTP_POST_VARS["Submit"];
else
    $Submit = NULL;

# Add New Field selected, so create a new field
if(substr($Submit, 0, 3) == "Add")
{
    # remove any old temp field
    if(isset($F_FieldId))
    {
        $Field = $Schema->GetField($F_FieldId);
        if($Field->IsTempItem())
        {
            $Schema->DropField($F_FieldId);
        }
    }
    # clear current edited field id
    $Schema->ClearCurrentEditedItemId();

    # create a new temp field, default to text type
    $Field = $Schema->AddField(NULL, MDFTYPE_TEXT);
    $F_FieldId = $Field->Id();
    $Schema->SetCurrentEditedItemId($F_FieldId);
}
# return to Edit metadata fields page
else if(substr($Submit, 0, 4) == "Edit")
{
    PrintAutoRefreshPage("Database Editor", "SPT--DBEditor.php");
    exit;
}

LoadVariables();

$ErrorMessage = $Session->Get("ErrorMessage");

if(empty($F_FieldId) || isset($F_FieldType))
    $Session->PassVariable("F_FieldType", $F_FieldType);

$Session->PassVariable("F_FieldName", $F_FieldName);
$Session->PassVariable("F_Enabled", $F_Enabled);
$Session->PassVariable("F_Optional", $F_Optional);

include("include/SPT--StandardHtmlPageLoad.php");

?>
