<?php

#
#   FILE:  SPT--ImportUsersExecute.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintDuplicateUserList()
{
    global $DuplicateUsers;

    if(count($DuplicateUsers) > 0)
    {
        print "These users already exist and were not imported:<br>";
        foreach($DuplicateUsers as $UserName)
            print "$UserName<br>";
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# init variables -- first time thru they will be null
function InitImportVars()
{
    global $ImportComplete, $FSeek, $UserCount, $DuplicateUsers;

    if(is_null($ImportComplete))
        $ImportComplete = 0;
    if(is_null($FSeek))
        $FSeek = 0;
    if(is_null($UserCount))
        $UserCount = 0;
    $DuplicateUsers = array();
}

# do/while loop, this is the main event
function DoWhileLoop()
{
    global $DB, $fp, $Session, $FSeek, $Title, $ImportComplete;
    global $HTTP_POST_VARS, $User, $UserCount, $LineCount;
    global $DuplicateUsers, $PrivDescriptions;

    $Schema = & new MetadataSchema();
    $LineCount = 0;
    $LastUserName = NULL;

    while (!feof($fp) && $LineCount < 500 && $ImportComplete == 0)
    {
        # read in line from import file
        $fline = fgets($fp, 4096);

#        echo "fline=$fline<br>";
    
        # update variables 
        $LineCount++;
        $Session->PassVariable("LineCount", $LineCount);
        $FSeek += strlen($fline);
        $Session->PassVariable("FSeek", $FSeek);

        $Value = NULL;    
        # parse line from import file
        $Vars = explode("\t", $fline);

        $NumberOfVars = count($Vars);
        if($NumberOfVars < 1 || feof($fp))
        {
            $ImportComplete = 1;
            break;
        }
        
        # should be 14 variables per line
        if(count($Vars) != 14)
        {
            $ErrorMessage = "Error: Wrong number of fields on Line ".$LineCount;
            $Session->PassVariable("ErrorMessage", $ErrorMessage);
            PrintAutoRefreshPage("Import Users", "SPT--ImportUsers.php");
            exit;
        }

        # initial the vars
        $UserName = $Vars[0];
        $UserPassword = $Vars[1];
        $Email = $Vars[2];
        $WebSite = $Vars[3];
        $RealName = $Vars[4];
        $AddressLineOne = $Vars[5];
        $AddressLineTwo = $Vars[6];
        $City = $Vars[7];
        $State = $Vars[8];
        $Country = $Vars[9];
        $ZipCode = $Vars[10];
        $ActiveUI = $Vars[11];
        $BrowsingField = trim($Vars[12]);
        $PrivDescription = trim($Vars[13]);

        $Field = $Schema->GetFieldByName($BrowsingField);

        # force FieldId to reasonable value if not set
        if(is_object($Field))
            $FieldId = $Field->Id();
        else
            $FieldId = "NULL";

        # default UserPassword to UserName if blank
        if(empty($UserPassword))
            $UserPassword = $UserName;

        # encrypt the password
        if($HTTP_POST_VARS["F_PasswordFlag"] == 1)
            $UserPassword = crypt($UserPassword);

        # bail out if line was empty or end of file encountered
        if(is_null($UserName) || feof($fp))
        {
            break;
        }

        # just update privileges if this user is same as previous
        if($LastUserName == $UserName && !empty($PrivDescription))
        {
            $Privilege = array_search($PrivDescription, $PrivDescriptions);
            $ThisUser = & new User($DB, $UserName);
            $ThisUser->GivePriv($Privilege);
            continue;
        }

        # search for existing user and save it for later
        $query = "Select UserName from APUsers where UserName = \"$UserName\"";
        $DB->Query($query);
        if($DB->NumRowsSelected() > 0)
        {
            if(array_search($UserName, $DuplicateUsers) === FALSE)
                $DuplicateUsers[] = $UserName;
            continue;
        }

        $query = "Insert into APUsers (".
                        "UserName, ".
                        "UserPassword, ".
                        "CreationDate, ".
                        "Email, ".
                        "WebSite, ".
                        "RealName, ".
                        "AddressLineOne, ".
                        "AddressLineTwo, ".
                        "City, ".
                        "State, ".
                        "Country, ".
                        "ZipCode, ".
                        "ActiveUI, ".
                        "BrowsingFieldId)".
                " Values (\"$UserName\", ".
                         "\"$UserPassword\", ".
                         "\"".strftime("%Y-%m-%d")."\", ".
                         "\"$Email\", ".
                         "\"$WebSite\", ".
                         "\"$RealName\", ".
                         "\"$AddressLineOne\", ".
                         "\"$AddressLineTwo\", ".
                         "\"$City\", ".
                         "\"$State\", ".
                         "\"$Country\", ".
                         "\"$ZipCode\", ".
                         "\"$ActiveUI\", ".
                         "$FieldId)";
    
#       echo "Query=".$query."<br>";

        $DB->Query($query);

        # add in privilege if set
        if(!empty($PrivDescription))
        {
            $Privilege = array_search($PrivDescription, $PrivDescriptions);
            $ThisUser = & new User($DB, $UserName);
            $ThisUser->GivePriv($Privilege);
        }
        # cache user name for privileges
        $LastUserName = $UserName;
        
        # keep track of number of users added
        $UserCount++;
        $Session->PassVariable("UserCount", $UserCount);
    }
}

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$DB =& new SPTDatabase();
$ClassDB =& new SPTDatabase();

InitImportVars();

# check for Cancel button
if($HTTP_POST_VARS["Submit"] == "Cancel")
{
    $ImportComplete = 1;
    PrintAutoRefreshPage("System Administration", "SPT--SysAdmin.php");
    exit;
}

# register some key variables for other html code
$Session->PassVariable("ImportComplete", $ImportComplete);

if(is_uploaded_file($HTTP_POST_FILES['F_FileName']['tmp_name']))
{
    # zero length or tiny file
    if($HTTP_POST_FILES['F_FileName']['size'] == 0)
    {
        $ErrorMessage = "Error: File doesn't exist or is empty.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        PrintAutoRefreshPage("Import Users", "SPT--ImportUsers.php");
        exit;
    }

    $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

    $TempFile = dirname($ScriptFileName).
        "/TempStorage/".
        $_FILES['F_FileName']['name'];

    copy($HTTP_POST_FILES['F_FileName']['tmp_name'], $TempFile);

    $fp = fopen($TempFile, 'r');
    unlink($HTTP_POST_FILES['F_FileName']['tmp_name']);
}
else if($FSeek > 0)
{
    $fp = fopen($TempFile, 'r');
}
else
{
    switch($HTTP_POST_FILES['F_FileName']['error'])
    {
        # no error; possible file attack!
        case 0:
            $ErrorMessage = "There was a problem with your upload.";
            break;

        # uploaded file exceeds the upload_max_filesize directive in php.ini
        case 1:
            $ErrorMessage = "The file you are trying to upload is too big.";
            break;

        # uploaded file exceeds the MAX_FILE_SIZE directive that
        # was specified in the html form
        case 2:
            $ErrorMessage = "The file you are trying to upload is too big.";
            break;
            
        # uploaded file was only partially uploaded
        case 3:
            $ErrorMessage = 
                "The file you are trying upload was only partially uploaded.";
            break;

        # no file was uploaded
        case 4:
            $ErrorMessage = "You must select a file for upload.";
            break;

        # a default error, just in case!
        default:
            echo "There was a problem with your upload.";
            break;
    }
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Import Users", "SPT--ImportUsers.php");
    exit;
}

# the main work happenes here
DoWhileLoop();

# end of file reached?
if(feof($fp) || $ImportComplete)
{
    $ImportComplete = 1;
}
$Session->PassVariable("ImportComplete", $ImportComplete);
$Session->PassVariable("UserCount", $UserCount);
$Session->PassVariable("FSeek", $FSeek);
$Session->PassVariable("TempFile", $TempFile);

#  Time to auto-refresh?
if($ImportComplete == 0)
{
    $AutoRefreshToPage = "SPT--ImportUsersExecute.php";
}

PageTitle("Import Users");
include("include/SPT--StandardHtmlPageLoad.php");

if ($ImportComplete == 1)
{
    fclose($fp);
    # remove temporary uploaded file
    unlink($TempFile);
}

?>
