<?PHP

#
#   FILE:  SPT--RebuildSearchDB.php
#
#   FUNCTIONS PROVIDED:
#       RebuildIsComplete()
#           - returns TRUE if rebuild is complete
#       PercentRebuildComplete()
#           - returns percentage of rebuild completed so far
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--SearchEngine.php");
PageTitle("Rebuilding Search Database");

CheckAuthorization(PRIV_SYSADMIN);


function ProcessResourceChunk($StartingResourceId)
{
    global $DB;

    # number of resources to update in each pass
    $RebuildChunkSize = 15;

    # if starting resource ID is set
    if (isset($StartingResourceId))
    {
        # process (update search data for) current chunk of resources
        $SearchEngine =& new SPTSearchEngine;
        $EndResourceId = $SearchEngine->UpdateForResources(
                $StartingResourceId, $RebuildChunkSize);
    }
    else
    {
        # initialize starting resource ID
        $NewStartingResourceId = 0;
        $EndResourceId = -1;
    }

    # if we have processed all resources
    $LastResourceId = $DB->Query(
            "SELECT ResourceId FROM Resources ORDER BY ResourceId DESC LIMIT 1",
            "ResourceId");
    if ($EndResourceId >= $LastResourceId)
    {       
        # set flag to indicate we're done
        $NewStartingResourceId = -1;
    }
    else
    {
        # set new starting resource ID
        $NewStartingResourceId = $EndResourceId + 1;
    }

    # return new starting resource ID to caller
    return $NewStartingResourceId;
}

function SetAutoRefreshStatus($NewStartingResourceId)
{
    global $AutoRefreshToPage;
    global $SavePageGenerationBeginTime;
    global $HTTP_GET_VARS;

    if ($NewStartingResourceId != -1)
    {
        $Elapsed = isset($HTTP_GET_VARS["RSDElapsed"]) ? $HTTP_GET_VARS["RSDElapsed"] : 0;
        $ElapsedTime = intval($Elapsed
                + (getmicrotime() - $SavePageGenerationBeginTime));
        $AutoRefreshToPage = 
                "SPT--RebuildSearchDB.php"
                ."?RSDStartingResourceId=${NewStartingResourceId}"
                ."&RSDElapsed=${ElapsedTime}";
    }
}

function RebuildIsComplete()
{
    global $StartingResourceId;

    if ($StartingResourceId == -1) {  return TRUE;  } else {  return FALSE;  }
}

function PercentRebuildComplete()
{
    global $DB;
    global $StartingResourceId;

    # get total number of resources
    $TotalResources = $DB->Query(
            "SELECT COUNT(*) AS ResourceCount FROM Resources", "ResourceCount");

    # get number of resources left to process
    $ResourcesProcessed = $DB->Query(
            "SELECT COUNT(*) AS ResourceCount FROM Resources WHERE ResourceId<${StartingResourceId}", "ResourceCount");

    # calculate percentage complete and return to caller
    return sprintf("%.1f", ($ResourcesProcessed * 100) / $TotalResources);
}

function EstimatedTimeRemainingInSeconds()
{
    global $HTTP_GET_VARS;

    # calculate initial estimate
    if (isset($HTTP_GET_VARS["RSDElapsed"]))
    {
        $Elapsed = $HTTP_GET_VARS["RSDElapsed"];
    }
    else
    {
        $Elapsed = 0;
    }
    $EstimatedTotalTime = ($Elapsed * 100) / PercentRebuildComplete();

    # adjust for rebuild slowing toward end
    $EstimatedTotalTime = $EstimatedTotalTime * (1 + ((100 - PercentRebuildComplete()) / 300));

    # return result to caller
    return $EstimatedTotalTime - $Elapsed;
}

function EstimatedTimeRemaining()
{
    if (PercentRebuildComplete() < 2)
    {
        return "-:--";
    }
    else
    {
        return sprintf("%d:%02d:%02d", 
                intval(EstimatedTimeRemainingInSeconds() / 3600),
                intval((EstimatedTimeRemainingInSeconds() / 60) % 60),
                (EstimatedTimeRemainingInSeconds() % 60));
    }
}

function ElapsedTime()
{
    global $HTTP_GET_VARS;
    
    return sprintf("%d:%02d:%02d", 
            intval($HTTP_GET_VARS["RSDElapsed"] / 3600),
            intval(($HTTP_GET_VARS["RSDElapsed"] / 60) % 60),
            ($HTTP_GET_VARS["RSDElapsed"] % 60));
}

function TotalNumberOfResources()
{
    return $DB->Query("SELECT COUNT(*) AS ResourceCount FROM Resources", "ResourceCount");
}

function EstimatedTimeOfCompletion()
{
    if (PercentRebuildComplete() < 2)
    {
        return "-:--";
    }
    else
    {
        if (EstimatedTimeRemainingInSeconds() > (12 * 60 * 60))
        {
            return date("D g:ia", getmicrotime() + EstimatedTimeRemainingInSeconds());
        }
        else
        {
            return date("g:ia", getmicrotime() + EstimatedTimeRemainingInSeconds());
        }
    }
}


# save page generation timestamp
$SavePageGenerationBeginTime = getmicrotime();
if (isset($HTTP_GET_VARS["RSDStartingResourceId"]))
{
    $StartingId = $HTTP_GET_VARS["RSDStartingResourceId"];
}
else
{
    $StartingId = NULL;
}
$StartingResourceId = ProcessResourceChunk($StartingId);
SetAutoRefreshStatus($StartingResourceId);

include(FindUIFile("include/SPT--StandardPageStart.html"));
# restore page generation timestamp so accurate time will be calculated
$PageGenerationBeginTime = $SavePageGenerationBeginTime;
include(CorrespondingHtmlFile());
include(FindUIFile("include/SPT--StandardPageEnd.html"));

?>
