<?PHP

#
#   FILE:  SPT--UpdateTopic.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#
require_once("include/SPT--Common.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# preview new comment
function PreviewComment()
{
    global $Session;
    global $ParentId;
    global $F_Subject;
    global $F_Body;
    global $Message;
    global $ResourceId;

    # return to home page
    $Session->PassVariable("Message", $Message);
    $Session->PassVariable("F_Subject", $F_Subject);
    $Session->PassVariable("F_Body", $F_Body);
    $Session->PassVariable("ParentId", $ParentId);
    $Session->PassVariable("ResourceId", $ResourceId);
    PrintAutoRefreshPage("Preview Comment", "SPT--PreviewComment.php");
    exit;
}

# preview post 
function PreviewNewTopic()
{
    global $Session;
    global $ForumId;
    global $ParentId;
    global $F_TopicName;
    global $F_Subject;
    global $F_Body;
    global $Message;

    # return to home page
    $Session->PassVariable("Message", $Message);
    $Session->PassVariable("F_Subject", $F_Subject);
    $Session->PassVariable("F_Body", $F_Body);
    $Session->PassVariable("F_TopicName", $F_TopicName);
    $Session->PassVariable("forumid", $ForumId);
    $Session->PassVariable("ParentId", $ParentId);
    PrintAutoRefreshPage("Preview Post", "SPT--PreviewMessage.php");
    exit;
}

# delete topic and messages
function DeleteTopic()
{
    global $DB, $ParentId, $ForumId;
    $DB1 =& new SPTDatabase();

    if(!empty($ParentId))
    {
        $query = "Select * from Messages where ParentId = ".
                    $ParentId." AND ParentType = 1";

        $DB->Query($query);

        # delete messages associated with this topic
        $DeletedMessages = 0;
        while($Entry = $DB->FetchNextRowArray())
        {
            $DB1->Query("Delete from Messages where MessageId = ".
                        $Entry["MessageId"]);
            $DeletedMessages++;
        }

        # remove the topic
        $DB->Query("DELETE from Topics where ".
            "TopicId=$ParentId");

        # get current topic and message count for this forum
        $DB->Query("SELECT * from Forums where ForumId = ".$ForumId);
        $Entry = $DB->FetchNextRowArray();
        $TopicCount = $Entry["TopicCount"] - 1;
        $MessageCount = $Entry["MessageCount"] - $DeletedMessages;

        # update topic and message counts for forum
        $query = "UPDATE Forums SET TopicCount = ".$TopicCount.
                    ", MessageCount = ".$MessageCount.
                    " WHERE ForumId = ".$ForumId;

        $DB1->Query($query);
    }
}

# delete comment
function DeleteComment()
{
    global $DB, $Session, $ParentId, $MessageId, $ParentType;

    # overload DeleteMessage to deal with comments as well
    DeleteMessage();
    $Session->PassVariable("ResourceId", $ParentId);
    PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    exit;
}

# delete message 
function DeleteMessage()
{
    global $DB, $ForumId, $ParentId, $MessageId, $ParentType;

    if(!empty($MessageId))
    {
        $DB->Query("DELETE from Messages where ".
            "MessageId=$MessageId");

        if($ParentType == 1)
        {
            # update Message count for forum
            $Query = "Select MessageCount from Forums where ForumId = $ForumId";
            $DB->Query($Query);
            $Entry = $DB->FetchNextRowArray();
            $NewMessageCount = $Entry["MessageCount"] - 1;
            $Query = "Update Forums Set MessageCount = $NewMessageCount WHERE ".
                "ForumId = $ForumId";
            $DB->Query($Query);

            # update Message count for topic
            $Query = "Select MessageCount from Topics where TopicId = ".
                        $ParentId;
            $DB->Query($Query);
            $Entry = $DB->FetchNextRowArray();
            $NewMessageCount = $Entry["MessageCount"] - 1;
            $Query = "Update Topics Set MessageCount = $NewMessageCount WHERE ".
                    "TopicId = $ParentId";
            $DB->Query($Query);
        }
    }
}

# update comment
# comments are treated much like messages, except ParentId = 2
function UpdateComment()
{
    global $DB, $User, $Session, $F_Subject, $F_Body, $ParentId, $ParentType;

    # overload UpdateMessage to deal with comments as well
    UpdateMessage();
    $Session->PassVariable("ResourceId", $ParentId);
    PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    exit;
}

# update message 
function UpdateMessage()
{
    global $DB, $User, $MessageId, $F_Subject, $F_Body, $ForumId, $Parentid;
    global $F_TopicName, $Session;

    # remove unwanted html tags
    $F_Subject = strip_tags($F_Subject, '<a><b><i><u><small>');
    $F_Body = strip_tags($F_Body, '<a><b><i><u><br><small>');

    $F_Body .= "\n\n<br><br><small>This message edited by ".
                    $User->Get("UserName").
                    " on ".date("F j, Y \a\\t g:i a")."</small>";

    # add slashes for special chars
    $F_Subject = addslashes($F_Subject);
    $F_Body = addslashes($F_Body);

    # update the post
    if (strlen($F_Subject) && strlen($F_Body))
    {
        $Query = "UPDATE Messages set Subject = \"$F_Subject\", ".
                        "Body = \"$F_Body\", ".
                        "DatePosted = NOW() ".
                        "WHERE MessageId = $MessageId";

        $DB->Query($Query);
    }
}

# add list value
function AddNewTopic()
{
    global $DB, $User, $Session, $F_TopicName, $ForumId, $F_Subject, $F_Body;
    global $ParentId, $ParentType;

    $UserId = $User->Get("UserId");

    # remove unwanted html tags
    $F_TopicName = strip_tags($F_TopicName, '<a><b><i><u><small>');

    # add slashes for special chars
    $F_TopicName = addslashes($F_TopicName);

    # check for required fields
    if (strlen($F_TopicName) && strlen($F_Subject) && strlen($F_Body))
    {
        $Query = "Insert Topics (TopicId, TopicName, DateCreated, ".
                "ForumId, ViewCount, MessageCount, CreatorId) ".
                "values (NULL, \"$F_TopicName\", NOW(), ".
                "$ForumId, 0, 0, $UserId)"; 

#        echo "Query=$Query<br>";
        $DB->Query($Query);

        # get TopicId of last inserted row
        $Query = "SELECT LAST_INSERT_ID() AS InsertId FROM Topics";
        $DB->Query($Query);
        $Entry = $DB->FetchNextRowArray();
        $ParentId = $Entry["InsertId"];

        # update Topic count for forum
        $Query = "Select TopicCount from Forums where ForumId = $ForumId";
        $DB->Query($Query);
        $Entry = $DB->FetchNextRowArray();
        $NewTopicCount = $Entry["TopicCount"] + 1;
        $Query = "Update Forums Set TopicCount = $NewTopicCount WHERE ".
                "ForumId = $ForumId";
        $DB->Query($Query);

        # Now Post the message
        $ParentType = 1;
        PostMessage();
    }
    # missing values
    else
    {
        $ErrorMessages[] = "Error: One or more missing values. ".
            "Make sure all values are filled in.";
        $Session->PassVariable("ErrorMessages",$ErrorMessages);
        $Session->PassVariable("F_Subject", $F_Subject);
        $Session->PassVariable("F_Body", $F_Body);
        $Session->PassVariable("F_TopicName", $F_TopicName);
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("ParentId", $ParentId);
        PrintAutoRefreshPage("Error Message", "SPT--AddTopic.php");
        exit;
    }
}

# comments are treated much like messages, except ParentId = 2
function AddComment()
{
    global $DB, $User, $Session, $F_Subject, $F_Body, $ParentId, $ParentType;

    # overload PostMessage to deal with comments as well
    PostMessage();
    $Session->PassVariable("ResourceId", $ParentId);
    PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    exit;
}

function PostMessage()
{
    global $DB, $User, $Session, $F_Subject, $F_Body, $ParentId, $ForumId;
    global $ParentType, $F_TopicName;

    # PosterId is the user
    $PosterId = $User->Get("UserId");

    # remove unwanted html tags
    $F_Subject = strip_tags($F_Subject, '<a><b><i><u><small>');
    $F_Body = strip_tags($F_Body, '<a><b><i><u><br><small>');

    # add slashes for special chars
    $F_Subject = addslashes($F_Subject);
    $F_Body = addslashes($F_Body);

    # now insert the message
    if(strlen($F_Subject) && strlen($F_Body))
    {
        # insert new message for this Topic
        $Query = "Insert Messages (MessageId, ParentId, ParentType, ".
                "DatePosted, PosterId, Subject, Body) ".
                "values (NULL, $ParentId, $ParentType, ". 
                "NOW(), $PosterId, \"$F_Subject\", \"$F_Body\")"; 

#        echo "Query=$Query<br>";
        $DB->Query($Query);

        # update Message count for forum
        if($ParentType == 1 && isset($ForumId))
        {
            $Query = "Select MessageCount from Forums where ForumId = $ForumId";
            $DB->Query($Query);
            $Entry = $DB->FetchNextRowArray();
            $NewMessageCount = $Entry["MessageCount"] + 1;
            $Query = "Update Forums Set MessageCount = $NewMessageCount WHERE ".
                "ForumId = $ForumId";
            $DB->Query($Query);
        }

        # update Message count for topic
        if($ParentType == 1 && isset($ParentId))
        {
            $Query = "Select MessageCount from Topics where TopicId = ".
                        $ParentId;
            $DB->Query($Query);
            $Entry = $DB->FetchNextRowArray();
            $NewMessageCount = $Entry["MessageCount"] + 1;
            $Query = "Update Topics Set MessageCount = $NewMessageCount WHERE ".
                "TopicId = $ParentId";
            $DB->Query($Query);
        }
    }
    # report errors
    else
    {
        $ErrorMessages[] = "Error: One or more missing values. ".
            "Make sure all values are filled in.";
        $Session->PassVariable("ErrorMessages",$ErrorMessages);
        $Session->PassVariable("F_Subject", $F_Subject);
        $Session->PassVariable("F_Body", $F_Body);
        $Session->PassVariable("F_TopicName", $F_TopicName);
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("topicid", $ParentId);
        PrintAutoRefreshPage("Error Message", "SPT--PostMessage.php");
        exit;
    }
}

# ----- MAIN -----------------------------------------------------------------

# grab entry information from database
$DB =& new SPTDatabase();

if(isset($HTTP_POST_VARS["ResourceId"]))
    $ResourceId = $HTTP_POST_VARS["ResourceId"];
else
    $ResourceId = $Session->Get("ResourceId");

if(isset($HTTP_GET_VARS["forumid"]))
    $ForumId = $HTTP_GET_VARS["forumid"];
else if(isset($HTTP_POST_VARS["forumid"]))
    $ForumId = $HTTP_POST_VARS["forumid"];
else
    $ForumId = $Session->Get("forumid");

if(isset($HTTP_GET_VARS["topicid"]))
    $ParentId = $HTTP_GET_VARS["topicid"];
else if(isset($HTTP_POST_VARS["topicid"]))
    $ParentId = $HTTP_POST_VARS["topicid"];
else
    $ParentId = $Session->Get("topicid");

# check for ParentId from Resource
if(is_null($ParentId))
    $ParentId = $Session->Get("ParentId");

if(isset($HTTP_POST_VARS["F_Subject"]))
    $F_Subject = $HTTP_POST_VARS["F_Subject"];
else if(isset($HTTP_GET_VARS["F_Subject"]))
    $F_Subject = $HTTP_GET_VARS["F_Subject"];
else
    $F_Subject = $Session->Get("F_Subject");

if(isset($HTTP_POST_VARS["F_Body"]))
    $F_Body = $HTTP_POST_VARS["F_Body"];
else if(isset($HTTP_GET_VARS["F_Body"]))
    $F_Body = $HTTP_GET_VARS["F_Body"];
else
    $F_Body = $Session->Get("F_Body");

if(isset($HTTP_POST_VARS["F_TopicName"]))
    $F_TopicName = $HTTP_POST_VARS["F_TopicName"];
else
    $F_TopicName = $Session->Get("F_TopicName");

if(isset($HTTP_GET_VARS["messageid"]))
    $messageid = $HTTP_GET_VARS["messageid"];
else
    $messageid = $Session->Get("messageid");

if(isset($HTTP_GET_VARS["message"]))
    $message = $HTTP_GET_VARS["message"];
else    
    $message = $Session->Get("message");

if(isset($HTTP_POST_VARS["Submit"]))
    $Submit = $HTTP_POST_VARS["Submit"];
else
    $Submit = $HTTP_GET_VARS["Submit"];

if(isset($HTTP_POST_VARS["OkayToDelete"]))
    $OkayToDelete = $HTTP_POST_VARS["OkayToDelete"];
else
    $OkayToDelete = FALSE;

# echo "forumid=$forumid, topicid=$topicid, messageid=$messageid<br>";
# echo "Submit=$Submit, F_Body=$F_Body, ParentId=$ParentId<br>";

# don't allow any operation if user is not logged in
if($User->IsLoggedIn() == FALSE)
{
    $ErrorMessages[] = "Error: User must be logged in to perform ".
        "perform this function.";

    if(isset($ResourceId))
    {
        $Session->PassVariable("ResourceId", $ResourceId);
        PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    }
    else
    {
        $Session->PassVariable("ErrorMessages",$ErrorMessages);
        $Session->PassVariable("F_Subject", $F_Subject);
        $Session->PassVariable("F_Body", $F_Body);
        $Session->PassVariable("F_TopicName", $F_TopicName);
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("topicid", $ParentId);
        $Session->PassVariable("messageid", $MessageId);
        PrintAutoRefreshPage("Error Message", "SPT--PostMessage.php");
    }
    exit;
}
    
# this variable determines if we are coming from a message screen or not
if(isset($message))
    $Message = 1;

# comments are type 2, messages are type 1
if($Submit == "Add Comment")
{
    $ParentType = 2;
    AddComment();
}
# add new topic & message
else if(substr($Submit, 0, 3) == "Add")
{
    AddNewTopic();
}
# post new comment
else if($Submit == "Post New Comment")
{
    $ParentType = 2;
    AddComment();
}
# just post a new message
else if(substr($Submit, 0, 4) == "Post")
{
    $ParentType = 1;
    PostMessage();
    $Message = 1;
}
# update a comment
else if($Submit == "Update Comment")
{
    UpdateComment();
    $Message = 1;
}
# update an edited message
else if(substr($Submit, 0, 6) == "Update")
{
    UpdateMessage();
    $Message = 1;
}
# preview new topic and message, or preview comment
else if($Submit == "Preview")
{
    if(isset($ResourceId))
        PreviewComment();
    else
        PreviewNewTopic();
}
# remove Topic from forum
else if($Submit == "Delete Topic")
{
    if($OkayToDelete) 
    {
        DeleteTopic();
    }
    # give user a second chance
    else
    {
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("topicid", $ParentId);
        PrintAutoRefreshPage("Add Topic", "SPT--ConfirmDeleteTopic.php");
        exit;
    }
}
# preview new topic and message
else if($Submit == "Delete Comment")
{
    $ParentType = 2;
    DeleteComment();
}
# delete a message
else if($Submit == "Delete Message")
{
    $ParentType = 1;
    DeleteMessage();
}
# else Cancel, fall through
if(isset($ResourceId))
{
    $Session->PassVariable("ResourceId", $ResourceId);
    PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    exit;
}

# return to home page
$Session->PassVariable("forumid", $ForumId);
if(isset($ParentId))
    $Session->PassVariable("topicid", $ParentId);

if(isset($Message))
    PrintAutoRefreshPage("Add Message", "SPT--TopicMessages.php");
else
    PrintAutoRefreshPage("Add Topic", "SPT--ForumTopics.php");

?>
