<?PHP
#
#   FILE:  SPT--CommonSearch.php
#
#   FUNCTIONS PROVIDED:
#
#       NumberOfControlledNames()
#           - return number of controlled names for a given field
#
#       NumberOfClassifications()
#           - return number of classifications for a given field
#
#       DisplayControlledNameListForName()
#           - display a ControlledName list as a multi option menu
#
#       DisplayClassificationTypeList()
#           - display list of Classification Tree types
#
#       CreateOptionListForAdvancedSearch()
#           - create an option list for the Advanced Search fields
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
# 

# return count of controlled names for a given field
function NumberOfControlledNames($Field)
{
    $DB = & new SPTDatabase();

    if(is_object($Field))
    {
        $Query = "Select count(*) as Count from ControlledNames where FieldId=".
            $Field->Id();
        $Count = $DB->Query($Query, "Count");
    }
    return $Count;
}

# return count of classifications for a given field 
function NumberOfClassifications($Field)
{
    $DB = & new SPTDatabase();

    if(is_object($Field))
    {
        $Query = "Select count(*) as Count from Classifications where FieldId=".
            $Field->Id();
        $Count = $DB->Query($Query, "Count");
    }
    return $Count;
}

#  display a ControlledName list as a multi option menu 
function DisplayControlledNameListForName($VarName, $ControlledNameFieldName,
            $FirstEntry, $Selected, $Height, $Multi, $Search) 
{
    global $SysConfig;
    $DB = & new SPTDatabase();
    $Schema = & new MetadataSchema();

    $Field = $Schema->GetFieldByName($ControlledNameFieldName);

    # only retrieve controlled names if type found
    if(is_object($Field))
    {
        $Query = "Select * from ControlledNames where FieldId=".
            $Field->Id()." order by ControlledName";
        $DB->Query($Query);
    }
    $Items = array();
    reset($Items);
    if(!empty($FirstEntry) && !$Multi)
        $Items[$FirstEntry] = $FirstEntry;

    # load up array with values 
    if($DB->NumRowsSelected())
    {
        while($Entry = $DB->FetchNextRowArray())
        {
            $Value = $Entry["ControlledName"];
            $Value = htmlspecialchars(stripslashes($Value), ENT_QUOTES, 
                                "$SysConfig->DefaultCharacterSet()");
            if($Search)
                $Items[$Entry["ControlledName"]] = $Value;
            else
                $Items[$Entry["ControlledNameId"]] = $Value;
        }
    }
    # convert varname into array varname if not searching
    if($Multi)
        $VarName = $VarName."[]";

    PrintOptionList($VarName, $Items, $Selected, "", $Height, 1, $Multi);
}

#  display a Classification list of values as an option menu
function DisplayClassificationTypeList($Selected, $SubmitOnChange = FALSE)
{
    $Schema = & new MetadataSchema();

    $Fields = $Schema->GetFields(MDFTYPE_TREE);

    foreach($Fields as $Field)
    {
        $Items[$Field->Id()] = $Field->Name();
    }

    if($SubmitOnChange)
        $FieldName = "Submit";
    else
        $FieldName = "F_BrowsingFieldId";
    PrintOptionList($FieldName, $Items, $Selected, $SubmitOnChange,
        1, NULL, false);
}

# create an option list for the Advanced Search fields
function CreateOptionListForAdvancedSearch($VarName, $Selected, $VarValue) 
{
    $Values = array();
    
    # Get the schema
    $Schema = & new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_TEXT | MDFTYPE_PARAGRAPH);
    foreach($Fields as $Field)
        if($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
            $Values[$Field->Name()] = $Field->Name();
        
    # hard code Keyword as a search type
    $Values["Keyword"] = "Keyword";
    
    $Fields = $Schema->GetFields(MDFTYPE_CONTROLLEDNAME);
    $i = 0;
    foreach($Fields as $Field)
    {
        if($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
        {
            # use first controlled name as default if Selected is NULL  
            if($i == 0 && empty($Selected))
                $Selected = $Field->DBFieldName();
            $Values[$Field->Name()] = $Field->Name();
        }
        $i++;
    }

    $Fields = $Schema->GetFields(MDFTYPE_TREE);
    foreach($Fields as $Field)
        if($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
            $Values[$Field->Name()] = $Field->Name();

    $Fields = $Schema->GetFields(MDFTYPE_NUMBER);
    foreach($Fields as $Field)
        if($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
            $Values[$Field->Name()] = $Field->Name();
            
    $Fields = $Schema->GetFields(MDFTYPE_IMAGE);
    foreach($Fields as $Field)
        if($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
            $Values[$Field->Name()] = $Field->Name();

    $Fields = $Schema->GetFields(MDFTYPE_DATE | MDFTYPE_TIMESTAMP);
    foreach($Fields as $Field)
    {
        if($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
                $Values[$Field->Name()] = $Field->Name();
    }                
            
    echo "<select name=\"".$VarName."\" size=1>\n";
    $i=0;
    foreach($Values as $Value => $Name)
    {
        echo "<option value=\"".$Value."\"";
        if(isset($VarValue) && $VarValue == $Value)
            echo " selected";
        else if($Name == $Selected && !isset($VarValue))
            echo " selected";
        echo ">".$Name."</option>\n";
        $i++;
    }
    echo "</select>\n";
}

?>
