<?PHP

#
#   FILE:  SPT--ResourceFactory.php
#
#   METHODS PROVIDED:
#       ResourceFactory()
#           - constructor
#       DuplicateResource($ResourceId)
#           - create duplicate resource and return to caller
#       (SEE ALSO:  SPT--ItemFactory.php)
#
#   AUTHOR:  Edward Almasy  
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/SPT--ItemFactory.php");
require_once(dirname(__FILE__)."/SPT--Resource.php");


class ResourceFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function ResourceFactory()
    {
        # set up item factory base class
        $this->ItemClassName   = "Resource";
        $this->ItemTableName   = "Resources";
        $this->ItemIdFieldName = "ResourceId";
        $this->ItemFactory();
    }

    # create duplicate resource and return to caller
    function DuplicateResource($ResourceId)
    {
        # create new target resource
        $DstResource =& new Resource();
        
        # load up resource to duplicate
        $SrcResource =& new Resource($ResourceId);
        
        # if resource to duplicate was found
        if ($SrcResource->Status() > 0)
        {
            # for each metadata field
            $Schema =& new MetadataSchema();
            $Fields = $Schema->GetFields();
            foreach ($Fields as $Field)
            {
                # copy values from old resource to new resource
                $DstResource->SetByField($Field, $SrcResource->GetByField($Field, TRUE));
            }
        }
        
        # return new resource to caller
        return $DstResource;
    }

    # clear or change specific qualifier for all resources
    function ClearQualifier($ObjectOrId, $NewObjectOrId = NULL)
    {
        # get ID of qualifier to clear
        if (is_object($ObjectOrId))
        {
            $QualifierId = $ObjectOrId->Id();
        }
        else
        {
            $QualifierId = $ObjectOrId;
        }

        # if new qualifier passed in
        if ($NewObjectOrId !== NULL)
        {
            # get ID of qualifier to change to
            if (is_object($NewObjectOrId))
            {
                $NewQualifierIdVal = "'".$NewObjectOrId->Id()."'";
            }
            else
            {
                $NewQualifierIdVal = "'".$NewObjectOrId."'";
            }
        }
        else
        {
            # qualifier should be cleared
            $NewQualifierIdVal = "NULL";
        }

        # for each metadata field
        $DB =& new SPTDatabase();
        $Schema =& new MetadataSchema();
        $Fields = $Schema->GetFields();
        foreach ($Fields as $Field)
        {
            # if field uses qualifiers and uses item-level qualifiers
            $QualColName = $Field->DBFieldName()."Qualifier";
            if ($Field->UsesQualifiers() 
                && $Field->HasItemLevelQualifiers() 
                && $DB->FieldExists("Resources", $QualColName))
            {
                # set all occurrences to new qualifier value
                $DB->Query("UPDATE Resources"
                           ." SET ".$QualColName." = ".$NewQualifierIdVal.""
                           ." WHERE ".$QualColName." = '".$QualifierId."'");
            }
        }

        # clear or change qualifier association with controlled names
        # (NOTE: this should probably be done in a controlled name factory object)
        $DB->Query("UPDATE ControlledNames"
                   ." SET QualifierId = ".$NewQualifierIdVal
                   ." WHERE QualifierId = '".$QualifierId."'");

        # clear or change qualifier association with classifications
        # (NOTE: this should probably be done in a classification factory object)
        $DB->Query("UPDATE Classifications"
                   ." SET QualifierId = ".$NewQualifierIdVal
                   ." WHERE QualifierId = '".$QualifierId."'");
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
