<?PHP

#
#   FILE:  SPT--SPTDate.php
#
#   METHODS PROVIDED:
#       SPTDate()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#


class SPTDate {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function SPTDate($BeginDate, $EndDate = NULL, $Precision = NULL)
    {
        # set default debug state
        $this->DebugLevel = 0;
        
        if ($this->DebugLevel) {  print("SPTDate:  SPTDate(BeginDate=\"".$BeginDate."\" EndDate=\"".$EndDate."\")<br>\n");  }
        
        $MonthNames = array(
            "january"   => 1,
            "february"  => 2,
            "march"     => 3,
            "april"     => 4,
            "may"       => 5,
            "june"      => 6,
            "july"      => 7,
            "august"    => 8,
            "september" => 9,
            "october"   => 10,
            "november"  => 11,
            "december"  => 12,
            "jan" => 1,
            "feb" => 2,
            "mar" => 3,
            "apr" => 4,
            "may" => 5,
            "jun" => 6,
            "jul" => 7,
            "aug" => 8,
            "sep" => 9,
            "oct" => 10,
            "nov" => 11,
            "dec" => 12
            );

        # Formats we need to parse:
        #   1999-9-19
        #   1999-9
        #   9-19-1999
        #   19-9-1999
        #   Sep 9 1999
        #   September 9th, 1999
        #   1996,1999
        #   c1999
        #   1996-1999
        #   9/19/01
        #   9-19-01
        
        # null out values
        $BeginYear = NULL;
        $BeginMonth = NULL;
        $BeginDay = NULL;
        $EndYear = NULL;
        $EndMonth = NULL;
        $EndDay = NULL;
        
        # append end date to begin date if available
        $Date = $BeginDate;
        if ($EndDate != NULL)
        {
            $Date .= " - ".$EndDate;
        }
        
        # strip off any leading or trailing whitespace
        $Date = trim($Date);
        
        # check for and strip out inferred indicators ("[" and "]")
        if (preg_match("/\\[/", $Date))
        {
            $Prec |= DATEPRE_INFERRED;
            $Date = preg_replace("/[\\[\\]]/", "", $Date);
        }
        
        # check for and strip off copyright indicator (leading "c")
        if (preg_match("/^c/", $Date))
        {
            $Prec |= DATEPRE_COPYRIGHT;
            $Date = preg_replace("/^c/", "", $Date);
        }
        
        # check for and strip off continuous indicator (trailing "-")
        if (preg_match("/\\-$/", $Date))
        {
            $Prec |= DATEPRE_CONTINUOUS;
            $Date = preg_replace("/\\-$/", "", $Date);
        }

        # strip out any times
        $Date = preg_replace("/[0-9]{1,2}:[0-9]{2,2}[:]?[0-9]{0,2}/", "", $Date);
        $Date = trim($Date);

        # parse into component pieces
        $Date = preg_replace("/([-\\/,]{1,1})/", " \\0 ", $Date);
        $Pieces = preg_split("/\\s+/", $Date);

        # while not out of pieces
        for ($Index = 0;  $Index < count($Pieces);  $Index++)
        {
            if ($this->DebugLevel > 1) {  print("SPTDate:  Pieces[$Index]=\"".$Pieces[$Index]."\"<br>\n");  }
            
            # normalize piece
            $Piece = strtolower($Pieces[$Index]);

            # if piece looks like a year
            if ((($Piece > 1000) && ($Piece < 2200))
                    || (($Piece > 31) && ($Piece < 100)))
            {
                # if we don't have begin year
                if (!isset($BeginYear))
                {
                    # set begin year
                    $BeginYear = $Piece + (($Piece < 100) ? 1900 : 0);
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got begin year A ($BeginYear)<br>\n");  }

                    # if next piece may indicate separate values
                    if (isset($Pieces[$Index + 1]) &&
                        trim($Pieces[$Index + 1]) == ",")
                    {
                        # set separate value flag
                        $Prec |= DATEPRE_SEPARATE;

                        # skip next piece
                        $Index++;
                    }
                }
                else
                {
                    # if we don't have end year
                    if (!isset($EndYear))
                    {
                        # set end year
                        $EndYear = $Piece + (($Piece < 100) ? 1900 : 0);
                        if ($this->DebugLevel > 1) {  print("SPTDate:  got end year A ($EndYear)<br>\n");  }
                    }
                }
            }
            # else if piece is month name
            elseif (isset($MonthNames[$Piece]))
            {
                # if we don't have begin month
                if (!isset($BeginMonth))
                {
                    # set begin month
                    $BeginMonth = $MonthNames[$Piece];
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got begin month A ($BeginMonth)<br>\n");  }
                }
                else
                {
                    # if we don't have end month
                    if (!isset($EndMonth))
                    {
                        # set end month
                        $EndMonth = $MonthNames[$Piece];
                        if ($this->DebugLevel > 1) {  print("SPTDate:  got end month A ($EndMonth)<br>\n");  }
                    }
                }
            }
            # else if piece looks like day
            elseif (($Piece > 12) && ($Piece <= 31))
            {
                # if we don't have begin day
                if (!isset($BeginDay))
                {
                    # set begin day
                    $BeginDay = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got begin day A ($BeginDay)<br>\n");  }
                }
                else
                {
                    # if we don't have end day
                    if (!isset($EndDay))
                    {
                        # set end day
                        $EndDay = $Piece;
                        if ($this->DebugLevel > 1) {  print("SPTDate:  got end day A ($EndDay)<br>\n");  }
                    }
                }
            }
            # else if piece is numeric
            elseif ($Piece > 0)
            {
                # if we have begin month and year but not day
                if (isset($BeginMonth) && isset($BeginYear) && !isset($BeginDay))
                {
                    # use value as begin day
                    $BeginDay = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got begin day B ($BeginDay)<br>\n");  }
                }
                # else if we have begin day and year but not month
                elseif (isset($BeginDay) && isset($BeginYear) && !isset($BeginMonth))
                {
                    # use value as begin month
                    $BeginMonth = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got begin month B ($BeginMonth)<br>\n");  }
                }
                # else if we have end month and year but not day
                elseif (isset($EndMonth) && isset($EndYear) && !isset($EndDay))
                {
                    # use value as end day
                    $EndDay = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got end day B ($EndDay)<br>\n");  }
                }
                # else if we have end day and year but not month
                elseif (isset($EndDay) && isset($EndYear) && !isset($EndMonth))
                {
                    # use value as end month
                    $EndMonth = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got end month B ($EndMonth)<br>\n");  }
                }
                # else if we don't have begin month
                elseif (!isset($BeginMonth))
                {
                    # use value as begin month
                    $BeginMonth = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got begin month C ($BeginMonth)<br>\n");  }
                }
                # else if we don't have begin day
                elseif (!isset($BeginDay))
                {
                    # use value as begin day
                    $BeginDay = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got begin day C ($BeginDay)<br>\n");  }
                }
                # else if we have begin day and month but not year and previous separator seems to indicate end year
                elseif (isset($BeginDay) && isset($BeginMonth) && !isset($BeginYear) && (($Pieces[$Index - 1] == "/") || ($Pieces[$Index - 1] == "-")))
                {
                    # use value as begin year (four-digit values and two-digit < 32 handled above)
                    $BeginYear = $Piece + 2000;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got end month C ($EndMonth)<br>\n");  }
                }
                # else if we don't have end month
                elseif (!isset($EndMonth))
                {
                    # use value as end month
                    $EndMonth = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got end month C ($EndMonth)<br>\n");  }
                }
                # else if we have end day and month but not year and previous separator seems to indicate end year
                elseif (isset($EndDay) && isset($EndMonth) && !isset($EndYear) && (($Pieces[$Index - 1] == "/") || ($Pieces[$Index - 1] == "-")))
                {
                    # use value as end year (four-digit values and two-digit < 32 handled above)
                    $EndYear = $Piece + 2000;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got end month C ($EndMonth)<br>\n");  }
                }
                # else if we don't have end day
                elseif (!isset($EndDay))
                {
                    # use value as end day
                    $EndDay = $Piece;
                    if ($this->DebugLevel > 1) {  print("SPTDate:  got end day C ($EndDay)<br>\n");  }
                }
                else
                {
                    if ($this->DebugLevel > 1) {  print("SPTDate:  could not parse piece \"$Piece\"<br>\n");  }
                }
            }
        }

        # use current year if begin month but no begin year specified
        if (isset($BeginMonth) && !isset($BeginYear))
        {
            $BeginYear = date("Y");
        }

        # use begin year if end month but no end year specified
        if (isset($EndMonth) && !isset($EndYear))
        {
            $EndYear = $BeginYear;
        }
        
        # if end date is before begin date
        if ((($EndYear != NULL) && ($EndYear < $BeginYear))
            || (($EndYear == $BeginYear) && ($EndMonth != NULL) && ($EndMonth < $BeginMonth))
            || (($EndYear == $BeginYear) && ($EndMonth == $BeginMonth) && ($EndDay != NULL) && ($EndDay < $BeginDay)))
        {
            # swap begin and end dates
            $TempYear = $BeginYear;
            $TempMonth = $BeginMonth;
            $TempDay = $BeginDay;
            $BeginYear = $EndYear;
            $BeginMonth = $EndMonth;
            $BeginDay = $EndDay;
            $EndYear = $TempYear;
            $EndMonth = $TempMonth;
            $EndDay = $TempDay;
        }

        # if precision value supplied by caller
        if ($Precision != NULL)
        {
            # use supplied precision value
            $this->Precision = $Precision;
        }
        else
        {
            # save new precision value
            $Prec = 0;
            if (isset($BeginYear)) {  $Prec |= DATEPRE_BEGINYEAR;  }
            if (isset($BeginMonth)) {  $Prec |= DATEPRE_BEGINMONTH;  }
            if (isset($BeginDay)) {  $Prec |= DATEPRE_BEGINDAY;  }
            if (isset($EndYear)) {  $Prec |= DATEPRE_ENDYEAR;  }
            if (isset($EndMonth)) {  $Prec |= DATEPRE_ENDMONTH;  }
            if (isset($EndDay)) {  $Prec |= DATEPRE_ENDDAY;  }
            $this->Precision = $Prec;
        }

        # save new date values
        $this->BeginYear = $BeginYear;
        $this->BeginMonth = $BeginMonth;
        $this->BeginDay = $BeginDay;
        $this->EndYear = $EndYear;
        $this->EndMonth = $EndMonth;
        $this->EndDay = $EndDay;
    }
    
    # return value suitable for display
    function Formatted()
    {
        # if begin year available
        $DateString = "";
        if ($this->Precision & DATEPRE_BEGINYEAR)
        {
            # start with begin year
            $DateString = $this->BeginYear;

            # if begin month available
            if ($this->Precision & DATEPRE_BEGINMONTH)
            {
                # add begin month
                $DateString .= "-".$this->BeginMonth;

                # if begin day available
                if ($this->Precision & DATEPRE_BEGINDAY)
                {
                    # add begin day
                    $DateString .= "-".$this->BeginDay;
                }
            }

            # if end year available
            if ($this->Precision & DATEPRE_ENDYEAR)
            {
                # if separate dates
                if ($this->Precision & DATEPRE_SEPARATE)
                {
                    # separate dates with comma
                    $DateString .= ", ";
                }
                else
                {
                    # separate dates with dash
                    $DateString .= " - ";
                }

                # add end year
                $DateString .= $this->EndYear;

                # if end month available
                if ($this->Precision & DATEPRE_ENDMONTH)
                {
                    # add end month
                    $DateString .= "-".$this->EndMonth;

                    # if end day available
                    if ($this->Precision & DATEPRE_ENDDAY)
                    {
                        # add end day
                        $DateString .= "-".$this->EndDay;
                    }
                }
            }
            else
            {
                # if date is open-ended
                if ($this->Precision & DATEPRE_CONTINUOUS)
                {
                    # add dash to indicate open-ended
                    $DateString .= "-";
                }
            }
            
            # if copyright flag is set
            if ($this->Precision & DATEPRE_COPYRIGHT)
            {
                # add on copyright indicator
                $DateString = "c".$DateString;
            }
            
            # if flag is set indicating date was inferred
            if ($this->Precision & DATEPRE_INFERRED)
            {
                # add on inferred indicators
                $DateString = "[".$DateString."]";
            }
        }

        # return formatted date string to caller
        return $DateString;
    }

    # return begin time in ISO 8601 format
    function FormattedISO8601()
    {
        # if begin year available
        if ($this->Precision & DATEPRE_BEGINYEAR)
        {
            # start with begin year
            $DateString = sprintf("%04d", $this->BeginYear);

            # if begin month available
            if ($this->Precision & DATEPRE_BEGINMONTH)
            {
                # add begin month
                $DateString .= sprintf("-%02d", $this->BeginMonth);

                # if begin day available
                if ($this->Precision & DATEPRE_BEGINDAY)
                {
                    # add begin day
                    $DateString .= sprintf("-%02d", $this->BeginDay);
                }
            }
        }

        # return ISO 8601 formatted date string to caller
        return $DateString;
    }

    # return values in UTC instead of local time  (NOT IMPLEMENTED)
    function UseUTC()
    {
        # if not currently in UTC
        if ($this->InUTC != TRUE)
        {
            # adjust date to UTC
            # ???
            
            # set flag to indicate we are in UTC
            $this->InUTC = TRUE;
        }
    }

    # return values in local time instead of UTC  (NOT IMPLEMENTED)
    function UseLocalTime()
    {
        # if currently in UTC
        if ($this->InUTC)
        {
            # adjust date to local time
            # ???
            
            # set flag to indicate we are in local time
            $this->InUTC = FALSE;
        }
    }
    
    # return normalized values (suitable for storing via SQL)
    function BeginDate() 
    {  
        return sprintf("%04d-%02d-%02d", $this->BeginYear, $this->BeginMonth,
                       $this->BeginDay);
    }
    function EndDate()
    {  
        return sprintf("%04d-%02d-%02d", $this->EndYear, $this->EndMonth,
                       $this->EndDay);
    }
    
    # get or set precision value (combination of boolean flags)
    function Precision($NewPrecision = NULL)
    {
        if ($NewPrecision != NULL) {  $this->Precision = $NewPrecision;  }
        return $this->Precision;
    }
    
    # return text of SQL condition for records that match date
    function SqlCondition($FieldName, $EndFieldName = NULL, $Operator = "=")
    {
        # use begin field name as end if no end field specified
        if ($EndFieldName == NULL) {  $EndFieldName = $FieldName;  }
        
        # determine begin and end of range
        $BeginYear = $this->BeginYear;
        if ($this->Precision & DATEPRE_BEGINMONTH)
        {
            $BeginMonth = $this->BeginMonth;
            if ($this->Precision & DATEPRE_BEGINDAY)
            {
                $BeginDay = $this->BeginDay - 1;
            }
            else
            {
                $BeginDay = 0;
            }
        }
        else
        {
            $BeginMonth = 1;
            $BeginDay = 0;
        }
        if ($this->Precision & DATEPRE_ENDYEAR)
        {
            $EndYear = $this->EndYear;
            if ($this->Precision & DATEPRE_ENDMONTH)
            {
                $EndMonth = $this->EndMonth;
                if ($this->Precision & DATEPRE_ENDDAY)
                {
                    $EndDay = $this->EndDay;
                }
                else
                {
                    $EndMonth++;
                    $EndDay = 0;
                }
            }
            else
            {
                $EndYear++;
                $EndMonth = 1;
                $EndDay = 0;
            }
        }
        else
        {
            $EndYear = $BeginYear;
            if ($this->Precision & DATEPRE_BEGINMONTH)
            {
                $EndMonth = $BeginMonth;
                if ($this->Precision & DATEPRE_BEGINDAY)
                {
                    $EndDay = $BeginDay + 1;
                }
                else
                {
                    $EndMonth++;
                    $EndDay = 0;
                }
            }
            else
            {
                $EndYear++;
                $EndMonth = 1;
                $EndDay = 0;
            }
        }
        $RangeBegin = "'".date("Y-m-d", mktime(0, 0, 0, $BeginMonth, $BeginDay, $BeginYear))."'";
        $RangeEnd = "'".date("Y-m-d", mktime(0, 0, 0, $EndMonth, $EndDay, $EndYear))."'";
        
        # construct SQL condition
        switch ($Operator)
        {
            case ">":
                $Condition = " ${FieldName} > ${RangeEnd} ";
                break;
                
            case ">=":
                $Condition = " ${FieldName} > ${RangeBegin} ";
                break;
                
            case "<":
                $Condition = " ${FieldName} <= ${RangeBegin} ";
                break;
                
            case "<=":
                $Condition = " ${FieldName} <= ${RangeEnd} ";
                break;
                
            case "!=":
                $Condition = " (${FieldName} <= ${RangeBegin}"
                        ." OR ${FieldName} > ${RangeEnd}) ";
                break;
                
            case "=":
            default:
                $Condition = " (${FieldName} > ${RangeBegin}"
                        ." AND ${FieldName} <= ${RangeEnd}) ";
                break;
        }
        
        # return condition to caller
        return $Condition;
    }
    
    # return string containing printable version of precision flags
    function FormattedPrecision()
    {
        $String = "";
        if ($this->Precision & DATEPRE_BEGINYEAR) {  $String .= "| BEGINYEAR ";  }
        if ($this->Precision & DATEPRE_BEGINMONTH) {  $String .= "| BEGINMONTH ";  }
        if ($this->Precision & DATEPRE_BEGINDAY) {  $String .= "| BEGINDAY ";  }
        if ($this->Precision & DATEPRE_BEGINDECADE) {  $String .= "| BEGINDECADE ";  }
        if ($this->Precision & DATEPRE_ENDYEAR) {  $String .= "| ENDYEAR ";  }
        if ($this->Precision & DATEPRE_ENDMONTH) {  $String .= "| ENDMONTH ";  }
        if ($this->Precision & DATEPRE_ENDDAY) {  $String .= "| ENDDAY ";  }
        if ($this->Precision & DATEPRE_ENDDECADE) {  $String .= "| ENDDECADE ";  }
        if ($this->Precision & DATEPRE_INFERRED) {  $String .= "| INFERRED ";  }
        if ($this->Precision & DATEPRE_COPYRIGHT) {  $String .= "| COPYRIGHT ";  }
        if ($this->Precision & DATEPRE_CONTINUOUS) {  $String .= "| CONTINUOUS ";  }
        if ($this->Precision & DATEPRE_SEPARATE) {  $String .= "| SEPARATE ";  }
        $String = preg_replace("/^\\|/", "", $String);
        return $String;
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $BeginDay;
    var $BeginMonth;
    var $BeginYear;
    var $EndDay;
    var $EndMonth;
    var $EndYear;
    var $Precision;
    var $DebugLevel;
}

# date precision flags
define("DATEPRE_BEGINYEAR",   1);
define("DATEPRE_BEGINMONTH",  2);
define("DATEPRE_BEGINDAY",    4);
define("DATEPRE_BEGINDECADE", 8);
define("DATEPRE_BEGINCENTURY",16);
define("DATEPRE_ENDYEAR",     32);
define("DATEPRE_ENDMONTH",    64);
define("DATEPRE_ENDDAY",      128);
define("DATEPRE_ENDDECADE",   256);
define("DATEPRE_ENDCENTURY",  512);
define("DATEPRE_INFERRED",    1024);
define("DATEPRE_COPYRIGHT",   2048);
define("DATEPRE_CONTINUOUS",  4096);
define("DATEPRE_SEPARATE",    8192);
define("DATEPRE_UNSURE",      16384);


?>
