<?PHP

#
#   FILE:  SPT--StandardHtmlLoad.php
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once(dirname(__FILE__)."/SPT--Common.php");


# save time stamp for page load time calculations
$SavePageGenerationBeginTime = getmicrotime();

# buffer output from HTML file
ob_start();

# load header, set character coding
header("Content-type: text/html; charset=".$SysConfig->DefaultCharacterSet(),
        true);

# load HTML file
include(CorrespondingHtmlFile());

# save buffered output
$BufferedPageOutput = ob_get_contents();

# turn off buffering
ob_end_clean();

# write out standard page start
include(FindUIFile("include/SPT--StandardPageStart.html"));

# restore time stamp for page load time calculations
# (value is reset by standard page start)
$PageGenerationBeginTime = $SavePageGenerationBeginTime;

# write out buffered output
print($BufferedPageOutput);

# write out standard page end
include(FindUIFile("include/SPT--StandardPageEnd.html"));


?>
