<?PHP

#
#   FILE:  SPT--EditClassificationComplete.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       F_ClassificationId
#           - record ID of classification being edited
#       F_NewSegmentName
#           - edited segment value name
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Classification.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# delete classifications
function DeleteClassification()
{
    global $Class;

    $DB =& new SPTDatabase();

    # if classification has no resources and no children associated with it
    if (($Class->ResourceCount() == 0) && ($Class->ChildCount() == 0))
    {
        # delete classification
        $DB->Query("DELETE FROM Classifications WHERE ClassificationId="
                .$Class->Id());
    }
}

# save classifications
function SaveClassification()
{
    global $Class, $HTTP_POST_VARS, $ErrorMessages;

    $DB =& new SPTDatabase();

    # if new classification segment name is valid
    $F_NewSegmentName = trim($HTTP_POST_VARS["F_NewSegmentName"]);
    if(isset($HTTP_POST_VARS["F_QualifierId"]))
        $F_QualifierId = $HTTP_POST_VARS["F_QualifierId"];
    if (strlen($F_NewSegmentName) > 0)
    {
        # save new classification segment name
        $Class->SegmentName($F_NewSegmentName);

        # save qualifier Id
        if(isset($F_QualifierId) && $F_QualifierId != "--")
            $Class->QualifierId($F_QualifierId);

        # rebuild full classification name
        $Class->RecalcDepthAndFullName();
    }
    else
    {
        # add message to error list
        $ErrorMessages =& new ErrorList();
        $ErrorMessages->AddMessage(
        "There was an error with the classification segment name you entered.");
    }
}

# ----- MAIN -----------------------------------------------------------------


# check if current user is authorized
CheckAuthorization(PRIV_CLASSADMIN);

$ErrorMessages = $Session->Get("ErrorMessages");
$F_ClassificationId = $HTTP_POST_VARS["F_ClassificationId"];

# clear any old error info
if (isset($ErrorMessages))
{
    unset($ErrorMessages);
    $Session->UnregisterVariable("ErrorMessages");
}

# pull up existing classification record
$Class =& new Classification($F_ClassificationId);

# if deletion was requested
if ($Submit == "Delete Classification")
{
    DeleteClassification();
}
# else if save changes was requested
elseif ($Submit != "Cancel")
{
    SaveClassification();
}

# if errors were found
if (isset($ErrorMessages))
{
    # return to editing page with error messages
    $Session->RegisterVariable("ErrorMessages");
    PrintAutoRefreshPage("Errors Found", 
            "SPT--EditClassification.php?ClassificationId=".$F_ClassificationId);
}
else
{
    # go to classification selection page for parent of edited classification
    PrintAutoRefreshPage("Classification Editing Complete", 
            "../SPT--BrowseResources.php?Editing=1&ParentId="
                    .$Class->ParentId());
}

?>
