<?php

#
#   FILE:  SPT--ExportData.php
#
#   FUNCTIONS PROVIDED:
#       PrintErrorMessage()
#           - print an error message
#
#       GetFlaggedFilesCount()
#           - get number of flagged resources
#
#       PrintFlaggedFilesMessage()
#           - print the number of flagged resource message
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# print error messages
function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if(!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

# open import file for reading
function GetFlaggedFilesCount()
{
    global $HTTP_SERVER_VARS, $NavDirCorrection;
    global $ScriptFileName, $ErrorMessage;

    $InputPath = substr($ScriptFileName, 0, strrpos($ScriptFileName, '/')).
        "/".$NavDirCorrection."TempStorage/InputData";

    $ResourceCount = 0;

    if(is_null($ErrorMessage) && is_readable($InputPath))
    {
        $fpi = fopen($InputPath, "r");
        while(!feof($fpi))
        {
            $ResourceId = fgets($fpi, 4096);
            $ResourceId = trim($ResourceId);

            if(empty($ResourceId))
                break;
        
            $ResourceCount++;
        }
    }
    return $ResourceCount;
}

function PrintFlaggedFilesMessage()
{
    $ResourceCount = GetFlaggedFilesCount();

    if($ResourceCount)
        print "$ResourceCount resources have been flagged for export.";
    else
    {
        print "No flagged files available for export.<br>";
        print "Use Advanced Search to flag files for export.<br>";
    }
}

require_once("include/SPT--Common.php");
PageTitle("Export Data");
$NavDirCorrection = "../";

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

$TempDir = dirname($ScriptFileName).
            "/".$NavDirCorrection."TempStorage/";

# make sure destination dir exists 
if(!file_exists($TempDir))
{
    $ErrorMessage = "Error: Destination directory ".$TempDir.
                    " doesn't exist.";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
}

# make sure destination dir is writable
else if(!is_writable($TempDir))
{
    $ErrorMessage = "Error: Destination directory ".$TempDir.
                    " is not writable.";
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
