<?php
#
#   FILE:  SPT--AddForum.php
#
#   FUNCTIONS PROVIDED:
#       DisplayForums()    
#           - Display list of forums 
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumHeading()
{
    global $Session;

    $Edit = $Session->Get("Edit");

    if($Edit > 0)
        print "Edit Forum";
    else
        print "Add New Forum";
}

function PrintForumButton()
{
    global $Session;

    $Edit = $Session->Get("Edit");

    if($Edit > 0)
        print "Update Forum";
    else
        print "Add New Forum";
}

function PrintForumName()
{
    global $Session;

    print GetHtmlEscapedString($Session->Get("F_ForumName"));
}

function PrintForumDescription()
{
    global $Session;

    print GetHtmlEscapedString($Session->Get("F_ForumDescription"));
}

# display list of forums from a query
function DisplayForums($FieldName)
{
    global $Session;
    $DB =& new SPTDatabase();

    $F_ForumId = $Session->Get("F_ForumId");

    $Query = "Select * from Forums Order By ForumName";
    $DB->Query($Query);

    $i=0;
    $Items = array();
    reset($Items);
    while($Result = $DB->FetchNextRowArray())
    {
        if($i == 0 && is_null($F_ForumId))
            $F_ForumId = $Result["ForumId"];

        $Items[$Result["ForumId"]] = $Result["ForumName"];
        $i++;
    }
    PrintOptionList($FieldName, $Items, $F_ForumId, 0, 4, NULL, false);
}

# display a list of SPT users
function DisplayUserList($Moderator)
{
    global $Session;
    $DB =& new SPTDatabase();

    $Selected = NULL;
    $F_ForumId = $Session->Get("F_ForumId");
    $Query = "Select * from APUsers Order By UserName";
    $DB->Query($Query);

    $Items = array();
    reset($Items);
    while($Result = $DB->FetchNextRowArray())
    {
        $Items[$Result["UserId"]] = $Result["UserName"];
    }

    # display selected moderator
    if(isset($F_ForumId))
    {
        $Query = "Select ModeratorId from Forums where ForumId = ".$F_ForumId;
        $DB->Query($Query);
        $Result = $DB->FetchNextRowArray();
        $Selected = $Result["ModeratorId"];        
    }
    PrintOptionList($Moderator, $Items, $Selected, NULL, 1, NULL, false);
}

# print out any error messages
function PrintErrorMessages()
{
    global $Session;

    $ErrorMessages = $Session->Get("ErrorMessages");

    # if error messages were passed 
    if (isset($ErrorMessages) && is_array($ErrorMessages) &&
        count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN);

PageTitle("Add/Remove Forums");
include("include/SPT--StandardHtmlPageLoad.php");




?>
