<?php

#
#   FILE:  SPT--AddResourceComment.php
#
#   FUNCTIONS PROVIDED:
#       PrintTitle()
#       - print the resource title
#
#       PrintBody()
#       - print the body of the comment
#
#       PrintSubject()
#       - print subject of comment
#
#       CheckForEdit()
#       - check to see if editing a resource
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Message.php");

PageTitle("Add Resource Comment");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print the Title
function PrintTitle()
{
    global $Entry;

    print $Entry["Title"];
}

# print body
function PrintBody()
{
    global $F_Body;

    # filter out "Edited by:" text
    $loc = strpos($F_Body, "<br>");
    if($loc === false)
        print GetHtmlEscapedString($F_Body);
    else
        print GetHtmlEscapedString(substr($F_Body, 0, $loc - 2));  
} 

# print body
function PrintSubject()
{
    global $F_Subject;

    print GetHtmlEscapedString($F_Subject);
} 

function CheckForEdit()
{
    global $MessageId, $User, $PosterId;

    if(isset($MessageId) && ($User->Get("UserId") == $PosterId ||
        $User->HasPriv(PRIV_SYSADMIN)))
        return true;
    else
        return false;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# do the query
function PerformResourceQuery()
{
    global $DB, $Entry, $HTTP_GET_VARS;

    $ResourceId = $HTTP_GET_VARS["ResourceId"];

    $DB->Query(
        "Select * from Resources where Resources.ResourceId=$ResourceId");

    # get the first entry which will have all of the Resources
    $Entry = $DB->FetchNextRowArray();

}

# ----- MAIN -----------------------------------------------------------------

# grab entry information from database
$DB =& new SPTDatabase();
$Entry = array();

# do the query for this resource
PerformResourceQuery();

$ParentId = $ResourceId;

if(!empty($messageid))
{
    $MessageId = $HTTP_GET_VARS["messageid"];
    $Message =& new Message($MessageId);
    $F_Subject = $Message->Subject();
    $F_Body = $Message->Body();
    $PosterId = $Message->PosterId();
}
else
{
    $MessageId = NULL;
    $F_Subject = $Entry["Title"];
}

# pass along necessary variables 
$Session->PassVariable("ResourceId", $ResourceId);
$Session->PassVariable("ParentId", $ResourceId);
$Session->PassVariable("F_Subject", GetHtmlEscapedString($F_Subject));
$Session->PassVariable("MessageId", $MessageId);

CheckAuthorization(PRIV_POSTCOMMENTS);
include("include/SPT--StandardHtmlPageLoad.php");

?>
