<?PHP

#
#   FILE:  SPT--ConfirmRemoveUser.php
#
#   FUNCTIONS PROVIDED:
#       PrintUserName()
#       - print out topic name 
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#
require_once("include/SPT--Common.php");
require_once("include/SPT--Forum.php");
require_once("include/SPT--Topic.php");
PageTitle("Confirm Remove User");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to return true if users have been selected for removal
function RemoveUsersExist()
{
    global $UserRemoveArray;

    return count($UserRemoveArray);
}

function PrintUserList()
{
    global $Session, $UserRemoveArray;
    
    $DB =& new SPTDatabase();

    foreach($UserRemoveArray as $UserId)
    {
        $RemoveUser =& new User($DB, intval($UserId));
        print $RemoveUser->Get("UserName")."<br>";
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$UserRemoveArray = $Session->Get("UserRemoveArray");

$Session->PassVariable("OkayToRemove", 1);
$Session->PassVariable("UserRemoveArray", $UserRemoveArray);

CheckAuthorization( PRIV_USERADMIN, PRIV_SYSADMIN );
include("include/SPT--StandardHtmlPageLoad.php");

?>
