<?PHP

#
#   FILE:  SPT--DBOrderFields.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------


function PrintOrderedDisplayFields()
{
    global $DisplayLabel;
    global $DisplayFieldId;
    global $DisplayOrderPosition;

    $Schema = & new MetadataSchema();

    # get fields ordered for display
    $Fields = $Schema->GetFields(NULL, MDFORDER_DISPLAY, FALSE);

    foreach($Fields as $Field)
    {
        if($Field->Enabled() && $Field->Viewable())
        {
            $DisplayLabels[] = $Field->Name();
        }
    }


    $Index = 0;
    foreach($DisplayLabels as $DisplayLabel)
    {
        $Field = $Schema->GetFieldByName($DisplayLabel);
        $DisplayFieldId = $Field->Id();
        $DisplayOrderPosition = $Field->OrderPosition( MDFORDER_DISPLAY );
        
        PrintDisplayFieldName();
    }
}


function PrintOrderedEditingFields()
{
    global $EditingLabel;
    global $EditingFieldId;

    $Schema = & new MetadataSchema();

    # get fields ordered for editing
    $Fields = $Schema->GetFields(NULL, MDFORDER_EDITING, FALSE);

    foreach($Fields as $Field)
    {
        if($Field->Enabled())
        {
            $EditingLabels[] = $Field->Name();
        }
    }

    $Index = 0;
    foreach($EditingLabels as $EditingLabel)
    {
        $Field = $Schema->GetFieldByName($EditingLabel);
        $EditingFieldId = $Field->Id();
        PrintEditingFieldName();
    }
}

# function to print field name 
function PrintDisplayLabel()
{
    global $DisplayLabel;

    print $DisplayLabel;
}

function PrintDisplayOrderPosition()
{
    global $DisplayOrderPosition;

    print $DisplayOrderPosition;
}


# function to print field name 
function PrintDisplayFieldId()
{
    global $DisplayFieldId;

    print $DisplayFieldId;
}

# function to print field name 
function PrintEditingLabel()
{
    global $EditingLabel;

    print $EditingLabel;
}

# function to print field name 
function PrintEditingFieldId()
{
    global $EditingFieldId;

    print $EditingFieldId;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

PageTitle("Metadata Field Ordering");
CheckAuthorization(PRIV_SYSADMIN);

include("include/SPT--StandardHtmlPageLoad.php");

?>
