<?PHP

#
#   FILE:  SPT--DBOrderFields.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   FORM FIELDS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--MetadataSchema.php");

function MoveField( $Schema, $FieldId, $NumMoves, $OrderType )
{

	if ( $NumMoves > 0 )
	{
		for( $i = $NumMoves ; $i > 0 ; $i-- )
		{
			$Schema->MoveUpInOrder( $FieldId, $OrderType );
		}
	}

	else if ( $NumMoves < 0 )
	{
		for( $j = $NumMoves; $j < 0 ; $j++ )
		{
			$Schema->MoveDownInOrder( $FieldId, $OrderType );
		}
	}
}

# -------------
# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

# if save changes was requested
if ($HTTP_POST_VARS["Submit"] == "Submit")
{
    $Schema = & new MetadataSchema();

    $Moves = explode("\n", $HTTP_POST_VARS["FieldMoves"]);
    
    foreach ( $Moves as $move )
    {
    	$MoveChunks = explode("*", $move);
    	
    	if ( $MoveChunks[0] == "Display" )
    		MoveField( $Schema, $MoveChunks[1], (int) $MoveChunks[2], MDFORDER_DISPLAY );

    	else if ( $MoveChunks[0] == "Edit" )
    		MoveField( $Schema, $MoveChunks[1], (int) $MoveChunks[2], MDFORDER_EDITING );
    }
    
    # return to Field Ordering screen 
    PrintAutoRefreshPage("Metadata Field Ordering", "SPT--DBOrderFields.php");
}
# If javascript isn't working properly, one of these cases will occur
else if ( $HTTP_POST_VARS["Submit"] == "DisplayUp" )
{
    $Schema = & new MetadataSchema();
    $Schema->MoveUpInOrder( $HTTP_POST_VARS["DisplayFields"], MDFORDER_DISPLAY);
    # return to Field Ordering screen 
    PrintAutoRefreshPage("Metadata Field Ordering", "SPT--DBOrderFields.php");
}
else if ( $HTTP_POST_VARS["Submit"] == "DisplayDown" )
{
    $Schema = & new MetadataSchema();
    $Schema->MoveDownInOrder( $HTTP_POST_VARS["DisplayFields"], MDFORDER_DISPLAY);
    # return to Field Ordering screen 
    PrintAutoRefreshPage("Metadata Field Ordering", "SPT--DBOrderFields.php");

}
else if ( $HTTP_POST_VARS["Submit"] == "EditingUp" )
{
    $Schema = & new MetadataSchema();
    $Schema->MoveUpInOrder( $HTTP_POST_VARS["DisplayFields"], MDFORDER_EDITING);
    # return to Field Ordering screen 
    PrintAutoRefreshPage("Metadata Field Ordering", "SPT--DBOrderFields.php");

}
else if ( $HTTP_POST_VARS["Submit"] == "EditingDown" )
{
    $Schema = & new MetadataSchema();
    $Schema->MoveDownInOrder( $HTTP_POST_VARS["DisplayFields"], MDFORDER_EDITING);
    # return to Field Ordering screen 
    PrintAutoRefreshPage("Metadata Field Ordering", "SPT--DBOrderFields.php");
    
}
# that's a cancel
else
{
    # return to SysAdmin menu 
    PrintAutoRefreshPage("System Administration", "SPT--SysAdmin.php");
}

?>
