<?php
#
#   FILE:  SPT--ForumTopics.php
#
#   FUNCTIONS PROVIDED:
#       - PrintForumId()
#       - PrintForumDescription()
#       - PrintTopicCount()
#       - PrintMessageCount()
#       - PrintViewCount()
#       - PrintForumName()
#       - PrintURLEncodeForumName()
#       - PrintVar()
#       - DisplayTopics()
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Forum.php");
require_once("include/SPT--Topic.php");
require_once("include/SPT--Message.php");
PageTitle("Forums Topics");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumDescription()
{
    global $ForumDescription;

    print $ForumDescription;
}

function PrintTopicCount()
{
    global $TopicCount;

    print $TopicCount;
}

function PrintMessageCount()
{
    global $MessageCount;

    print $MessageCount;
}

function PrintForumName()
{
    global $ForumName;

    print $ForumName;
}

function PrintURLEncodeForumName()
{
    global $ForumName;

    print urlencode($ForumName);
}

function PrintTopicName()
{
    global $TopicName;

    print $TopicName;
}

function PrintTopicId()
{
    global $TopicId;

    print $TopicId;
}

function PrintViewCount()
{
    global $ViewCount;

    print $ViewCount;
}

function PrintCreator()
{
    global $Creator;

    print $Creator;
}

function PrintCreatorEmail()
{
    global $CreatorEmail;

    print $CreatorEmail;
}

function PrintLastMessage()
{
    global $LastMessage;

    print $LastMessage;
}

function PrintPoster()
{
    global $Poster;

    print $Poster;
}

function PrintPosterEmail()
{
    global $PosterEmail;

    print $PosterEmail;
}

function DisplayTopics()
{
    global $ForumId;
    global $LastMessage, $Poster, $PosterId;
    global $TopicName, $TopicId, $MessageCount;
    global $ViewCount, $Creator, $CreatorEmail;
    $DB =& new SPTDatabase();
    global $Topic;
    
    $query = "Select * from Topics WHERE ForumId = $ForumId Order By ".
                "DateCreated Desc";
    $DB->Query($query);

    while($Entry = $DB->FetchNextRowArray())
    {
        $TopicId = $Entry["TopicId"];
        $Topic =& new Topic($TopicId);
        $TopicName = $Topic->TopicName();
        $ForumId = $Topic->ForumId();
        $MessageCount = $Topic->MessageCount();
        $ViewCount = $Topic->ViewCount();
        $Creator = $Topic->CreatorName();
        $CreatorEmail = $Topic->CreatorEmail();

        # get last message posted for this topic
        LastMessage();
        PrintTopic();
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function LastMessage()
{
    global $LastMessage, $Poster, $PosterEmail, $TopicId;

    $DB =& new SPTDatabase();
    $LastMessage = "None";
    $Poster = NULL;
    $PosterEmail = NULL;
    
    $DB->Query("SELECT * from Messages where ParentId = ".$TopicId.
                    " AND ParentType = 1 ORDER BY DatePosted DESC Limit 1");
    if($DB->NumRowsSelected() > 0)
    {
        $Record = $DB->FetchNextRowArray();
        if($LastMessage == "None")
            $LastMessage = $Record["DatePosted"];
        if($Record["DatePosted"] > $LastMessage)
        {
            $Message =& new Message($Record["MessageId"]);
            $LastMessage = $Record["DatePosted"];
            $Poster = $Message->PosterName();
            $PosterEmail = $Message->PosterEmail();
         }
    }
    If($LastMessage != "None")
        $LastMessage .= " by ";
}

function GetForumInfo($ForumId)
{
    global $ForumName, $ForumDescription, $TopicCount, $MessageCount;
    global $ModeratorId, $Moderator, $ModeratorEmail; 

    $Forum =& new Forum($ForumId);

    $ForumName = $Forum->ForumName();
    $ForumDescription = $Forum->ForumDescription();
    $TopicCount = $Forum->TopicCount();
    $MessageCount = $Forum->MessageCount();
    $ModeratorId = $Forum->ModeratorId();
    $ModeratorName = $Forum->ModeratorName();
    $ModeratorEmail = $Forum->ModeratorEmail();
    return ($ForumId);
}

# ----- MAIN -----------------------------------------------------------------

# obtain useful info for this forum
$ForumId = GetForumInfo($forumid);

include("include/SPT--StandardHtmlPageLoad.php");


?>
