<?php
#
#   FILE:  SPT--SavedSearch.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--SearchEngine.php");
require_once("include/SPT--SystemConfiguration.php");

PageTitle("Advanced Search Results");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintSavedSearches()
{
    global $DB;
    global $User;
    global $SysConfig;

    $Items = array();
    $UserId = $User->Get("UserId");

    $Query = "Select * from UserSearch where UserId=$UserId ".
                    "ORDER BY SearchId DESC";
    $DB->Query($Query);

    $SavedSearchCount = 0;
    $Index = 0;
    while($Entry = $DB->FetchNextRowArray())
    {
        if($Entry["Frequency"] != "Never")
            $Checked = " checked=\"checked\"";
        else
            $Checked = NULL;
        print "<tr>\n";

        print "<th align=\"right\">".$Entry["SearchName"]."</th>\n";

        print "<input type=\"hidden\" name=\"F_SearchId_$Index\"".
              "value=\"".$Entry["SearchId"]."\"></td>\n";

        print "<td><input type=\"Submit\" name=\"F_Edit_$Index\"". 
              "value=\"Edit\">\n";

        print "<td><input type=\"Submit\" name=\"F_Delete_$Index\"".             
              "value=\"Delete\"></td>\n";

        if ( $SysConfig->UserAgentsEnabled() )
            print "<td align=\"center\"><input type=\"checkbox\"".         
                  " onclick=\"submit()\" onkeypress=\"submit()\" name=\"F_Email_$Index\"$Checked>".
                  "&nbsp;</td>\n";

        print "<td>".$Entry["SearchCriteria"]."</td>\n";

        print "</tr>\n";
        $Index++;
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# save new saved search
function SaveNewSavedSearch()
{
    global $User, $DB, $HTTP_POST_VARS, $Session;

    $SearchId = $HTTP_POST_VARS["SearchId"];
    $SearchName = $HTTP_POST_VARS["F_SearchName"];

    # empty search name entered, warn user
    if(empty($SearchName))
    {
        $ErrorMessage = "ERROR: You must enter a search name.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        $Session->PassVariable("SearchId", $SearchId);
        PrintAutoRefreshPage("New Saved Search", "SPT--NewSavedSearch.php");
        exit;
    }

    $Query = "SELECT SearchName from UserSearch WHERE ".
        "SearchName = \"$SearchName\" AND ".
        "SearchId != $SearchId AND ".
        "UserId = ".$User->Get("UserId");

    $DB->Query($Query);
    if($DB->NumRowsSelected() > 0)
    {
        $ErrorMessage = "ERROR: Duplicate search name entered ($SearchName)".
            "<br>Please select a different name.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        $Session->PassVariable("SearchId", $SearchId);
        PrintAutoRefreshPage("New Saved Search", "SPT--NewSavedSearch.php");
        exit;
    }

    if(isset($HTTP_POST_VARS["F_Email"]))
        $Email = $HTTP_POST_VARS["F_Email"];
    if(isset($Email) && $Email == "on")
       $Frequency = "Once a day";
    else
       $Frequency = "Never";

    $Query = "Update UserSearch set Frequency = \"$Frequency\", ".
        "SearchName = \"$SearchName\" ".
        "WHERE SearchId = $SearchId";
    $DB->Query($Query);
}

# discard new saved search
function DiscardNewSavedSearch()
{
    global $DB, $HTTP_POST_VARS;

    $SearchId = $HTTP_POST_VARS["SearchId"];

    $Query = "DELETE from UserSearch WHERE SearchId = $SearchId";
    $DB->Query($Query);

    PrintAutoRefreshPage("Advanced Search", "SPT--Advanced.php");
    exit;
}

# ----- MAIN -----------------------------------------------------------------

# grab entry information from database
$DB =& new SPTDatabase();

if(isset($HTTP_GET_VARS["Editing"]))
    $Editing = $HTTP_GET_VARS["Editing"];
else
    $Editing = $Session->Get("Editing");
    
if(isset($HTTP_POST_VARS["Submit"]) && $HTTP_POST_VARS["Submit"] == "Continue")
{
    SaveNewSavedSearch();
}
else if(isset($HTTP_POST_VARS["Submit"]) && $HTTP_POST_VARS["Submit"] ==
            "Cancel")
{
    DiscardNewSavedSearch();
}

if ( !UserIsLoggedIn() )
{      
    include("include/SPT--UnauthorizedAccess.php");
    exit();
}

include("include/SPT--StandardHtmlPageLoad.php");
$Session->PassVariable("Editing", $Editing);

?>
