<?PHP
#
#   FILE:  SPT--TopicMessages.php
#
#   FUNCTIONS PROVIDED:
#       - PrintForumName()
#       - PrintForumDescription()
#       - PrintTopicName()
#       - PrintVar()
#       - CheckForModeratorOrSysAdmin()
#       - CheckForUserLoggedIn()
#       - DisplayMessages()
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Forum.php");
require_once("include/SPT--Topic.php");
require_once("include/SPT--Message.php");
PageTitle("Topic Messages");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumName()
{
    global $ForumName;

    print $ForumName;
}

function PrintForumDescription()
{
    global $ForumDescription;

    print $ForumDescription;
}


function PrintTopicName()
{
    global $TopicName;

    print $TopicName;
}

function PrintVar($VarName)
{
    print $VarName;
}

function CheckForModeratorOrSysAdmin()
{
    global $User, $ModeratorId;

    if($User->Get("UserId") == $ModeratorId || $User->HasPriv(PRIV_SYSADMIN))
        return true;
    else
        return false;
}

function CheckForUserLoggedIn()
{
    global $User;

    if($User->IsLoggedIn() == TRUE)
        return true;
    else
        return false;
}

function DisplayMessages()
{
    global $TopicId;
    global $ForumId;
    global $PosterId;
    global $MessageCount;

    $DB =& new SPTDatabase();
    
    $query = "Select * from Messages WHERE ParentId = $TopicId ".
                "AND ParentType = 1 Order By ".
                "DatePosted Desc";
    $DB->Query($query);
    $MessageCount = $DB->NumRowsSelected();

    while($Entry = $DB->FetchNextRowArray())
    {
        $Message =& new Message($Entry["MessageId"]);
        $MessageId = $Message->MessageId();
        $Subject = $Message->Subject();
        $Body = $Message->Body();
        $DatePosted = $Message->DatePosted();
        $PosterId = $Message->PosterId();
        $PosterName = $Message->PosterName();
        $PosterEmail = $Message->PosterEmail();
        $EditOkay = CheckForEdit();
        $EditLink = "SPT--PostMessage.php?forumid=".
            "$ForumId&topicid=$TopicId&messageid=$MessageId"; 
        $DeleteLink = "SPT--PostMessage.php?forumid=".
            "$ForumId&topicid=$TopicId&messageid=$MessageId";
        PrintForumMessage($Subject, $Body, $DatePosted, $PosterName,
            $PosterEmail, $EditOkay, $EditLink, $DeleteLink, FALSE);
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# update the viewcount every time page is loaded
function UpdateViewCount()
{
    global $TopicId;
    $DB =& new SPTDatabase();

    $query = "SELECT ViewCount from Topics WHERE TopicId = $TopicId ";
#    echo "query=$query<br>";
    $DB->Query($query);
    $Entry = $DB->FetchNextRowArray();
    $ViewCount = $Entry["ViewCount"] + 1;

    $query = "UPDATE Topics Set ViewCount = $ViewCount WHERE ".
                "TopicId = $TopicId";
#    echo "query=$query<br>";
    $DB->Query($query);
}

function CheckForEdit()
{
    global $User, $ModeratorId, $PosterId;

    if($User->Get("UserId") == $ModeratorId || 
        ($User->Get("UserId") == $PosterId &&
        $User->HasPriv(PRIV_POSTTOFORUMS)) ||
        $User->HasPriv(PRIV_SYSADMIN))
        return true;
    else
        return false;
}

# ----- MAIN -----------------------------------------------------------------


if(isset($HTTP_GET_VARS["topicid"]))
    $TopicId = $HTTP_GET_VARS["topicid"];
else
    $TopicId = $Session->Get("topicid");
$Topic =& new Topic($TopicId);
$TopicName = $Topic->TopicName();


if(isset($HTTP_GET_VARS["forumid"]))
    $ForumId = $HTTP_GET_VARS["forumid"];
else
    $ForumId = $Session->Get("forumid");
$Forum =& new Forum($ForumId);
$ForumName = $Forum->ForumName();
$ForumDescription = $Forum->ForumDescription();
$ModeratorId = $Forum->ModeratorId();

UpdateViewCount();

include("include/SPT--StandardHtmlPageLoad.php");

?>
