<?PHP

#
#   FILE:  SPT--UpdateForum.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#
require_once("include/SPT--Common.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# remove selected forum 
function RemoveForum()
{
    global $DB, $HTTP_POST_VARS, $Session;
    $DB1 =& new SPTDatabase();

    $F_ForumId = $HTTP_POST_VARS["F_ForumId"];
    if(is_null($F_ForumId))
        $F_ForumId = $Session->Get("F_ForumId");

    if(!empty($F_ForumId))
    {
        $Query = "Select * from Topics where ForumId=$F_ForumId";
        $DB->Query($Query);

        while($Entry = $DB->FetchNextRowArray())
        {
            $Query = "Delete from Messages where ParentId = $Entry[TopicId] ".
                        "and ParentType = 1";
            $DB1->Query($Query);              
            $Query = "Delete from Topics where TopicId = $Entry[TopicId]";
            $DB1->Query($Query); 
        }
        $DB->Query("DELETE from Forums where ".
            "ForumId=$F_ForumId");
    }
}

# add new forum 
function AddForum()
{
    global $DB, $F_ForumName, $F_ForumDescription, $F_ForumModeratorId;
    global $Session, $HTTP_POST_VARS;

    $F_ForumName = $HTTP_POST_VARS["F_ForumName"];
    if(is_null($F_ForumName))
        $F_ForumName = $Session->Get("F_ForumName");

    $F_ForumDescription = $HTTP_POST_VARS["F_ForumDescription"];
    if(is_null($F_ForumDescription))
        $F_ForumDescription = $Session->Get("F_ForumDescription");
        
    $F_ForumName = addslashes($F_ForumName);
    $F_ForumDescription = addslashes($F_ForumDescription);

    # make sure not empty strings
    if (strlen($F_ForumName) && strlen($F_ForumDescription))
    {
        $Query = "Insert Forums (ForumId, ForumName, ForumDescription, ".
                "TopicCount, MessageCount, ModeratorId) ".
                "values (NULL, \"$F_ForumName\", \"$F_ForumDescription\", ".
                "0, 0, $F_ForumModeratorId)"; 

        $DB->Query($Query);
    }
    else
    {
        $ErrorMessages[] = 
            "Error: Forum name and description are required fields.";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        $Session->PassVariable("F_ForumName", $F_ForumName);
        $Session->PassVariable("F_ForumDescription", $F_ForumDescription);
        PrintAutoRefreshPage("ErrorMessage", "SPT--AddForum.php");
        exit;
    }
}

# edit selected forum
function EditForum()
{
    global $Session, $DB, $F_ForumId;

    $Query = "Select * from Forums where ForumId=$F_ForumId";
    $DB->Query($Query);
    $Entry = $DB->FetchNextRowArray();

    $Session->PassVariable("F_ForumDescription", $Entry["ForumDescription"]);
    $Session->PassVariable("F_ForumName", $Entry["ForumName"]);
    $Session->PassVariable("Edit", 1);
}

# update selected forum
function UpdateForum()
{
    global $DB;
    global $HTTP_POST_VARS, $Session, $F_ForumId;

    $F_ForumName = $HTTP_POST_VARS["F_ForumName"];
    if(is_null($F_ForumName))
        $F_ForumName = $Session->Get("F_ForumName");

    $F_ForumDescription = $HTTP_POST_VARS["F_ForumDescription"];
    if(is_null($F_ForumDescription))
        $F_ForumDescription = $Session->Get("F_ForumDescription");
        
    $F_ForumName = addslashes($F_ForumName);
    $F_ForumDescription = addslashes($F_ForumDescription);

    $Query = "Update Forums set ModeratorId = ".
                $HTTP_POST_VARS["F_ForumModeratorId"].
                ", ForumName = \"".$F_ForumName.
                "\", ForumDescription = \"".$F_ForumDescription.
                "\" where ForumId=$F_ForumId";
    $DB->Query($Query);
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN);

# grab entry information from database
$DB =& new SPTDatabase();

if(isset($HTTP_POST_VARS["Submit"]))
    $Submit = $HTTP_POST_VARS["Submit"];
else
    $Submit = NULL;

if(isset($HTTP_POST_VARS["F_ForumId"]))
    $F_ForumId = $HTTP_POST_VARS["F_ForumId"];
else    
    $F_ForumId = $Session->Get("F_ForumId");

if(isset($HTTP_POST_VARS["F_ModeratorForumId"]))
    $F_ModeratorForumId = $HTTP_POST_VARS["F_ModeratorForumId"];
else
    $F_ModeratorForumId = NULL;

# check for Cancel button from previous screen
if($Submit=="Cancel")
{
    PrintAutoRefreshPage("SPT Home", "SPT--Home.php");
}
else if(substr($Submit, 0, 6) == "Remove")
{
    RemoveForum();
}
else if(substr($Submit, 0, 3) == "Add")
{
    AddForum();
}
else if(substr($Submit, 0, 4) == "Edit")
{
    EditForum();
}
else if(substr($Submit, 0, 6) == "Update")
{
    UpdateForum();
}

# return to add forum page
$Session->PassVariable("F_ForumId", $F_ForumId);
$Session->PassVariable("F_ModeratorForumId", $F_ModeratorForumId);
PrintAutoRefreshPage("Add Forum", "SPT--AddForum.php");

?>
