<?php
#
#   FILE:  SPT--UserAgentSearch.php
#
#   FUNCTIONS PROVIDED:
#       PrintUserAgentSearchEntries()
#           - prints entries found as a result of an advanced search
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--SearchEngine.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ControlledName.php");

PageTitle("UserAgent Search Results");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# email resource entry found as a result of a user agent search 
function EmailSearchResults()
{
    global $SearchResults;
    global $TempUser;
    global $F_Response;
    global $SearchName;
    global $SysConfig;
    
    # start message body with heading
    $Body = "\n"
            .$SysConfig->PortalName()."\n"
            ."User Agent Search Results\n"
            ."\n";

    # for each search result entry up to the limit to be displayed
    foreach ($SearchResults as $ResourceId => $Score)
    {
        # add resource title to message body
        $Resource =& new Resource($ResourceId);
        $Body .= "      Title:  ".$Resource->Get("Title")."\n";
        
        # if user didn't request only titles
        if ($F_Response != "Title")
        {
            # add resource URL to message body
            $Body .= "        URL:  ".$Resource->Get("Url")."\n";
            
            # if user didn't request only titles and URLs
            if ($F_Response != "TitleURL")
            {
                # add resource description to message body
                $Body .= "Description:  ".$Resource->Get("Description")."\n";
            }
        }
        
        # add resource issue date to message body
        $Body .= " Issue Date:  ".$Resource->Get("Date Issued")."\n";
        
        # add whitespace between entries
        $Body .= "\n";
    }
    
    # strip out any HTML that might be lurking in the text
    $Body = strip_tags($Body);

    # add info line at bottom
    $Body .= "\n"
             ."User agent search results for user ".$TempUser->Get("UserName")
             ." generated ".date("M j Y")." at ".date("g:ia T")."\n\n";

    # mail report to User
    if (strlen($TempUser->Get("Email")) > 0)
    {
        mail($TempUser->Get("Email"), $SysConfig->PortalName()." - New Search Results", $Body);
    }
}

function PrintTotalNumberOfResults()
{
    global $Engine;

    # make sure search has been done
    PerformSearch();

    print($Engine->NumberOfResults());
}


function NoResultsFound()
{
    global $Engine;

    # make sure search has been done
    PerformSearch();

    return ($Engine->NumberOfResults() == 0) ? TRUE : FALSE;
}

function SearchWasUserAgent()
{
    global $SearchStrings;
    return isset($SearchStrings) ? TRUE : FALSE;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PreProcessVariables()
{
    global $Session, $F_Response, $F_ReleaseFlag, $F_AddedBy, $Query;
    global $F_TextField1, $F_TextField2, $F_TextField3, $F_TextField4;
    global $SearchCriteria;
    global $rpp, $sr, $StartingResult, $ResultsPerPage, $F_MaxRecords;
    global $fr, $rf, $ab;
    global $F_Response, $ss, $vn, $vv, $SearchStrings;

    # strip out extra backslashes from text fields
    $F_TextField1 = stripslashes($F_TextField1);
    $F_TextField2 = stripslashes($F_TextField2);
    $F_TextField3 = stripslashes($F_TextField3);
    $F_TextField4 = stripslashes($F_TextField4);

    # grab starting result number if passed in
    if (isset($sr))
        $StartingResult = $sr;
    else
        $StartingResult = 0;

    # grab results per page if passed in
    if(isset($rpp))
        $ResultsPerPage = $rpp;
    else
        $ResultsPerPage = $F_MaxRecords;

    # special case of linked ControlledNames or Classifications
    if(isset($vn) && isset($vv))
    {
        $ss = 1;
        $SearchStrings = NULL;
        $SearchCriteria = NULL;
        $SearchStrings[$vn] = stripslashes($vv);
        if(is_numeric($vv))
        {
            $CN = & new ControlledName($vv);
            $vv = $CN->Name();
        }
        $SearchCriteria = $vn." equals ".$vv;
        $F_ReleaseFlag = 1;
        $F_MaxRecords = 20;
        $ResultsPerPage = $F_MaxRecords;
    }

    # do ControlledName lists
    if(!isset($ss))
    {
        unset($GLOBALS["SearchStrings"]);
        unset($GLOBALS["SearchCriteria"]);

        ProcessOptionLists();
        ProcessFlags();
    }

    # grab display response
    if(isset($fr))
        $F_Response = $fr;

    # grab release flag
    if(isset($rf))
        $F_ReleaseFlag = $rf;

    # grab added by user
    if(isset($ab))
        $F_AddedBy = $ab;
}


function ParseAndStoreArguments()
{
    global $F_ReleaseFlag;
    global $F_AddedBy;
    global $SearchStrings;
    global $SearchCriteria;

    # set release flag to "only released records" if not already set
    if (!isset($F_ReleaseFlag)) {  $F_ReleaseFlag = 1;  }

    # add release flag to search strings if not set to "all records"
    if ($F_ReleaseFlag != "All") 
    {  
        $SearchStrings["Release Flag"] = $F_ReleaseFlag;  
    }

    # add "record added by" to search strings if not set to "anyone"
    if (strlen($F_AddedBy) && ($F_AddedBy != "All"))
    {  
        $DB =& new SPTDatabase();
        $NewUser =& new User($DB, (int)$F_AddedBy);

        $SearchStrings["Added By Id"] = $F_AddedBy;  
        $SearchCriteria .= "<br>User equals ".$NewUser->Get("UserName");
    }
}

# Peform the Search
function PerformSearch()
{
    global $SysConfig;
    global $Engine;
    global $SearchString;
    global $SearchStrings;
    global $SearchResults;
    global $StartingResult;
    global $ResultsPerPage;

    # create search engine
    $Engine = new SPTSearchEngine;

    # set OR/AND terms status
    $Engine->SearchTermsRequiredByDefault(
            $SysConfig->SearchTermsRequired());

    # add filter function if defined in HTML file
    if (function_exists("FilterSearchResults"))
    {
        $Engine->AddResultFilterFunction("FilterSearchResults");
    }

    # if advanced search
    if (isset($SearchStrings))
    {
        # add in search keywords if set
        if (isset($SearchString))
        {
            $SearchStrings["Keyword"] = $SearchString;
        }

	    # perform fielded search
        $SearchResults = $Engine->FieldedSearch(
                $SearchStrings, $StartingResult, $ResultsPerPage);
    }
    else
    {
        # perform keyword search
        $SearchResults = $Engine->Search(
                stripslashes($SearchString), $StartingResult, $ResultsPerPage);
    }
}

# function to filter the search results based on limit criteria
function FilterSearchResults($ResourceId)
{
    global $DB, $Query, $DateLastRun, $ResourceCount;

    $Query = "SELECT distinct R.ResourceId FROM Resources as R ";
    $Recent = " AND DateOfRecordRelease > $DateLastRun ";
    
    $FilterQuery = $Query." WHERE R.ResourceId = ".$ResourceId.$Recent;

    $DB->Query($FilterQuery);

    # keep track of number of Resources found for this report
    if($DB->NumRowsSelected() > 0)
        $ResourceCount++;
        
    return ($DB->NumRowsSelected()) ? FALSE : TRUE;
}

# function to process a search field for the query
function ProcessSearchField($Search, $Field)
{
    global $SearchStrings;

    if(!empty($Field))
    {
        $SearchStrings[$Search] = $Field;
    }
}

# function to process Option lists for the query
function ProcessOptionLists()
{
    global $SearchStrings, $Entry;
    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_OPTION); 

    foreach($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->DBFieldName();
        global ${"$FName"};
        ${"$FName"} = explode("|", $Entry[$Field->DBFieldName()]);

        if(is_array(${"$DBName"}))
        {
            foreach(${"$DBName"} as $Value)
            {
                # check for enabled fields
                if($Field->Enabled() && $Value != "No Limit" && !empty($Value))
                {
                    $SearchStrings[$FName][] = $Value;
                }
            }
        }
    }
    # special case cumulative rating
    $Field = $Schema->GetFieldByName("Cumulative Rating");
    if($Field->IncludeInAdvancedSearch())
    {
       $CumulativeRating = explode("|", $Entry[CumulativeRating]);
       if(is_array($CumulativeRating))
        {
            foreach($CumulativeRating as $Value)
            {
                if($Value != "No Limit" && !empty($Value))
                {
                    switch($Value)
                    {
                        case 20:
                            $Stars = "*";
                            break;
                        case 40:
                            $Stars = "**";
                            break;
                        case 60:
                            $Stars = "***";
                            break;
                        case 80:
                            $Stars = "****";
                            break;
                        case 100:
                            $Stars = "*****";
                            break;
                        default:
                            $Stars = "No Limit";
                            break;
                    }
                    $SearchStrings["Cumulative Rating"][] = $Value;
                }
            }
        }
    }
}

# function to process flags for the query
function ProcessFlags()
{
    global $SearchStrings, $Entry;
    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_FLAG); 

    foreach($Fields as $Field)
    {
        # declare global form variables
        $FName = $Field->Name();
        $DBName = $Field->DBFieldName();
        global ${"$DBName"};
        ${"$DBName"} = $Entry[$Field->DBFieldName()];

        # check for enabled fields
        if($Field->Enabled())
        {
            if(is_numeric(${"$DBName"}))
            {
                $SearchStrings[$FName] = ${"$DBName"};
            }
        }
    }
}

# function to check frequency against the current time
function CheckFrequency($Frequency)
{
    $today = getdate(); 
    $hours = $today['hours'];
    $minutes = $today['minutes'];
    $wday  = $today['wday']; 
    $mday = $today['mday']; 
    $mon = $today['mon'];

    # fire on Jan 1, Apr 1, Jul 1, Oct 1 between 02:50 and 03:10 am
    if($Frequency == "Quarterly")
    {
        if(($mon == 1 || $mon == 4 || $mon == 7 || $mon == 10) &&
            $mday == 1 && (($minutes > 50 && $hours == 2) || 
            ($minutes < 10 && $hours == 3)))
            return(true);
    }
    # fire on 1st day of the month between 02:50 and 03:10 am every other month
    if($Frequency == "Bi-monthly")
    {
        if( ($mon%2 == 1) &&
            $mday == 1 && (($minutes > 50 && $hours == 2) || 
            ($minutes < 10 && $hours == 3)))
            return(true);
    }
    # fire on 1st day of the month between 02:50 and 03:10 am
    if($Frequency == "Once a month")
    {
        if($mday == 1 && (($minutes > 50 && $hours == 2) || 
            ($minutes < 10 && $hours == 3)))
            return(true);
    }
    # fire on Sunday nite between 02:50 and 03:10 am every other week
    else if($Frequency == "Bi-weekly")
    {
        if($mday & 1 == 1 && $wday == 0 && (($minutes > 50 && $hours == 2) || 
            ($minutes < 10 && $hours == 3)))
            return(true);
    }
    # fire on Sunday nite between 02:50 and 03:10 am
    else if($Frequency == "Once a week")
    {
        if($wday == 0 && (($minutes > 50 && $hours == 2) || 
            ($minutes < 10 && $hours == 3)))
            return(true);
    }
    # fire between 02;50 and 03:10 am
    else if($Frequency == "Once a day")
    {
        if(($minutes > 50 && $hours == 2) || 
            ($minutes < 10 && $hours == 3))
            return(true);
    }
    # fire hourly
    else if($Frequency == "Hourly")
    {
        return(true);
    }
    return(false);
}

# ----- MAIN -----------------------------------------------------------------

$F_Response = $HTTP_POST_VARS["F_Response"];
$F_ReleaseFlag = $HTTP_POST_VARS["F_ReleaseFlag"];
$F_AddedBy = $HTTP_POST_VARS["F_AddedBy"];
$F_LastModifiedBy = $HTTP_POST_VARS["F_LastModifiedBy"];
$F_MaxRecords = $HTTP_POST_VARS["F_MaxRecords"];
$F_SearchCat1 = $HTTP_POST_VARS["F_SearchCat1"];
$F_SearchCat2 = $HTTP_POST_VARS["F_SearchCat2"];
$F_SearchCat3 = $HTTP_POST_VARS["F_SearchCat3"];
$F_SearchCat4 = $HTTP_POST_VARS["F_SearchCat4"];
$F_TextField1 = $HTTP_POST_VARS["F_TextField1"];
$F_TextField2 = $HTTP_POST_VARS["F_TextField2"];
$F_TextField3 = $HTTP_POST_VARS["F_TextField3"];
$F_TextField4 = $HTTP_POST_VARS["F_TextField4"];

$fr = $HTTP_GET_VARS["fr"];
$rf = $HTTP_GET_VARS["rf"];
$ab = $HTTP_GET_VARS["ab"];
$ss = $HTTP_GET_VARS["ss"];
$vn = $HTTP_GET_VARS["vn"];
$vv = $HTTP_GET_VARS["vv"];
$rpp = $HTTP_GET_VARS["rpp"];

# grab entry information from database
$DB =& new SPTDatabase();
$DB1 =& new SPTDatabase();
$DB2 =& new SPTDatabase();

# make sure User Agents are enabled
if(!$SysConfig->UserAgentsEnabled())
    exit;

# check if saving or loading per user search parameters
$query = "SELECT * FROM UserSearch ";

$DB1->Query($query);

while($Entry = $DB1->FetchNextRowArray())
{
    $OkayToRun = CheckFrequency($Entry[Frequency]);
    $DateLastRun = $Entry[DateLastRun];

    if($OkayToRun)
    {
        unset($SearchStrings);
        $SearchName = stripslashes($Entry[SearchName]);
        $TempUser =& new User($DB, intval($Entry[UserId]));
        $F_SearchCat1 = $Entry[SearchCat1];
        $F_TextField1 = $Entry[SearchText1];
        $F_SearchCat2 = $Entry[SearchCat2];
        $F_TextField2 = $Entry[SearchText2];
        $F_SearchCat3 = $Entry[SearchCat3];
        $F_TextField3 = $Entry[SearchText3];
        $F_SearchCat4 = $Entry[SearchCat4];
        $F_TextField4 = $Entry[SearchText4];
        $F_Response = $Entry[Display];
        $F_MaxRecords = $Entry[MaxRecords];
        $F_AddedBy = $Entry[AddedBy];
        $F_ReleaseFlag = $Entry[ReleaseFlag];

        # setup variables as needed
        PreProcessVariables();

        ProcessSearchField($F_SearchCat1, $F_TextField1);
        ProcessSearchField($F_SearchCat2, $F_TextField2);
        ProcessSearchField($F_SearchCat3, $F_TextField3);
        ProcessSearchField($F_SearchCat4, $F_TextField4);

        # process options and flags
        ProcessOptionLists();
        ProcessFlags();

        # keep track of number of Resources found
        $ResourceCount = 0;
        
        # perform query to get full records
        PerformSearch();

        # email out search results only if resources found 
        if($ResourceCount > 0)
            EmailSearchResults();

        # update DateLastRun field in UserSearch
        $query= "Update UserSearch set DateLastRun = NULL WHERE ".
                "UserId = $Entry[UserId] and SearchName = \"$SearchName\"";
        $DB2->Query($query); 
    }
}

?>
