<?PHP

#
#   FILE:  SPT--Topic.php
#
#   FUNCTIONS PROVIDED:
#       Topic->Topic($TopicId)
#           - constructor
#       Topic->TopicId()
#       Topic->ForumId()
#       Topic->CreatorId()
#       Topic->DateCreated()
#       Topic->TopicName()
#       Topic->ViewCount()
#       Topic->MessageCount()
#           - methods to retrieve resource attributes
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once(dirname(__FILE__)."/../Axis--User.php");


class Topic {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function Topic($TopicId)
    {
        # locate class in database
        $this->DB =& new SPTDatabase();
        $DB =& $this->DB;
        $DB->Query("SELECT * FROM Topics WHERE TopicId = ".$TopicId);

        # load in attributes from database
        $Record = $DB->FetchNextRowArray();
        $this->TopicId =      $TopicId;
        $this->ForumId =      $Record["ForumId"];
        $this->CreatorId =    $Record["CreatorId"];
        $this->DateCreated =  $Record["DateCreated"];
        $this->TopicName =    $Record["TopicName"];
        $this->ViewCount =    $Record["ViewCount"];
        $this->MessageCount = $Record["MessageCount"];
    }

    # data access methods
    function TopicId()        {  return $this->TopicId;  }
    function ForumId()        {  return $this->ForumId;  }
    function CreatorId()      {  return $this->CreatorId;  }
    function DateCreated()    {  return $this->DateCreated;  }
    function TopicName()      {  return $this->TopicName;  }
    function ViewCount()      {  return $this->ViewCount;  }
    function MessageCount()   {  return $this->MessageCount;  }

    function CreatorName()
    {
        $CreatorName =& new User($this->DB, (int)$this->CreatorId());
        return $CreatorName->Get("UserName");
    }

    function CreatorEmail()
    {
        $CreatorName =& new User($this->DB, (int)$this->CreatorId());
        return $CreatorName->Get("Email");
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $DB;
    var $TopicId;
    var $ForumId;
    var $CreatorId;
    var $DateCreated;
    var $TopicName;
    var $ViewCount;
    var $MessageCount;
}

?>
