<?PHP

#
#   FILE:  SPT--WhyRecommend.php
#
#   FUNCTIONS PROVIDED:
#       PrintRecommendedResource()
#           - print resource that was recommended (calling 
#                   PrintRecommendation() for the actual output)
#       PrintRecommendationSources()
#           - print list of resources that were used to make recommendation
#                   (calling PrintRecommendation() for the actual output)
#
#   FUNCTIONS EXPECTED:
#       PrintRecommendation($Title, $Description, $FullRecordLink, $Url, 
#                   $DateOfRecordCreation, $DateRecordAdded, $Contributor, 
#                   $EditOkay, $EditUrl, $DateLastVerified, $DateLastModified)
#           - called by PrintRecommendations() to output each resource
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--Recommender.php");

ParseArguments();
PageTitle("Recommendation Sources");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintRecommendedResource()
{
    global $User;
    global $RecommendedResourceId;

    $Resource =& new Resource($RecommendedResourceId);
    PrintRecommendation($Resource,
            "SPT--FullRecord.php?ResourceId=${RecommendedResourceId}",
            $User->HasPriv(PRIV_RESOURCEADMIN),
            "MetadataTool/SPT--DBEntry.php?ResourceId=${RecommendedResourceId}",
            $Resource->ScaledCumulativeRating());
}

function PrintRecommendationSources()
{
    global $User;
    global $RecommendedResourceId;
    global $ResultsPerPage;

    $ResourceCount = 0;

    # create recommender
    $Recommender =& new SPTRecommender;

    # get list of recommendation source resources
    $RecSources = $Recommender->GetSourceList(
            $User->Get("UserId"), $RecommendedResourceId);

    # for each source resource
    foreach ($RecSources as $SourceId => $CorrelationScore)
    {
        # if we have printed the max number of sources
        if ($ResourceCount > $ResultsPerPage)
        {
            # bail out
            continue;
        }
        $ResourceCount++;

        # print resource record
        $Resource =& new Resource($SourceId);
        PrintRecommendation($Resource,
                "SPT--FullRecord.php?ResourceId=${SourceId}",
                CheckEditResource( $Resource ),
                "MetadataTool/SPT--DBEntry.php?ResourceId=${SourceId}",
                $Resource->ScaledCumulativeRating());
    }
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function ParseArguments()
{
    global $_GET;
    global $ResultsPerPage;
    global $RecommendedResourceId;

    # grab ID of recommended resource
    $RecommendedResourceId = $_GET["rr"];

    # set results per page to a default for now
    $ResultsPerPage = 10;
}


# ----- MAIN -----------------------------------------------------------------

include("include/SPT--StandardHtmlPageLoad.php");

?>
