<?PHP
#
#   FILE:  SPT--CommonSearch.php
#
#   FUNCTIONS PROVIDED:
#
#       NumberOfControlledNames()
#           - return number of controlled names for a given field
#
#       NumberOfClassifications()
#           - return number of classifications for a given field
#
#       DisplayControlledNameListForName()
#           - display a ControlledName list as a multi option menu
#
#       DisplayClassificationTypeList()
#           - display list of Classification Tree types
#
#       CreateOptionListForAdvancedSearch()
#           - create an option list for the Advanced Search fields
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
# 

require_once(dirname(__FILE__)."/SPT--ControlledNameFactory.php");
require_once(dirname(__FILE__)."/SPT--ControlledName.php");

#  display a ControlledName list as a multi option menu 
function DisplayControlledNameListForName($VarName, $ControlledNameFieldName,
            $FirstEntry, $Selected, $Height, $Multi, $Search) 
{
    global $SysConfig;
    $Schema = & new MetadataSchema();

    $Field = $Schema->GetFieldByName($ControlledNameFieldName);

    # only retrieve controlled names if type found
    if (is_object($Field))
    {
        $CNFactory = & new ControlledNameFactory();
        $CNIds = $CNFactory->GetItemIds("FieldId=".$Field->Id().
                    " ORDER BY ControlledName");
    }
    $Items = array();
    reset($Items);
    if (!empty($FirstEntry) && !$Multi)
        $Items[$FirstEntry] = $FirstEntry;

    # load up array with values 
    if (count($CNIds))
    {
        foreach ($CNIds as $Id)
        {
            $CN = & new ControlledName($Id);
            $Value = GetHtmlTranslatedString($CN->Name());
            if ($Search)
                $Items[$CN->Name()] = $Value;
            else
                $Items[$Id] = $Value;
        }
    }
    # convert varname into array varname if not searching
    if ($Multi)
        $VarName = $VarName."[]";

    PrintOptionList($VarName, $Items, $Selected, "", $Height, 1, $Multi);
}

#  display a Classification list of values as an option menu
function DisplayClassificationTypeList($Selected, $SubmitOnChange = FALSE)
{
    $Schema = & new MetadataSchema();
    $Items = array();

    $Fields = $Schema->GetFields(MDFTYPE_TREE);

    foreach ($Fields as $Field)
    {
        $Items[$Field->Id()] = $Field->Name();
    }

    if ($SubmitOnChange)
        $FieldName = "Submit";
    else
        $FieldName = "F_BrowsingFieldId";
    PrintOptionList($FieldName, $Items, $Selected, $SubmitOnChange,
        1, NULL, false);
}

# create an option list for the Advanced Search fields
function CreateOptionListForAdvancedSearch($VarName, $Selected, $VarValue) 
{
    $Values = array();
    
    # Get the schema
    $Schema = & new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_TEXT | MDFTYPE_PARAGRAPH);
    foreach ($Fields as $Field)
        if ($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
            $Values[$Field->Name()] = $Field->Name();
        
    # hard code Keyword as a search type
    $Values["Keyword"] = "Keyword";
    
    $Fields = $Schema->GetFields(MDFTYPE_CONTROLLEDNAME);
    $i = 0;
    foreach ($Fields as $Field)
    {
        if ($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
        {
            # use first controlled name as default if Selected is NULL  
            if ($i == 0 && empty($Selected))
                $Selected = $Field->DBFieldName();
            $Values[$Field->Name()] = $Field->Name();
        }
        $i++;
    }

    $Fields = $Schema->GetFields(MDFTYPE_TREE);
    foreach ($Fields as $Field)
        if ($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
            $Values[$Field->Name()] = $Field->Name();

    $Fields = $Schema->GetFields(MDFTYPE_NUMBER);
    foreach ($Fields as $Field)
        if ($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool())
            && $Field->Name() != "Cumulative Rating")
            $Values[$Field->Name()] = $Field->Name();
            
    $Fields = $Schema->GetFields(MDFTYPE_IMAGE);
    foreach ($Fields as $Field)
        if ($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
            $Values[$Field->Name()] = $Field->Name();

    $Fields = $Schema->GetFields(MDFTYPE_DATE | MDFTYPE_TIMESTAMP);
    foreach ($Fields as $Field)
    {
        if ($Field->Enabled() && $Field->IncludeInAdvancedSearch() &&
            ($Field->Viewable() || InMetadataTool()))
                $Values[$Field->Name()] = $Field->Name();
    }                
            
    echo "<select name=\"".$VarName."\" size=1>\n";
    $i=0;
    foreach ($Values as $Value => $Name)
    {
        echo "<option value=\"".$Value."\"";
        if (isset($VarValue) && $VarValue == $Value)
            echo " selected";
        else if ($Name == $Selected && !isset($VarValue))
            echo " selected";
        echo ">".$Name."</option>\n";
        $i++;
    }
    echo "</select>\n";
}


function PrintFrequencyOptionList( $FieldName="F_Frequency", $Selected="Never", $SubmitOnChange=false)
{

    global $User;
    $FrequencyList = Array("Never" => "Never", 
            "Quarterly" => "Quarterly",
            "Bi-monthly" => "Bi-monthly",
            "Once a month" => "Once a month",
            "Bi-weekly" => "Bi-weekly",
            "Once a week" => "Once a week",
            "Once a day" => "Once a day");
    if ($User->HasPriv(PRIV_RESOURCEADMIN))
    {
        $FrequencyList["Hourly"] = "Hourly";
    }
            
    PrintOptionList($FieldName, $FrequencyList, $Selected, $SubmitOnChange);

}
?>
