<?php

#
#   FILE:  SPT--EditUserComplete.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       F_RealName
#       F_EMail
#       F_WebSite
#       F_AddressLineOne
#       F_AddressLineTwo
#       F_City
#       F_State
#       F_ZipCode
#       F_Country
#           - new values for user record
#       F_Privileges
#           - array containing new privileges for user record
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");

# ----- LOCAL ----------------------------------------------------------------

function IsEditingOwnAccount()
{
    global $User;

    # user is logged in and is not SYSADMIN or USERADMIN
    if ((!$User->HasPriv(PRIV_SYSADMIN) &&
        !$User->HasPriv(PRIV_USERADMIN)) &&
        $User->IsLoggedIn() == TRUE)
        return TRUE;
    else
        return FALSE;
}

# ----- MAIN -----------------------------------------------------------------

if (isset($_POST["F_Privileges"]))
    $F_Privileges = $_POST["F_Privileges"]; 
if (isset($POST["F_UserDisabled"]))
    $F_UserDisabled = $_POST["F_UserDisabled"];
else
    $F_UserDisabled = FALSE;
if (isset($_POST["F_RealName"]))
    $F_RealName = $_POST["F_RealName"];
if (isset($_POST["F_Email"]))
    $F_Email = $_POST["F_Email"];
if (isset($_POST["F_WebSite"]))
    $F_WebSite = $_POST["F_WebSite"];
if (isset($_POST["F_AddressLineOne"]))
    $F_AddressLineOne = $_POST["F_AddressLineOne"];
if (isset($_POST["F_AddressLineTwo"]))
    $F_AddressLineTwo = $_POST["F_AddressLineTwo"];
if (isset($_POST["F_City"]))
    $F_City = $_POST["F_City"];
if (isset($_POST["F_State"]))
    $F_State = $_POST["F_State"];
if (isset($_POST["F_ZipCode"]))
    $F_ZipCode = $_POST["F_ZipCode"];
if (isset($_POST["F_Country"]))
    $F_Country = $_POST["F_Country"];

# allow user to edit his/her own info
if (!IsEditingOwnAccount())
    CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN);

# if submit button pushed
if ($SubmitResult == "Save Changes")
{
    # pull up record of user being edited
    $UserToEdit = new User($DB, (int)$Session->Get("IdOfUserBeingEdited"));
    $Session->UnregisterVariable("IdOfUserBeingEdited");

    # if record was found
    if ($UserToEdit->Status() == U_OKAY)
    {
        # don't allow non sysadmin to turn off sysadmin, user for a sysadmin
        if ($UserToEdit->HasPriv(PRIV_SYSADMIN) && 
            $User->HasPriv(PRIV_USERADMIN) && !$User->HasPriv(PRIV_SYSADMIN))
        {
            $F_Privileges[] = PRIV_SYSADMIN;
            $F_Privileges[] = PRIV_USERADMIN;
        }

        # don't allow sysadmin turn off sysadmin, user for himself
        if ($UserToEdit->Get("UserId") == $User->Get("UserId") &&
            $User->HasPriv(PRIV_SYSADMIN))
        {
            $F_Privileges[] = PRIV_SYSADMIN;
            $F_Privileges[] = PRIV_USERADMIN;
        }

        # don't allow user to disable their own account
        if ($UserToEdit->Get("UserId") != $User->Get("UserId"))
        {
            if ($F_UserDisabled)
                $F_Privileges[] = PRIV_USERDISABLED;
            else
                $UserToEdit->RevokePriv(PRIV_USERDISABLED);
        }

        # save new user settings
        $UserToEdit->Set("RealName", $F_RealName);
        $UserToEdit->Set("EMail", $F_EMail);
        $UserToEdit->Set("WebSite", $F_WebSite);
        $UserToEdit->Set("AddressLineOne", $F_AddressLineOne);
        $UserToEdit->Set("AddressLineTwo", $F_AddressLineTwo);
        $UserToEdit->Set("City", $F_City);
        $UserToEdit->Set("State", $F_State);
        $UserToEdit->Set("ZipCode", $F_ZipCode);
        $UserToEdit->Set("Country", $F_Country);

        # head home if user editing own account 
        if (IsEditingOwnAccount()) 
            PrintAutoRefreshPage("Home", "SPT--Home.php");
        # otherwise set privileges and head back to user edit page
        else
        {
            if (is_array($F_Privileges))
                $UserToEdit->SetPrivList($F_Privileges);
            PrintAutoRefreshPage("Edit User Account", 
                "SPT--SelectEditUser.php");
        }
    }
    else
    {
        # put up error message
        ErrorOut("Could not find user record being edited");
    }
}
else
{
    # return to front page
    PrintAutoRefreshPage("Aborting User Editing", "SPT--SelectEditUser.php");
}

?>
