<?PHP
#
#   FILE:  SPT--ResendAccountActivation.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2006 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("");


# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

# retrieve user name or e-mail address from URL or form
if (isset($_GET["UN"]) && strlen(trim($_GET["UN"])))
{
    $G_UserName = $_GET["UN"];
}
elseif (isset($_POST["F_UserName"])
        && strlen(trim($_POST["F_UserName"])))
{
    $G_UserName = $_POST["F_UserName"];
}
if (isset($_GET["EM"]) && strlen(trim($_GET["EM"])))
{
    $G_EMailAddress = $_GET["EM"];
}
elseif (isset($_POST["F_EMailAddress"])
        && strlen(trim($_POST["F_EMailAddress"])))
{
    $G_EMailAddress = $_POST["F_EMailAddress"];
}

# values intended for use in HTML
$G_EMailAddressUsed = FALSE;
$G_UserFound = FALSE;
$G_EMailSent = FALSE;
$G_AccountAlreadyActivated = FALSE;

# if user name was supplied
$TargetUser = NULL;
if (strlen($G_UserName))
{
    # attempt to find user with specified name
    $G_UserName = User::NormalizeUserName($G_UserName);
    $TargetUser = new SPTUser($G_UserName);
}
# else if e-mail address was supplied
elseif (strlen($G_EMailAddress))
{
    # attempt to find user with specified e-mail address
    $Factory = new UserFactory($DB);
    $G_EMailAddress = User::NormalizeEMailAddress($G_EMailAddress); 
    $TargetUser = $Factory->GetMatchingUsers($G_EMailAddress, "EMail");

    # set flag indicating that we used e-mail address
    $G_EMailAddressUsed = TRUE;
}

# if requested user was found
if ($TargetUser && ($TargetUser->Status() == U_OKAY))
{
    # set flag indicating that user was found
    $G_UserFound = TRUE;

    # if user account was already activated
    if ($TargetUser->IsActivated())
    {
        # set flag indicating account already activated
        $G_AccountAlreadyActivated = TRUE;
    }
    else
    {
        # send activation e-mail
        $ActivationUrlParameters = "?UN=".urlencode($TargetUser->Get("UserName"))
                ."&AC=".$TargetUser->GetActivationCode();
        $ActivationUrl = "http://".$_SERVER["SERVER_NAME"]
                .str_replace("ResendAccountActivation", "ActivateAccount",
                $_SERVER["REQUEST_URI"]).$ActivationUrlParameters;
        $ManualActivationUrl = "http://".$_SERVER["SERVER_NAME"]
                .str_replace("ResendAccountActivation",
                "ManuallyActivateAccount", $_SERVER["REQUEST_URI"]);
        $OurSubstitutions = array(
                "X-PORTALNAME-X" => $SysConfig->PortalName(),
                "X-ACTIVATIONURL-X" => $ActivationUrl,
                "X-ACTIVATIONPARAMETERS-X" => $ActivationUrlParameters,
                "X-MANUALACTIVATIONURL-X" => $ManualActivationUrl,
                );
        $MailTemplate = $SysConfig->PasswordMailSubject()."\n"
                .$SysConfig->PasswordMailBody();
        $FromAddress = $SysConfig->PortalName()." <".$SysConfig->AdminEmail().">";
        $TargetUser->SendEMail($MailTemplate, $FromAddress, $OurSubstitutions);
        $G_EMailErrorCode = $TargetUser->Status();
        $G_EMailSent = ($G_EMailErrorCode == U_OKAY) ? TRUE : FALSE;
    }
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
