<?php

#
#   FILE:  SPT--ImportData.php
#
#   FUNCTIONS PROVIDED:
#       PrintErrorMessage()
#           - print an error message
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--MetadataSchema.php");

function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

function PrintUniqueFieldList()
{
    $Values = array();

    # first entry is empty 
    $Values["-1"] = "None Selected";
    
    # Get the schema
    $Schema = & new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(
                MDFTYPE_TEXT | MDFTYPE_PARAGRAPH | MDFTYPE_NUMBER);
    foreach ($Fields as $Field)
        if ($Field->Enabled()) 
            $Values[$Field->Name()] = $Field->Name();
        
    PrintOptionList("F_UniqueField", $Values, "-1", NULL, 1, NULL, false);


}


require_once("include/SPT--Common.php");
PageTitle("Import Data");
$NavDirCorrection = "../";

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

include("include/SPT--StandardHtmlPageLoad.php");


?>
