<?php
#
#   FILE:  SPT--ImportDataExecute.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ControlledName.php");
require_once("include/SPT--SPTDate.php");
require_once("include/SPT--ResourceFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# print debug info
function PrintDebugInfo()
{
    global $DebugInfo;

    print $DebugInfo;
}

# add in new controlled name if needed
function AddControlledName($Field, $Value)
{
    global $ControlledNameCount, $Session;

    $Value = trim($Value);
    if (!empty($Value))
    {
        $ControlledName = & new ControlledName(NULL, $Value, $Field->Id());
        $Value = $ControlledName->Id();
        if ($ControlledName->Status() != CNSTAT_EXISTS)
        {
            $ControlledNameCount++;
        }
    }
    return $Value;
}

# add in a new classification if needed
function AddClassification($Field, $Value)
{
    global $ClassificationCount, $Session;

    $Value = trim($Value);
    if (!empty($Value))
    {
        $Classification = & new Classification(NULL, $Value, $Field->Id());
        $Value = $Classification->Id();

        if ($Classification->Status() == CLASSSTAT_OK)
        {
            $ClassificationCount += $Classification->SegmentsCreated();
        }
    }
    return $Value;
}

# init variables -- first time thru they will be null
function InitImportVars()
{
    global $ImportComplete, $FSeek, $ResourceCount;
    global $ControlledNameCount, $ClassificationCount;

    if (is_null($ImportComplete))
        $ImportComplete = 0;
    if (is_null($FSeek))
        $FSeek = 0;
    if (is_null($ResourceCount))
        $ResourceCount = 0;
    if (is_null($ControlledNameCount))
        $ControlledNameCount = 0;
    if (is_null($ClassificationCount))
        $ClassificationCount = 0;
}

# first time through, create empty placeholders
function FirstTimeThrough()
{
    global $TotalLineCount, $FSeek;
    global $fp, $NameArray;
    global $Session, $NumberOfFields, $Debug, $DebugInfo;
    global $ImportComplete;

    $Schema = & new MetadataSchema();

    # read in line from import file
    $fline = fgets($fp, 4096);
    $FSeek += strlen($fline);

    if ($Debug)
        $DebugInfo .= "fline=$fline<br>";

    # parse line from import file
    $Vars = explode("\t", $fline);

    $NumberOfFields = 0;
    foreach ($Vars as $Var)
    {
        $Var = trim($Var);

        # old style import files
        if ($Var != "ControlledName" &&
            $Var != "ControlledNameTypeName" &&
            $Var != "ClassificationName" &&
            $Var != "ClassificationTypeId")
        {
            $Field = $Schema->GetFieldByName($Var);
            if (is_null($Field))
            {
                $Session->PassVariable("ImportComplete", $ImportComplete);
                $ErrorMessage =
                    "Error: Unknown metadata field name = \"".$Var.
                    "\" encountered.<br>".
                    "This must match the field name ".
                    "in the Metadata Field Editor.<br>".
                    "Please select Back and correct the problem ".
                    "on the first line.";
                $Session->PassVariable("ErrorMessage", $ErrorMessage);
                PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
                $ImportComplete = 1;
                $FSeek = 0;
                exit;
            }
            # save field object and field name
            $NameArray[] = $Var;
        }
        # save names for ControlledName or Classification
        else
        {
            $NameArray[] = $Var;
        }
        $NumberOfFields++;
    }

    # count the first header line
    $TotalLineCount = 1;
}

# do/while loop, this is the main event
function DoWhileLoop()
{
    global $fp, $Session, $FSeek, $UniqueFieldValue, $ImportComplete;
    global $User, $ResourceCount, $ControlledNameCount, $ClassificationCount;
    global $TotalLineCount, $ReleaseFlag, $User, $UniqueField;
    global $NumberOfFields, $Debug, $DebugInfo, $SysConfig, $NameArray;

    $Schema = & new MetadataSchema();
    $RFactory =& new ResourceFactory();

    $LineCount = 0;
    $Resource = NULL;
    $LastUniqueFieldValue = NULL;
    $UniqueFieldValue = NULL;

    # user current user for AddedById, LastModifiedById
    # current date for DateOfRecordCreation
    $CurrentUserId = $User->Get("UserId");
    $TodaysDate = date("Y-m-d H:i:s");

    while (!feof($fp) && $LineCount < 50 && $ImportComplete == 0)
    {
        # read in line from import file
        $fline = fgets($fp, 2000000);

        # update variables
        $LineCount++;
        $TotalLineCount++;

        if ($Debug)
            $DebugInfo .= "Line $TotalLineCount: fline=$fline<br>";

        $FSeek += strlen($fline);
        $Session->PassVariable("FSeek", $FSeek);

        $ValueArray = array();

        # parse line from import file
        $Vars = explode("\t", $fline);

        # bail out if line was empty or end of file encountered
        $NumberOfVars = count($Vars);
        if ($NumberOfVars < 1 || feof($fp))
        {
            $ImportComplete = 1;
            break;
        }

        # make sure number of vars on line match number of fields in header
        if ($NumberOfVars != $NumberOfFields)
        {
            $Session->PassVariable("ImportComplete", $ImportComplete);
            $ErrorMessage =
                "Error: incorrect field count on line $TotalLineCount.<br>".
                "Expected $NumberOfFields, encountered $NumberOfVars<br>".
                "Correct the problem and try importing again.<br>";
            $Session->PassVariable("ErrorMessage", $ErrorMessage);
            PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
            $ImportComplete = 1;
            $FSeek = 0;
            exit;
        }

        # process each var and cache it's value
        foreach ($Vars as $Index => $Var)
        {
            # translate backslashed tabs and newlines
            $Var = str_replace(array('\t', '\n'),
                               array("\t", "\n"),
                               $Var);

            $Field = $Schema->GetFieldByName($NameArray[$Index]);
            if (is_object($Field))
            {
                if ($Field->Type() == MDFTYPE_CONTROLLEDNAME ||
                    $Field->Type() == MDFTYPE_OPTION)
                {
                    # create new controlled name if needed, replace alpha value
                    $Var = AddControlledName($Field, $Var);
                }
                else if ($Field->Type() == MDFTYPE_TREE)
                {
                    # create new classification if needed, replace alpha value
                    $Var = AddClassification($Field, $Var);
                }
                $FieldArray[$Index] = $Field;
                $ValueArray[$Field->Id()] = $Var;
            }
            else
                $SpecialArray[$Index] = trim($Var);
        }

        # old format with ControlledName/ControlleNameTypeName pairs
        $Key = array_search("ControlledName", $NameArray);
        if ($Key !== FALSE && !is_null($Key))
        {
            $Value = $SpecialArray[$Key];
            $Key = array_search("ControlledNameTypeName", $NameArray);
            $Field = $Schema->GetFieldByName($SpecialArray[$Key]);
            if (is_object($Field))
            {
                $Value = AddControlledName($Field, $Value);
                $ValueArray[$Field->Id()] = $Value;
            }
        }

        # old format with ClassificationName/ClassificationTypeId pairs
        $Key = array_search("ClassificationName", $NameArray);
        if ($Key !== FALSE && !is_null($Key))
        {
            $Value = $SpecialArray[$Key];
            $Key = array_search("ClassificationTypeId", $NameArray);

            # compensate for bad data (missing type id)
            if (!is_numeric($SpecialArray[$Key]))
                $SpecialArray[$Key] = $SysConfig->BrowsingFieldId();

            $Field = $Schema->GetFieldByName($SpecialArray[$Key]);
            if (is_object($Field))
            {
                $Value = AddClassification($Field, $Value);
                $ValueArray[$Field->Id()] = $Value;
            }
        }

        # grab the UniqueField and Description values from the array
        $UniqueFieldKey = array_search($UniqueField, $NameArray);
        if ($UniqueFieldKey !== FALSE && !is_null($UniqueFieldKey))
        {
            $Field = $FieldArray[$UniqueFieldKey];
            $UniqueFieldValue = addslashes($ValueArray[$Field->Id()]);
            $UniqueFieldDBName = $Field->DBFieldName();
        }
        $DescriptionKey = array_search("Description", $NameArray);
        if ($DescriptionKey !== FALSE && !is_null($DescriptionKey))
        {
            $Field = $FieldArray[$DescriptionKey];
            $Description = addslashes($ValueArray[$Field->Id()]);
        }

        if ($Debug)
            $DebugInfo .= "$UniqueField = $UniqueFieldValue<br>";

        if (!empty($UniqueFieldValue) &&
                $UniqueFieldValue != $LastUniqueFieldValue)
        {
            if ($UniqueField == "Title")
                $Resources = $RFactory->GetItemIds("$UniqueFieldDBName=\"".
                    $UniqueFieldValue.
                    "\" AND Description=\"".$Description."\"");
            else
                $Resources = $RFactory->GetItemIds("$UniqueFieldDBName=\"".
                    $UniqueFieldValue."\"");

            if (count($Resources) == 0)
            {
                # create new temporary field
                $Resource = & new Resource();

                # handle special fields

                if (array_search("Added By Id", $NameArray) === FALSE)
                {
                    $Resource->Set("Added By Id", $CurrentUserId);
                }

                if (array_search("Last Modified By Id", $NameArray) === FALSE)
                {
                    $Resource->Set("Last Modified By Id", $CurrentUserId);
                }

                $Key = array_search("Date Of Record Creation", $NameArray);
                if ($Key === FALSE)
                {
                    $Resource->Set("Date Of Record Creation", $TodaysDate);
                }
                else
                {
                    $Field = $FieldArray[$Key];
                    $DORC = explode(" ", $ValueArray[$Field->Id()]);
                    $Date = & new SPTDate($DORC[0]);
                    $DateBegin = $Date->BeginDate();
                    $Resource->Set("Date Of Record Creation", $DateBegin);
                }

                $Key = array_search("Date Last Modified", $NameArray);
                if ($Key == FALSE)
                {
                    $Resource->Set("Date Last Modified", $TodaysDate);
                }
                else
                {
                    $Field = $FieldArray[$Key];
                    $DORC = explode(" ", $ValueArray[$Field->Id()]);
                    $Date = & new SPTDate($DORC[0]);
                    $DateBegin = $Date->BeginDate();
                    $Resource->Set("Date Last Modified", $DateBegin);
                }

                # convert to real resource
                $Resource->IsTempResource(FALSE);
                $ResourceId = $Resource->Id();

                if ($Debug)
                    $DebugInfo .= "ResourceId = $ResourceId<br>";

                # keep track of number of resources added
                $ResourceCount++;
                $Session->PassVariable("ResourceCount", $ResourceCount);

                # cache the last title
                $LastUniqueFieldValue = $UniqueFieldValue;
            }
            # this resource already exists
            else if (count($Resources) == 1)
            {
                # should only be one matching Resources record
                $ResourceId = $Resources[0];
                $Resource = & new Resource($ResourceId);
            }
            # duplicate resources exist!
            else if (count($Resources) > 1)
            {
                $Session->PassVariable("ImportComplete", $ImportComplete);
                $ErrorMessage =
                    "Error: Multiple Resources with $UniqueField = \"".
                        $UniqueFieldValue.
                    "\" encountered.<br>".
                    "Please select Back and correct the problem on line ".
                    $TotalLineCount.".";
                $Session->PassVariable("ErrorMessage", $ErrorMessage);
                PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
                $ImportComplete = 1;
                $FSeek = 0;
                exit;
            }
        }

        # Deal with release flag setting
        $Key = array_search("Release Flag", $NameArray);
        if ($ReleaseFlag != -1 || $Key === FALSE)
        {
            # Asked not to use value in file, or file doesn't have such a value
            if (is_object($Resource))
            {
                $Resource->Set("Release Flag", $ReleaseFlag);

                #Blow away the file value, if it exists
                if ($Key !== FALSE)
                {
                    $Field = $FieldArray[$Key];
                    $ValueArray[$Field->Id()] = 0;
                }
            }
        }

        # now set each Resource field
        foreach ($ValueArray as $FieldId => $Value)
        {
            if (!empty($Value))
            {
                if (is_object($Resource))
                {
                    if ($Debug)
                        $DebugInfo .= "ResourceId=".$Resource->Id().
                            ": Setting FieldId $FieldId to $Value<br>";
                    $Resource->SetByFieldId($FieldId, $Value);
                }
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# retrieve current time so that page generation time can be calculated accurately
$PageGenerationBeginTime = getmicrotime();

$NavDirCorrection = "../";

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

# load up passed thru vars
$FSeek = $Session->Get("FSeek");
if(isset($_POST["ReleaseFlag"]))
{
    $ReleaseFlag = $_POST["ReleaseFlag"];
}
else
    $ReleaseFlag = $Session->Get("ReleaseFlag");

$ImportComplete = $Session->Get("ImportComplete");
$ResourceCount = $Session->Get("ResourceCount");
$ControlledNameCount = $Session->Get("ControlledNameCount");
$ClassificationCount = $Session->Get("ClassificationCount");
$TotalLineCount = $Session->Get("TotalLineCount");
$NameArray = $Session->Get("NameArray");
$FSeek = $Session->Get("FSeek");
$TempFile = $Session->Get("TempFile");
$NumberOfFields = $Session->Get("NumberOfFields");
$UniqueField = $Session->Get("UniqueField");

if (isset($_POST["F_UniqueField"]) &&
    $_POST["F_UniqueField"] != "-1")
{
    $UniqueField = $_POST["F_UniqueField"];
}
else if (is_null($UniqueField))
    $UniqueField = "Title";

InitImportVars();

# check for Cancel button
if (isset($_POST["Submit"]) && $_POST["Submit"] == "Cancel")
{
    $ImportComplete = 1;
    PrintAutoRefreshPage("System Administration",
        $NavDirCorrection."SPT--SysAdmin.php");
    exit;
}

if (isset($_POST["Debug"]))
    $Debug = $_POST["Debug"];
else
    $Debug = $Session->Get("Debug");

# open import file for reading
if (isset($_FILES['F_FileName']['tmp_name']) &&
    is_uploaded_file($_FILES['F_FileName']['tmp_name']))
{
    if ($Debug)
        $DebugInfo = "filename=".$_FILES['F_FileName']['tmp_name'].
            "<br>";

    # zero length or tiny file
    if ($_FILES['F_FileName']['size'] == 0)
    {
        $ErrorMessage = "Error: File doesn't exist or is empty.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
        exit;
    }

    $ScriptFileName = isset($_SERVER["PATH_TRANSLATED"]) ? $_SERVER['PATH_TRANSLATED']
            : (isset($_SERVER["SCRIPT_FILENAME"]) ? $_SERVER["SCRIPT_FILENAME"]
            : (isset($_SERVER["PATH_INFO"]) ? $_SERVER["PATH_INFO"]
            : exit("ERROR: unable to determine current file name")));

    $TempDir = dirname($ScriptFileName).
        "/".$NavDirCorrection."TempStorage";
    $TempDir = realpath($TempDir)."/";

    # make sure destination dir exists
    if (!file_exists($TempDir))
    {
        $ErrorMessage = "Error: Destination directory ".$TempDir.
                        " doesn't exist.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
        exit;
    }

    # make sure destination dir is writable
    if (!is_writable($TempDir))
    {
        $ErrorMessage = "Error: Destination directory ".$TempDir.
                        " is not writable.";
        $Session->PassVariable("ErrorMessage", $ErrorMessage);
        PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
        exit;
    }

    $TempFile = dirname($ScriptFileName).
        "/".$NavDirCorrection."TempStorage/".
        $_FILES['F_FileName']['name'];

    copy($_FILES['F_FileName']['tmp_name'], $TempFile);
    $fp = fopen($TempFile, 'r');
    unlink($_FILES['F_FileName']['tmp_name']);
}
else if ($FSeek > 0)
{
    $fp = fopen($TempFile, 'r');
}
else
{
    switch($_FILES['F_FileName']['error'])
    {
        # no error; possible file attack!
        case 0:
            $ErrorMessage = "There was a problem with your upload.";
            break;

        # uploaded file exceeds the upload_max_filesize directive in php.ini
        case 1:
            $ErrorMessage = "The file you are trying to upload is too big.";
            break;

        # uploaded file exceeds the MAX_FILE_SIZE directive that
        # was specified in the html form
        case 2:
            $ErrorMessage = "The file you are trying to upload is too big.";
            break;

        # uploaded file was only partially uploaded
        case 3:
            $ErrorMessage =
                "The file you are trying upload was only partially uploaded.";
            break;

        # no file was uploaded
        case 4:
            $ErrorMessage = "You must select a file for upload.";
            break;

        # a default error, just in case!
        default:
            $ErrorMessage .= "There was a problem with your upload.  ("
                    .$_FILES['F_FileName']['error'].")";
            break;
    }
    $Session->PassVariable("ErrorMessage", $ErrorMessage);
    PrintAutoRefreshPage("Import Data", "SPT--ImportData.php");
    exit;
}

# first time through
if ($FSeek == 0)
{
    FirstTimeThrough();
}

# echo "FSeek=$FSeek, FileName=$F_FileName<br>";

# seek to the next line
if ($FSeek > 0)
{
    fseek($fp, $FSeek);
}

# the main work happenes here
DoWhileLoop();

# end of file reached?
if (feof($fp))
{
    $ImportComplete = 1;
}
# register some key variables for other html code
$Session->PassVariable("ReleaseFlag", $ReleaseFlag);
$Session->PassVariable("ImportComplete", $ImportComplete);
$Session->PassVariable("ResourceCount", $ResourceCount);
$Session->PassVariable("ControlledNameCount", $ControlledNameCount);
$Session->PassVariable("ClassificationCount", $ClassificationCount);
$Session->PassVariable("TotalLineCount", $TotalLineCount);
$Session->PassVariable("NameArray", $NameArray);
$Session->PassVariable("FSeek", $FSeek);
$Session->PassVariable("TempFile", $TempFile);
$Session->PassVariable("NumberOfFields", $NumberOfFields);
$Session->PassVariable("UniqueField", $UniqueField);
$Session->PassVariable("Debug", $Debug);

#  Time to auto-refresh?
if ($ImportComplete == 0)
{
    $AutoRefreshToPage = "SPT--ImportDataExecute.php";
}

PageTitle("Import Data");
$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");

if ($ImportComplete == 1)
{
    fclose($fp);
    # remove temporary uploaded file
    unlink($TempFile);
}

?>
