<?php
#
#   FILE:  SPT--DBPopulateTree.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# if F_FieldType is -1, then came here from DBEditor screen

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

function PrintFieldName()
{
    global $F_FieldId, $Schema;

    # get the field 
    $Field = $Schema->GetField($F_FieldId);
    $FieldName = $Field->Name();

    if (isset($FieldName))
        print $FieldName;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$Schema = & new MetadataSchema();
$F_FieldId = $Schema->GetCurrentEditedItemId();

include("include/SPT--StandardHtmlPageLoad.php");

?>
