<?PHP
#
#   FILE:  SPT--HowToCustomize.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("User Interface Customization");

function App()
{
    print(SoftwareIsCWIS() ? "CWIS" : "SPT");
}

include(FindUIFile("include/SPT--StandardPageStart.html"));

?>

&nbsp;
<h1>User Interface Customization</h1>

<p>To support multiple user interfaces and user interface customization,
the CWIS code base is split into distinct <b>PHP</b> and <b>HTML</b> sets of files.
The <i>.html</i> files contain HTML and PHP relating to the look and feel of
CWIS, and the <i>.php</i> files contain everything else (i.e. functionality).</p>

<a href="#AddingAnInterface">Adding a New User Interface</a><br>
<a href="#CustomizingOverall">Customizing the Overall Look and Feel</a><br>
<a href="#CustomizingSpecificPage">Customizing a Specific Page</a><br>
<a href="#AddNewPage">Adding a New Page</a><br>
<br>

<br><hr width="80%">


<a name="AddingAnInterface"></a>
<h2>Adding a New User Interface</h2>

<p>To add a new user interface to your CWIS-based site, all you need to do is go into
the top directory on your site and run the CWIS new interface creation script:</p>

    <blockquote><code>
        cd MyPortalHome<br>
        ./newinterface
    </code></blockquote>
    
<p>(Where <i>MyPortalHome</i> is name of the directory where you installed CWIS.)</p>

<p>The <i>newinterface</i> script will ask you for the name you want to give
to your new user interface, and then create the necessary files and directories.
After you've run <i>newinterface</i>, log into your CWIS site and make sure
that your new user interface shows up in the <i>Default User Interface</i> list
on the <i>Edit System Configuration</i> screen.</p>

<br><hr width="80%">


<a name="CustomizingOverall"></a>
<h2>Customizing the Overall Look and Feel</h2>

<p>Customizing a CWIS-based site can be broken down into two
phases:  changing the <b>overall</b> look and feel, and changing the
look and feel of <b>individual pages</b>.</p>

<p>For the <b>overall</b> look and feel of a CWIS-based site, there
are three files that contain almost all of the common page elements and
appearance settings:  <i>SPT--StandardPageStart.html</i>, <i>SPT--StandardPageEnd.html</i>,
and <i>SPT--Stylesheet.css</i>.</p>

<p>As their names might suggest, <i>SPT--StandardPageStart.html</i> and
<i>SPT--StandardPageEnd.html</i> contain the common page elements that appear at
the top/left and bottom/right, respectively, of most pages.  Any changes made to
those files will appear on all CWIS-based pages on your site.  </p>

<p><i>SPT--Stylesheet.css</i> contains the CSS (Cascading Style Sheet) attributes
for the site (text color, font size, etc).  Again, changes made to this file will
affect all CWIS-based pages.</p>

<p>All three of these files can be found in the <i>include</i> subdirectory under
your new interface directory (that you created by running <i>newinterface</i> as directed
above).</p>

<br><hr width="80%">


<a name="CustomizingSpecificPage"></a>
<h2>Customizing a Specific Page</h2>

<p>Customizing <b>individual pages</b> on a CWIS-based site involves four steps:</p>

<ol>
    <li>identify the file containing the HTML or CSS that you want to change,</li>
    <li>copy the file from the default interface directory (<i>SPTUI--CWIS</i>)
        to your new interface directory (created when you ran the <i>newinterface</i>
        script as directed above),</li>
    <li>set the file permissions to make sure it can be edited, and</li>
    <li>edit the new file to customize the page.</li>
</ol>

<p>To identify the HTML file for the page you want to customize, look at the
URL for the page to determine the file, and then replace the <i>.php</i>
ending with <i>.html</i> to get the file name.  For example, if the URL
for the page is <b><i>http://www.mycwisportal.org/SPT--BrowseResources.php</i></b>,
then the file name would be <b><i>SPT--BrowseResources.html</i></b>.</p>

<p>If the URL contains <b><i>MetadataTool</i></b> (e.g. 
<i>http://www.mycwisportal.org/MetadataTool/SPT--AddClassification.php</i>),
then you would find the file in the <i>MetadataTool</i> subdirectory under
<i>SPTUI--CWIS</i>, and copy it into the <i>MetadataTool</i> subdirectory in
the new interface directory.<p>

<p>To copy the file, use the <b><i>cp</i></b> command:</p>

    <blockquote><code>
        cp SPTUI--CWIS/SPT--PageImEditing.html SPTUI--MyNewInterface/.
    </code></blockquote>

<p>where <i>SPTUI--MyNewInterface</i> is the new interface directory you
created, and <i>SPT--PageImEditing.html</i> is the HTML file you identified.</p>

<p>To set the file permissions, use the <b><i>chmod</i></b> command:</p>

    <blockquote><code>
        chmod u+w SPTUI--MyNewInterface/SPT--PageImEditing.html
    </code></blockquote>

<p>where <i>SPTUI--MyNewInterface</i> is the new interface directory you
created, and <i>SPT--PageImEditing.html</i> is the new HTML file.</p>

<p>Please note:  You do <b>not</b> need to copy every page into your
new interface directory;  if CWIS doesn't find an HTML file for a page in
your new interface directory, it will use the HTML file from
SPTUI--CWIS.</p>

<br><hr width="80%">


<a name="AddNewPage"></a>
<h2>Adding a New Page</h2>

<p>Adding a new page (with static content) to a CWIS-based site involves five steps:</p>

<ol>
    <li>determine the file name of your new page,</li>
    <li>copy the new page template file (<i>SPT--NewPageTemplate.php</i>) to your new page file,</li>
    <li>set the file permissions to make sure the new page file can be edited,</li>
    <li>edit the new page file to add in page content, and</li>
    <li>add a link somewhere on your site to let people get to the new page.</li>
</ol>

<h3>Determining the File Name</h3>

<p>There are two parts to determining the file name for your new page:  selecting a
common prefix you'll use on your site, and selecting a specific name for the new page.</p>

<p>For the common prefix, a short acronym (e.g. <i>EEP</i> if your site is the "Engineering Exhibition
Portal") is usually a good choice.  The common prefix will be useful in distinguishing
your local pages from those distributed with the CWIS package, both for your own use and
to prevent collisions when upgrading your CWIS software.</p>

<p>For the specific name for the
new page, choose something logical and mnemonic and no more than two or three words (e.g.
<i>Engineering Standards</i> or <i>About Exhibition Halls</i>).</p>

<p>Once you have your common prefix
and specific page name, concatenate them together with <i>--</i> and <i>.php</i> to create the name
of the file that will contain the content for your new page (e.g. <i>EEP--EngineeringStandards.php</i>,
<i>EEP--AboutExhibitionHalls.php</i>).  Don't include any spaces in your file name,
and other than <i>--</i> and the <i>.php</i>, do not include any punctuation in your
file name.</p>

<h3>Creating the File</h3>

<p>To copy the page template, use the <b><i>cp</i></b> command:</p>

    <blockquote><code>
        cp SPT--NewPageTemplate EEP--AboutExhibitionHalls.php
    </code></blockquote>

<p>where <i>EEP--AboutExhibitionHalls.php</i> is the file name for the new page
(that you determined above).</p>

<p>To set the file permissions, use the <b><i>chmod</i></b> command:</p>

    <blockquote><code>
        chmod u+w EEP--AboutExhibitionHalls.php
    </code></blockquote>

<p>where <i>EEP--AboutExhibitionHalls.php</i> is (again) the file name for the new page.</p>

<h3>Adding Page Content</h3>

<p>Once you have the file created for the new page, you can go ahead and edit the file
to add in the page content.</p>
<p>You'll also need to set a page title in the file, by
replacing the text <i>PAGE TITLE GOES HERE</i> on line 8 with your title.  (If you include
any quotation marks (<i>"</i>) in your title precede them with a backslash, or it'll cause
a PHP syntax error.)</p>

<br>
<?PHP  include(FindUIFile("include/SPT--StandardPageEnd.html"));  ?>

