<?PHP
#
#   FILE:  SPT--SysStyle.php
#
#   FUNCTIONS PROVIDED:
#       GetCurrentColorValue($FormFieldName)
#           - returns current value for color
#       PrintColorOptionList($FormFieldName)
#           - prints HTML for colors option list
#       ErrorsWereFound()
#           - returns TRUE if errors were found by SPT--SysStyleComplete
#       PrintErrorMessagesAsUList()
#           - prints unordered list of error messages (if any)
#       FormFieldHadError($FormFieldName)
#           - returns TRUE if error was detected for field with specified name
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("Customize System Apperance");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function GetCurrentColorValue($FormFieldName)
{
    global $DB;
    static $DBValues;

    # define form fields and corresponding database fields
    # (must match table in SPT--SysStyleComplete.php)
    $FieldMappings = array(
        "F_BodyCol"         => "PageCenterBackground",
        "F_PCol"            => "PageSideBackground",
        "F_SPTColorHeader"  => "SPTTableHeaderBackground",
        "F_ColorHeader"     => "MDTTableHeaderBackground",
        "F_LightBody"       => "TableBodyBackground",
        "F_ForumTh"         => "ForumDarkHeaderBackground",
        "F_ForumThLight"    => "ForumLightHeaderBackground",
        "F_ForumBack"       => "ForumBodyBackground",
        "F_NavBoxBack"		=> "NavBoxBackground",
        "F_HomeBoxBack"		=> "HomeBoxBackground",
        );

    # if we don't already have values from database
    if (!isset($DBValues))
    {
        # load values from database
        $DB->Query("SELECT * FROM UIStyleConfiguration");
        $DBValues = $DB->FetchRow();
    }

    # return mapped value
    return $DBValues[$FieldMappings[$FormFieldName]];
}

function PrintColorOptionList($FormFieldName)
{
    # define default color list
    $DefaultColors = array(
            "F_BodyCol"         => "#FFFFFF",
            "F_PCol"            => "#EEEEEE",
            "F_SPTColorHeader"  => "#DDEEFF",
            "F_ColorHeader"     => "#DDFFDD",
            "F_LightBody"       => "#F5F5F5",
            "F_ForumTh"         => "#000066",
            "F_ForumThLight"    => "#336699",
            "F_ForumBack"       => "#EEEEEE",
            "F_NavBoxBack"		=> "#F8F8F8",
            "F_HomeBoxBack"		=> "#F0F0F0",
            );
    $ColorList = array(
            $DefaultColors[$FormFieldName] => "Default",
            "#"       => "Custom",        
            "#F0F8FF" => "AliceBlue",
            "#FAEBD7" => "AntiqueWhite",
            "#00FFFF" => "Aqua",
            "#7FFFD4" => "Aquamarine",
            "#F0FFFF" => "Azure",
            "#F5F5DC" => "Beige",
            "#FFE4C4" => "Bisque",
            "#000000" => "Black",
            "#FFEBCD" => "BlanchedAlmond",
            "#0000FF" => "Blue",
            "#8A2BE2" => "BlueViolet",
            "#A52A2A" => "Brown",
            "#DEB887" => "BurlyWood",
            "#5F9EA0" => "CadetBlue",
            "#7FFF00" => "Chartreuse",
            "#D2691E" => "Chocolate",
            "#FF7F50" => "Coral",
            "#6495ED" => "CornflowerBlue",
            "#FFF8DC" => "Cornsilk",
            "#DC143C" => "Crimson",
            "#00FFFF" => "Cyan",
            "#00008B" => "DarkBlue",
            "#008B8B" => "DarkCyan",
            "#B8860B" => "DarkGoldenRod",
            "#A9A9A9" => "DarkGray",
            "#006400" => "DarkGreen",
            "#BDB76B" => "DarkKhaki",
            "#8B008B" => "DarkMagenta",
            "#556B2F" => "DarkOliveGreen",
            "#FF8C00" => "DarkOrange",
            "#9932CC" => "DarkOrchid",
            "#8B0000" => "DarkRed",
            "#E9967A" => "DarkSalmon",
            "#8FBC8F" => "DarkSeaGreen",
            "#483D8B" => "DarkSlateBlue",
            "#2F4F4F" => "DarkSlateGray",
            "#00CED1" => "DarkTurquoise",
            "#9400D3" => "DarkViolet",
            "#FF1493" => "DeepPink",
            "#00BFFF" => "DeepSkyBlue",
            "#696969" => "DimGray",
            "#1E90FF" => "DodgerBlue",
            "#D19275" => "Feldspar",
            "#B22222" => "FireBrick",
            "#FFFAF0" => "FloralWhite",
            "#228B22" => "ForestGreen",
            "#FF00FF" => "Fuchsia",
            "#DCDCDC" => "Gainsboro",
            "#F8F8FF" => "GhostWhite",
            "#FFD700" => "Gold",
            "#DAA520" => "GoldenRod",
            "#808080" => "Gray",
            "#008000" => "Green",
            "#ADFF2F" => "GreenYellow",
            "#F0FFF0" => "HoneyDew",
            "#FF69B4" => "HotPink",
            "#CD5C5C" => "IndianRed",
            "#4B0082" => "Indigo",
            "#FFFFF0" => "Ivory",
            "#F0E68C" => "Khaki",
            "#E6E6FA" => "Lavender",
            "#FFF0F5" => "LavenderBlush",
            "#7CFC00" => "LawnGreen",
            "#FFFACD" => "LemonChiffon",
            "#ADD8E6" => "LightBlue",
            "#F08080" => "LightCoral",
            "#E0FFFF" => "LightCyan",
            "#FAFAD2" => "LightGoldenRodYellow",
            "#D3D3D3" => "LightGrey",
            "#90EE90" => "LightGreen",
            "#FFB6C1" => "LightPink",
            "#FFA07A" => "LightSalmon",
            "#20B2AA" => "LightSeaGreen",
            "#87CEFA" => "LightSkyBlue",
            "#8470FF" => "LightSlateBlue",
            "#778899" => "LightSlateGray",
            "#B0C4DE" => "LightSteelBlue",
            "#FFFFE0" => "LightYellow",
            "#00FF00" => "Lime",
            "#32CD32" => "LimeGreen",
            "#FAF0E6" => "Linen",
            "#FF00FF" => "Magenta",
            "#800000" => "Maroon",
            "#66CDAA" => "MediumAquaMarine",
            "#0000CD" => "MediumBlue",
            "#BA55D3" => "MediumOrchid",
            "#9370D8" => "MediumPurple",
            "#3CB371" => "MediumSeaGreen",
            "#7B68EE" => "MediumSlateBlue",
            "#00FA9A" => "MediumSpringGreen",
            "#48D1CC" => "MediumTurquoise",
            "#C71585" => "MediumVioletRed",
            "#191970" => "MidnightBlue",
            "#F5FFFA" => "MintCream",
            "#FFE4E1" => "MistyRose",
            "#FFE4B5" => "Moccasin",
            "#FFDEAD" => "NavajoWhite",
            "#000080" => "Navy",
            "#FDF5E6" => "OldLace",
            "#808000" => "Olive",
            "#6B8E23" => "OliveDrab",
            "#FFA500" => "Orange",
            "#FF4500" => "OrangeRed",
            "#DA70D6" => "Orchid",
            "#EEE8AA" => "PaleGoldenRod",
            "#98FB98" => "PaleGreen",
            "#AFEEEE" => "PaleTurquoise",
            "#D87093" => "PaleVioletRed",
            "#FFEFD5" => "PapayaWhip",
            "#FFDAB9" => "PeachPuff",
            "#CD853F" => "Peru",
            "#FFC0CB" => "Pink",
            "#DDA0DD" => "Plum",
            "#B0E0E6" => "PowderBlue",
            "#800080" => "Purple",
            "#FF0000" => "Red",
            "#BC8F8F" => "RosyBrown",
            "#4169E1" => "RoyalBlue",
            "#8B4513" => "SaddleBrown",
            "#FA8072" => "Salmon",
            "#F4A460" => "SandyBrown",
            "#2E8B57" => "SeaGreen",
            "#FFF5EE" => "SeaShell",
            "#A0522D" => "Sienna",
            "#C0C0C0" => "Silver",
            "#87CEEB" => "SkyBlue",
            "#6A5ACD" => "SlateBlue",
            "#708090" => "SlateGray",
            "#FFFAFA" => "Snow",
            "#00FF7F" => "SpringGreen",
            "#4682B4" => "SteelBlue",
            "#D2B48C" => "Tan",
            "#008080" => "Teal",
            "#D8BFD8" => "Thistle",
            "#FF6347" => "Tomato",
            "#40E0D0" => "Turquoise",
            "#EE82EE" => "Violet",
            "#D02090" => "VioletRed",
            "#F5DEB3" => "Wheat",
            "#FFFFFF" => "White",
            "#F5F5F5" => "WhiteSmoke",
            "#FFFF00" => "Yellow",
            "#9ACD32" => "YellowGreen",
            );

    # retrieve current value for field
    $CurrentValue = GetCurrentColorValue($FormFieldName);

    # display option list
    PrintOptionList($FormFieldName."Select", $ColorList, $CurrentValue,
                    "", 1, 1, false, 
                    "document.SystemColors.".$FormFieldName.".value = this.value;");
}

function PrintErrorMessagesAsUList()
{
    global $ErrorMessages;

    print($ErrorMessages->GetMessagesAsUList());
}

function ErrorsWereFound()
{
    global $ErrorMessages;

    return $ErrorMessages->HasErrors();
}

function FormFieldHadError($FormFieldName)
{
    global $ErrorMessages;

    return strlen($ErrorMessages->GetMessageForField($FormFieldName)) ? TRUE : FALSE;
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

# grab error message list (or create empty list if none available)
$ErrorMessages = $Session->Get("ErrorMessages");
if (!isset($ErrorMessages)) {  $ErrorMessages =& new ErrorList();  }


include("include/SPT--StandardHtmlPageLoad.php");

?>
