<?php

#
#   FILE:  SPT--TrackUserComments.php
#
#   FUNCTIONS PROVIDED:
#     - PrintPrevUserCommentLink()
#     - PrintNextUserCommentLink()
#     - NextUserCommentsAvailable()
#     - PreviousUserCommentsAvailable()
#     - PrintNumberOfUserComments()
#     - PrintUserCommentsTableRows()
#
#   FUNCTIONS EXPECTED:
#     - PrintForumMessage()
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--Message.php");

PageTitle("Track User Comments");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintPrevUserCommentLink()
{
    global $SysConfig;
    global $_GET;

    if (isset($_GET["UserCommentOffset"]))
        $UserCommentOffset = $_GET["UserCommentOffset"];
    else
        $UserCommentOffset = 0;

    $NumUserComments = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $UserCommentOffset + $NumUserComments;

    print "SPT--TrackUserComments.php?UserCommentOffset=$Offset";
}

function PrintNextUserCommentLink()
{
    global $SysConfig;
    global $_GET;

    if (isset($_GET["UserCommentOffset"]))
        $UserCommentOffset = $_GET["UserCommentOffset"];
    else
        $UserCommentOffset = 0;

    $NumUserComments = $SysConfig->NumAnnounceOnHomePage();
    $Offset = $UserCommentOffset - $NumUserComments;

    print "SPT--TrackUserComments.php?UserCommentOffset=$Offset";
}

function NextUserCommentsAvailable()
{
    global $SysConfig;
    global $_GET;

    if (isset($_GET["UserCommentOffset"]))
        $UserCommentOffset = $_GET["UserCommentOffset"];
    else
        $UserCommentOffset = 0;
    
    $NumUserComments = $SysConfig->NumAnnounceOnHomePage();
    return ($UserCommentOffset >= $NumUserComments) ? TRUE : FALSE;
}

function PreviousUserCommentsAvailable()
{
    global $MoreUserComments;
    return $MoreUserComments;
}

function PrintNumberOfUserComments()
{
    print "10";
}

function PrintUserCommentsTableRows()
{
    global $User;
    global $DB;
	global $SysConfig;
	global $MoreUserComments;
    global $_GET;

    if (isset($_GET["UserCommentOffset"]))
        $UserCommentOffset = $_GET["UserCommentOffset"];
    else
        $UserCommentOffset = 0;
        
    # if function to supply announcement DB query is available
    if (function_exists("SupplyUserCommentDisplayQuery"))
    {
        # obtain query from function
        $DisplayQuery = SupplyUserCommentDisplayQuery(
                $MaxNumberOfDaysToGoBackForUserComments, 10);
    }
    else
    {
        # use default query
        $DisplayQuery = "SELECT * FROM Messages "
                ."WHERE ParentId > 0 "
                ."AND ParentType = 2 "
                ."ORDER BY DatePosted DESC "
                ."LIMIT ${UserCommentOffset}, "
                ."999999999";
    }

    # query database for appropriate announcements
    $UserCommentDB = new SPTDatabase();
    $UserCommentDB->Query($DisplayQuery);

    # determine number of announcements to display
    $MaxNumberOfUserCommentsToDisplay=min(10,
        $UserCommentDB->NumRowsSelected());

    # determine if previous link should be displayed or not
    $MoreUserComments = ($UserCommentDB->NumRowsSelected() <=
            $MaxNumberOfUserCommentsToDisplay) ? false : true;

    # if announcements found
    if ($UserCommentDB->NumRowsSelected() > 0)
    {
        $Index = 0;
        # for each announcement
        while ($Index++ < $MaxNumberOfUserCommentsToDisplay)
        {
            $UserComment = $UserCommentDB->FetchNextRowArray();
            
            # format date for display
            $DatePosted = date("M j", strtotime($UserComment["DatePosted"]));

            # get name of person who posted announcement
            $Poster =& new User($DB, (int)$UserComment["PosterId"]);
            $PosterName = $Poster->Get("UserName");
            $PosterEmail = $Poster->Get("EMail");
            if (strlen($PosterName) < 1) {  $PosterName = "(unknown)";  }

            $ResourceId = $UserComment["ParentId"];
            $Resource = & new Resource($ResourceId);

            $Subject = $UserComment["Subject"]." (<b>Resource:</b> ".
                "<a href=\"SPT--FullRecord.php?ResourceId=".
                $ResourceId."\">".$Resource->Get("Title")."</a>)";

            # print comment
            PrintForumMessage(
                    $Subject, 
                    $UserComment["Body"],
                    $DatePosted,
                    $PosterName,
                    $PosterEmail,
                    0,
                    NULL,
                    NULL,
                    TRUE);
        }
    }
    else
    {
        # print row with "no announcements" notice
        PrintNoUserCommentsMessage();
    }
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization( PRIV_USERADMIN, PRIV_SYSADMIN );
include("include/SPT--StandardHtmlPageLoad.php");

?>
